*
* $Id: dspkn2.F,v 1.1.1.1 1996/04/01 15:02:25 mclareni Exp $
*
* $Log: dspkn2.F,v $
* Revision 1.1.1.1  1996/04/01 15:02:25  mclareni
* Mathlib gen
*
*
      SUBROUTINE DSPKN2(KX,KY,MX,MY,AX,BX,AY,BY,TX,TY,NERR)
*
* $Id: imp64.inc,v 1.1.1.1 1996/04/01 15:02:59 mclareni Exp $
*
* $Log: imp64.inc,v $
* Revision 1.1.1.1  1996/04/01 15:02:59  mclareni
* Mathlib gen
*
*
* imp64.inc
*
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION TX(*),TY(*)
      CHARACTER NAME*(*)
      CHARACTER*80 ERRTXT
      PARAMETER (NAME = 'DSPKN2')
************************************************************************
*   NORBAS, VERSION: 15.03.1993
************************************************************************
*
*   DSPKN2 COMPUTES TWO SETS OF MX (MX >= 2*KX+2) AND MY (MY >= 2*KY+2)
*   SPLINE-KNOTS IN THE INTERVAL  AX <= X <= BX  AND  AY <= Y <= BY
*   AS KNOTS FOR NORMALIZED B-SPLINES OF DEGREE  KX  (0 <= KX <= 25) AND
*   KY  (0 <= KY <= 25), RESPECTIVELY.
*   THE FIRST (KX+1) KNOTS OF TX ARE EQUAL TO AX, THE LAST (KX+1) KNOTS
*   OF TX ARE EQUAL TO BX, AND THE OTHER KNOTS OF TX ARE EQUIDISTANT.
*   A CORRESPONDING CHARACTERISTIC HOLDS FOR SET OF KNOTS TY IN
*   Y-DIRECTION.
*
*   PARAMETERS:
*
*   KX   (INTEGER) DEGREE OF B-SPLINES IN X-DIRECTION.
*   KY   (INTEGER) DEGREE OF B-SPLINES IN Y-DIRECTION.
*   MX   (INTEGER) NUMBER OF KNOTS IN THE INTERVAL  AX <= X <= BX.
*   MY   (INTEGER) NUMBER OF KNOTS IN THE INTERVAL  AY <= Y <= BY.
*   AX   (DOUBLE PRECISION) LEFT  ENDPOINT OF X-INTERVAL
*   BX   (DOUBLE PRECISION) RIGHT ENDPOINT OF X-INTERVAL
*   AY   (DOUBLE PRECISION) LEFT  ENDPOINT OF Y-INTERVAL
*   BY   (DOUBLE PRECISION) RIGHT ENDPOINT OF Y-INTERVAL
*   TX   (DOUBLE RECISION) ARRAY OF AT LEAST ORDER MX CONTAINING THE
*         KNOTS OVER THE X-INTERVAL, ON EXIT.
*   TY   (DOUBLE RECISION) ARRAY OF AT LEAST ORDER MY CONTAINING THE
*         KNOTS OVER THE Y-INTERVAL, ON EXIT.
*   NERR (INTEGER) ERROR INDICATOR. ON EXIT:
*        = 0: NO ERROR DETECTED
*        = 1: AT LEAST ONE OF THE CONSTANTS  KX, KY, MX, MY  IS ILLEGAL
*
*   USAGE:
*
*       THE USER HAS TO PROVIDE KX, KY, MX, MY, AX, BX, AY, BY.
*       ON RETURN THE ARRAYS  TX  AND  TY  CONTAIN THE DESIRED KNOTS IN
*       ASCENDING ORDER.
*
*   ERROR MESSAGES:
*
*   IF ONE OF THE FOLLOWING RELATION IS SATISFIED BY THE CHOSEN INPUT-
*   PARAMETERS THE PROGRAM RETURNS, AND AN ERROR MESSAGE IS PRINTED:
*     KX < 0       OR   KX > 25      OR   KY < 0    OR    KY > 25  OR
*     MX < 2*KX+2  OR   MY < 2*KY+2  OR
*     BX <= AX     OR   BY <= AY .
*
*   ********************************************************************
      NERR=1
      IF(KX .LT. 0 .OR. KX .GT. 25) THEN
       WRITE(ERRTXT,101) 'KX',KX
       CALL MTLPRT(NAME,'E210.1',ERRTXT)
      ELSEIF(KY .LT. 0 .OR. KY .GT. 25) THEN
       WRITE(ERRTXT,101) 'KY',KY
       CALL MTLPRT(NAME,'E210.1',ERRTXT)
      ELSEIF(MX .LT. 2*KX+2) THEN
       WRITE(ERRTXT,101) 'MX',MX
       CALL MTLPRT(NAME,'E210.2',ERRTXT)
      ELSEIF(MY .LT. 2*KY+2) THEN
       WRITE(ERRTXT,101) 'MY',MY
       CALL MTLPRT(NAME,'E210.2',ERRTXT)
      ELSEIF(BX .LE. AX) THEN
       WRITE(ERRTXT,103) 'AX',AX,'BX',BX
       CALL MTLPRT(NAME,'E210.7',ERRTXT)
      ELSEIF(BY .LE. AY) THEN
       WRITE(ERRTXT,103) 'AY',AY,'BY',BY
       CALL MTLPRT(NAME,'E210.7',ERRTXT)
      ELSE
       NERR=0
       DX=(BX-AX)/(MX-2*KX-1)
       DY=(BY-AY)/(MY-2*KY-1)
       CALL DVSET(KX+1,AX,TX(1),TX(2))
       CALL DVSET(KX+1,BX,TX(MX-KX),TX(MX-KX+1))
       DO 10 I = KX+2,MX-KX-1
   10  TX(I)=AX+DX*(I-KX-1)
       CALL DVSET(KY+1,AY,TY(1),TY(2))
       CALL DVSET(KY+1,BY,TY(MY-KY),TY(MY-KY+1))
       DO 20 I = KY+2,MY-KY-1
   20  TY(I)=AY+DY*(I-KY-1)
      ENDIF
      RETURN
  101 FORMAT(1X,A5,' =',I6,'   NOT IN RANGE')
  103 FORMAT(1X,A5,' =',1PD15.8,A7,' =',1PD15.8,'   INCONSISTENT')
      END
