/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)bsdinst.c	1.4 09/23/92 CERN CN-SW/DC fhe";
#endif /* not lint */

/* install.c    multi-architecture BSD-like install                     */

/*
 * syntax : install [-m mode] [-o owner] [-g group] source destination
 *
 * This will in turn call the local install program
 */

#include <stdio.h>                      /* Standard input/output        */
#include <errno.h>                      /* Error numbers and codes      */
#if defined(sgi) || defined(_AIX)
#include <sys/types.h>                  /* System types and macros      */
#include <sys/stat.h>                   /* file status information      */
#include <string.h>                     /* String operation defs        */
#endif /* sgi || AIX */

static char     buf[1024];              /* To hold command string       */

#if defined(sun) || defined(ultrix) || defined(sgi) || defined(apollo) || defined(_AIX)
static char     *installcmd = "install";
#endif /* sun || ultrix || sgi || AIX */
#if defined(CRAY) || defined(hpux)
static char     *installcmd = "cpset -o";
#endif /* CRAY || hpux */

main(argc, argv)
int     argc;
char    **argv;
{
	extern int      optind;         /* option argument index        */
	extern char     *optarg;        /* option argument pointer      */
	int             c;              /* character holder             */
	char            *owner = (char *)NULL; /* Owner option          */
	char            *group = (char *)NULL; /* Group option          */
	char            *mode = (char *)NULL;   /* Mode option          */
	int             errflag=0;      /* error flag                   */
	int             debug = 0;      /* debug flag                   */
	char            *source;        /* source file                  */
	char            *dest;          /* destination file or dir      */
#if defined(sgi) || defined(_AIX)
	struct stat     statbuf;        /* stat structure buffer        */
	char            *destdir;       /* destination directory        */
	char            *destfile;      /* destination file             */
	char            *cp;            /* character holder             */
#endif /* sgi || AIX */

/*
 * Build argument string
 */

	while ((c = getopt(argc, argv, "dm:o:g:")) != EOF)     {
		switch(c)       {
			case 'd':       debug++; break;
			case 'm':       mode = optarg; break;
			case 'o':       owner = optarg; break;
			case 'g':       group = optarg; break;
			case '?':       errflag++; break;
		}
	}

	if (argc-optind != 2) errflag++;

	if (errflag)    {
		fprintf(stderr, "usage: %s %s\n", argv[0],
		"[-m mode] [-o owner] [-g group] source destination");
		exit(1);
	}

	source = argv[optind++];
	dest = argv[optind];

	strcpy(buf, installcmd); strcat(buf," ");

#if defined(sun) || defined(ultrix) || defined(apollo)
#if defined(ultrix)
	strcpy(buf," -c ");
#endif /* ultrix */
/* install -m mode -o owner -g group source destination         */
	if (mode)       {
		strcat(buf,"-m "); strcat(buf,mode); strcat(buf, " ");
	}
	if (group)       {
		strcat(buf,"-g "); strcat(buf,group); strcat(buf, " ");
	}
	if (owner)       {
		strcat(buf,"-o "); strcat(buf,owner); strcat(buf, " ");
	}
	strcat(buf, source); strcat(buf," ");
	strcat(buf, dest);
#endif /* sun || ultrix || apollo */
#if defined(CRAY) || defined(hpux)
/* cpset -o object destination [mode [owner [group]]]   */

	strcat(buf, source); strcat(buf," ");
	strcat(buf, dest); strcat(buf," ");
	if (mode)       {
		strcat(buf,mode); strcat(buf, " ");
		if (owner)       {
			strcat(buf,owner); strcat(buf, " ");
			if (group)       {
				strcat(buf,group); strcat(buf, " ");
			}
		}
	}
#endif /* CRAY || hpux*/
#if defined(sgi) || defined(_AIX)
/* install -o -m mode -u owner -g group -src source -f destdir destfile */
	strcat(buf,"-o ");
#endif /* sgi || AIX */
#if defined(sgi) || (defined(_AIX) && defined(_IBMESA))
	if (mode)       {
		strcat(buf,"-m "); strcat(buf,mode); strcat(buf, " ");
	}
	if (group)       {
		strcat(buf,"-g "); strcat(buf,group); strcat(buf, " ");
	}
	if (owner)       {
		strcat(buf,"-u "); strcat(buf,owner); strcat(buf, " ");
	}
#endif /* sgi */
#if defined(_AIX) && defined(_IBMR2)
        if (mode)       {
                strcat(buf,"-M "); strcat(buf,mode); strcat(buf, " ");
        }
        if (group)       {
                strcat(buf,"-G "); strcat(buf,group); strcat(buf, " ");
        }
        if (owner)       {
                strcat(buf,"-O "); strcat(buf,owner); strcat(buf, " ");
        }
#endif /* AIX */
#if defined(sgi) || defined(_AIX)
/*
 * if destination is a not a directory, we've to extract the directory
 * and the filename. Try to do our best, as the directory may not exist
 */

	if (stat(dest, &statbuf) < 0) {
		if (errno != ENOENT)    {
			fprintf(stderr,"unable to stat %s\n", dest);
			perror(dest);
			exit(1);
		}
	}
	if (statbuf.st_mode & S_IFDIR) {
		destdir = dest;
		destfile = source;
	}
	else    {
		if ((cp = strrchr(dest,'/')) == (char *)NULL)    {
			destdir = ".";
			destfile = dest;
		}
		else    {
			destdir = dest; *cp = '\0';
			destfile = ++cp;
		}
	}
#endif /* sgi || AIX */
#if defined(sgi)
	strcat(buf,"-src "); strcat(buf, source); strcat(buf, " ");
	strcat(buf,"-f "); strcat(buf, destdir); strcat(buf, " ");
	strcat(buf, destfile);
#endif /* sgi */
#if defined(_AIX)
        strcat(buf,"-f "); strcat(buf, destdir); strcat(buf, " ");
        strcat(buf," "); strcat(buf, source); strcat(buf, " ");
#endif /* AIX */
	if (debug)      {
		fprintf(stdout, "will issue: %s\n", buf);
	}
	if (system(buf))        {
		fprintf(stderr,"install failed\n");
		if (errno) perror(installcmd);
		exit(1);
	}
}
