/*
 * Copyright (C) 1990-1997 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tmstat.c	1.3 05/22/97 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	tmstat - request list of current TMS requests from tmsdaemon */

#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>
#include "tms.h"

main(argc, argv)
int	argc;
char	**argv;
{
	static char tmsmtyp[8][9] = {"verify", "waiting", "complete", "cancel", "cancel", "cancel", "cancel", "pending"};
	struct stat st;
	struct tm *tm;
	struct tmsmreq *tmrp, *p;
	int c, n, nreq;
	char *ctime();
	time_t current_time;
	char ring[4];
	int trfd;
	int aflg = 0;
	int dflg = 0;
	int errflg = 0;
	int hdrprinted = 0;

	while ((c = getopt (argc, argv, "ad")) != EOF) {
		switch (c) {
		case 'a':
			aflg = 1;
			break;
		case 'd':
			dflg = 1;
			break;
		case '?':
			errflg++;
			break;
		}
	}
	if (errflg) {
		usage (argv[0]);
		exit(1);
	}
	time (&current_time);		/* Get current time */
	if (dflg) 
		printf ("%s", ctime (&current_time));
	trfd = open (REQFILE, O_RDONLY);
	fstat (trfd, &st);
	if (st.st_size == 0) {
		close (trfd);
		return;
	}
	tmrp = (struct tmsmreq *) calloc (1, st.st_size);
	nreq = st.st_size / sizeof(struct tmsmreq);
	read (trfd, tmrp, st.st_size);
	close (trfd);
	for (n = 0, p = tmrp; n < nreq; n++, p++) {
		if (!aflg && (p->type == TMVERIFY ||
		    (p->type == TMUNLOCKV && p->req_time + 60 < current_time)))
			continue;
		if (p->mode == 'W')
			strcpy (ring, "in");
		else
			strcpy (ring, "out");
		tm = localtime (&p->req_time);
		if (hdrprinted++ == 0) {
			printf ("time      jobid uniqid  logonid  unit     ring mount    ");
			printf ("vid    library rack/slot\n");
		}
		printf ("%02d:%02d:%02d %6d %-7s %-8s %-8s %-3s  %-8s %-6s %-8s %-8s\n",
			tm->tm_hour, tm->tm_min, tm->tm_sec,
			p->jid, p->uniqueid, p->logonid, p->unit, ring,
			tmsmtyp[p->type], p->vid, p->library, p->rackslot);
	}
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "[-a]\n");
}
