/*
 * Copyright (C) 1990-1999 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)usrlbl.c	1.21 06/25/99 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	usrlbl - user callable routines to read/write header and trailer labels */
#include <errno.h>
#include <stdio.h>
#include <sys/types.h>
#if defined(hpux) || defined(sgi) || defined(linux)
#include <sys/mtio.h>
#endif
#if defined(__alpha) && defined(__osf__)
#include <sys/ioctl.h>
#include <sys/mtio.h>
#endif
#include "tape.h"

/*	setdevtype - set flags for optimization of label processing routines
		according to device type and density */
static int dev1tm = 0;		/* by default, write 2 tapemarks at EOI */
static int rewritetm = 1;	/* An Exabyte 8200 must be positionned on the
			BOT side of a long filemark before starting to write */
setdevtype (devtype, den)
char *devtype;
char *den;
{
	if (strncmp (devtype, "DLT", 3) == 0 || strcmp (devtype, "3590") == 0 ||
	    strcmp (devtype, "SD3") == 0 || strcmp (devtype, "9840") == 0)
		dev1tm = 1;	/* one TM at EOI is enough */
	if (strcmp (devtype, "8200") && strcmp (den, "8200") && strcmp (den, "8200C"))
		rewritetm = 0;
}

/*	checkeofeov - check for EOF or EOV */
/*	return	-errno	in case of error
 *		-ETLBL	for bad label structure
 *		0	for EOF
 *		ETEOV	for EOV
 */
checkeofeov (tapefd, path)
int	tapefd;
char	*path;
{
	int c;
	int fseq;
	char hdr1[LBLBUFSZ], hdr2[81];
	char labeltype;
	char Tflag;
	char vol1[81];

	if ((c = getlabelinfo (path, vol1, hdr1, hdr2, &fseq, &labeltype, &Tflag)) < 0)
		return (c);
	if ((c = readlbl (tapefd, path, hdr1)) < 0)
		if (Tflag == 'T')
			return (0);
		else
			return (c);
	if (labeltype == 'n' || labeltype == 'b') {	/* tape is unlabelled */
		if (c > 1) {	/* last file on this tape */
			if ((c = skiptpfb (tapefd, path, 1)) < 0) return (c);
			return (ETEOV);
		}
	} else {	/* tape is labelled */
		if (c) {
			if (Tflag == 'T') return (0);
			errno = ETLBL;
			return (-ETLBL);
		}
		if (labeltype == 's') ebc2asc (hdr1, 80);
		if (strncmp (hdr1, "EOV1", 4) == 0) return (ETEOV);
		if (strncmp (hdr1, "EOF1", 4)) {
			errno = ETLBL;
			return (-ETLBL);
		}
	}
	if ((c = skiptpfb (tapefd, path, 1)) < 0) return (c);
	if ((c = skiptpff (tapefd, path, 1)) < 0) return (c);
	return (0);
}

/*	wrthdrlbl - write header labels */
wrthdrlbl (tapefd, path)
int	tapefd;
char	*path;
{
	int c;
	int fsec;
	int fseq;
	char hdr1[81], hdr2[81];
	char labeltype;
	char Tflag;
	char vol1[81];

	if ((c = getlabelinfo (path, vol1, hdr1, hdr2, &fseq, &labeltype, &Tflag)) < 0)
		return (c);
	if (labeltype != 'n')	/* tape is labelled */
		sscanf (hdr1 + 27, "%4d", &fsec);
	else
		fsec = 1;
	if (fsec == 1 && fseq != 1 && rewritetm)
		if ((c = wrttpmrk (tapefd, path, 1)) < 0) return (c);
	if (labeltype == 'n') return (0);	/* tape is unlabelled */
	if (fseq == 1) {
		if (labeltype == 's') asc2ebc (vol1, 80);
		if ((c = writelbl (tapefd, path, vol1)) < 0) return (c);
	}
	if (labeltype == 's') asc2ebc (hdr1, 80);
	if ((c = writelbl (tapefd, path, hdr1)) < 0) return (c);
	if (labeltype == 's') asc2ebc (hdr2, 80);
	if ((c = writelbl (tapefd, path, hdr2)) < 0) return (c);
	return (wrttpmrk (tapefd, path, 1));
}

/*	wrttrllbl - write trailer labels */
wrttrllbl (tapefd, path, labelid, nblocks)
int	tapefd;
char	*path;
char	*labelid;
int	nblocks;
{
	char buf[7];
	int c;
	int fseq;
	char hdr1[81], hdr2[81];
	char labeltype;
	char Tflag;
	char vol1[81];
#if defined(hpux) || defined(linux)
	struct mtget mt_info;
#endif
#if defined(__alpha) && defined(__osf__)
	struct mtop mtop;
#endif

	if ((c = getlabelinfo (path, vol1, hdr1, hdr2, &fseq, &labeltype, &Tflag)) < 0)
		return (c);
	if (labeltype == 'n') return (wrteotmrk (tapefd, path));	/* tape is unlabelled */
	if ((c = wrttpmrk (tapefd, path, 1)) < 0) return (c);

	memcpy (hdr1, labelid, 3);
	sprintf (buf, "%.6d", nblocks);
	memcpy (hdr1 + 54, buf, 6);
	memcpy (hdr2, labelid, 3);

	if (labeltype == 's') asc2ebc (hdr1, 80);
#if defined(hpux) || defined(linux)
	/* Please note that under Linux, this call is not necessary here
	because the previous writing of filemark has already cleared the
	EOT condition */
	if (labelid[2] == 'V')	/* must clear EOT condition */
		c = ioctl (tapefd, MTIOCGET, &mt_info);
#endif
#if defined(__alpha) && defined(__osf__)
	if (labelid[2] == 'V') {
		mtop.mt_op = MTCSE;     /* Clears serious exception */
		mtop.mt_count = 1;
		c = ioctl (tapefd, MTIOCTOP, &mtop);
	}
#endif
#if sgi
	if (labelid[2] == 'V')
		c = ioctl (tapefd, MTANSI, 1);
#endif
	if ((c = writelbl (tapefd, path, hdr1)) < 0) return (c);
	if (labeltype == 's') asc2ebc (hdr2, 80);
#if defined(hpux) || defined(linux)
	if (labelid[2] == 'V')	/* must clear EOT condition */
		c = ioctl (tapefd, MTIOCGET, &mt_info);
#endif
#if defined(__alpha) && defined(__osf__)
	if (labelid[2] == 'V') {
		mtop.mt_op = MTCSE;     /* Clears serious exception */
		mtop.mt_count = 1;
		c = ioctl (tapefd, MTIOCTOP, &mtop);
	}
#endif
	if ((c = writelbl (tapefd, path, hdr2)) < 0) return (c);
#if sun
	if (c == 0)	/* 1st try for EOV2 on Desktop SPARC & SPARC System 600 */
		if ((c = writelbl (tapefd, path, hdr2)) < 0) return (c);
#endif
	return (wrteotmrk (tapefd, path));
}

/*	deltpfil - delete current tape file */
deltpfil (tapefd, path)
int	tapefd;
char	*path;
{
	int c;
	int fseq;
	char hdr1[81], hdr2[81];
	char labeltype;
	char Tflag;
	char vol1[81];

	if ((c = getlabelinfo (path, vol1, hdr1, hdr2, &fseq, &labeltype, &Tflag)) < 0)
		return (c);
	if (fseq == 1) {
		if ((c = rwndtape (tapefd, path)) < 0) return (c);
		if (labeltype != 'n') {

			/* set expiration date = creation date */

			memcpy (hdr1 + 47, hdr1 + 41, 6);

			if (labeltype == 's') asc2ebc (vol1, 80);
			if ((c = writelbl (tapefd, path, vol1)) < 0) return (c);
			if (labeltype == 's') asc2ebc (hdr1, 80);
			if ((c = writelbl (tapefd, path, hdr1)) < 0) return (c);
			if (labeltype == 's') asc2ebc (hdr2, 80);
			if ((c = writelbl (tapefd, path, hdr2)) < 0) return (c);
		}
	} else {
		if ((c = skiptpfb (tapefd, path, labeltype == 'n' ? 1:2)) < 0) return (c);
	}
	return (wrteotmrk (tapefd, path));
}

wrteotmrk(tapefd, path)
int tapefd;
char *path;
{
	int c;

	if (! dev1tm) {
		/* write 2 tape marks */
		if ((c = wrttpmrk (tapefd, path, 1)) < 0) return (c);
		if ((c = wrttpmrk (tapefd, path, 1)) < 0) return (c);
		/* for Exabytes in 8200 mode, position in front of the 2 tapemarks,
		   otherwise position between the 2 tapemarks */
		if ((c = skiptpfb (tapefd, path, rewritetm+1)) < 0) return (c);
	} else {
		/* write 1 tape mark */
		if ((c = wrttpmrk (tapefd, path, 1)) < 0) return (c);
		/* flush the buffer */
		if ((c = wrttpmrk (tapefd, path, 0)) < 0) return (c);
	}
	return (0);
}
