/*
 * Copyright (C) 1990-1998 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)unloadtps.c	1.28 10/28/98 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#if sgi || sun || ultrix
#include <sys/termio.h>
#endif
#include <sys/time.h>
#if defined(_AIX) && defined(_IBMR2)
#include <sys/select.h>
#endif
#include "tape.h"
#if SACCT
#include "../h/sacct.h"
#endif
#if !defined(linux)
extern char *sys_errlist[];
#endif
char *dvrname;
int fhs_mount_failed;
char func[16];
struct freeunt fureq;
char hostname[MAXHOSTNAMELEN];
int jid;
int maxfds;
char msg[OPRMSGSZ];
char orepbuf[OPRMSGSZ];
fd_set readmask;
struct tpdrep rep;
char repbuf[133];
#if TMS || FHS
struct  vsn_req vrqp;
#endif

main(argc, argv)
int	argc;
char	**argv;
{
	char *acctname, *devtype, *dgn, *dvn, *loader, *nqsid, *rpn, *unm, *vid;
	int den;
	gid_t gid;
	int keeprsv, ux;
	uid_t uid;

	int c, n;
	unsigned int demountforce;
	int sonyraw;
	int tapefd;

	ENTRY (unloadtps);

	unm = argv[1];
	vid = argv[2];
	dvn = argv[3];
	rpn = argv[4];
	uid = atoi (argv[5]);
	gid = atoi (argv[6]);
	acctname = argv[7];
	jid = atoi (argv[8]);
	nqsid = argv[9];
	ux = atoi(argv[10]);
	keeprsv = atoi(argv[11]);
	dgn = argv[12];
	devtype = argv[13];
	dvrname = argv[14];
	loader = argv[15];
	den = atoi(argv[16]);
#if SONYRAW
	if (strcmp (devtype, "DIR1") == 0 && den == SRAW)
		sonyraw = 1;
	else
		sonyraw = 0;
#endif

#if ultrix || sun || sgi
        c = open ("/dev/tty", O_RDWR);
        if (c >= 0) {
                ioctl (c, TIOCNOTTY, 0);
                (void) close (c);
        }
#endif
#if TMS || FHS
	vrqp.num = 1;
	vrqp.uid = uid;
	vrqp.gid = gid;
	vrqp.mode = 0;
        vrqp.vsn[0][0] = '\0';
	strcpy (vrqp.vid[0], vid);
        strcpy (vrqp.acctname, acctname);
	vrqp.jid = jid;
	strcpy (vrqp.nqsid, nqsid);
	strcpy (vrqp.dvn, unm);
	vrqp.path[0] = '\0';
#endif
	if (*vid == '\0')	/* mount req failed or killed */
		goto reply;	/* before volume was requested on drive */
	gethostname (hostname, MAXHOSTNAMELEN);

        /* initialize for select */

#if defined(ultrix) || (defined(sun) && !defined(SOLARIS)) || defined(linux)
        maxfds = getdtablesize();
#else
        maxfds = _NFILE;
#endif
        FD_ZERO (&readmask);
unload_loop:
#if SONYRAW
    if (! sonyraw) {
#endif
#if defined(ADSTAR)
	while ((tapefd = open (dvn, O_RDONLY|O_NDELAY)) < 0 &&
	    (errno == EBUSY || errno == EAGAIN))
#else
#ifndef SOLARIS25
	while ((tapefd = open (dvn, O_RDONLY|O_NDELAY)) < 0 && errno == EBUSY)
#else
	while ((tapefd = open (dvn, O_RDONLY)) < 0 && errno == EBUSY)
#endif
#endif
		sleep (UCHECKI);
	if (tapefd >= 0) {
		if (strcmp (devtype, "3480") == 0 ||
		    strcmp (devtype, "9840") == 0 ||
		    strcmp (devtype, "SD3") == 0)
			lddisplay (tapefd, dvn, 0x20, "", "", 0);
		else if (strcmp (devtype, "3590") == 0)
			lddisplay (tapefd, dvn, 0x20, "", "", 1);
		else if (strstr (devtype, "/VB"))
			lddisplay (tapefd, dvn, 0x80, "", "", 2);
		if (chkunitready (tapefd) > 0) {
			if (*loader != 'n')
				if (unldtape (tapefd, dvn) < 0)
					configdown (unm);
#if SACCT
			tapeacct (TPUNLOAD, uid, gid, jid, nqsid, dgn, unm, vid, 0, "");
#endif
		}
		close (tapefd);
	} else {
#if defined(sun)
		if (errno != EIO)
#endif
#if defined(_IBMR2)
		if (strcmp (dvrname, "tape") || (errno != EIO && errno != ENOTREADY))
#endif
			tplogit (func, TP042, dvn, "open", sys_errlist[errno]);
	}
#if SONYRAW
    } else {
	while ((tapefd = open (dvn, O_RDWR|O_NDELAY)) < 0 && errno == EBUSY)
		sleep (UCHECKI);
	if (tapefd >= 0) {
		if (chkunitready_sony (tapefd) > 0) {
			if (unldtape_sony (tapefd, dvn) < 0)
					configdown (unm);
#if SACCT
			tapeacct (TPUNLOAD, uid, gid, jid, nqsid, dgn, unm, vid, 0, "");
#endif
		}
		close (tapefd);
	}
    }
#endif
	c = 0;

	if (*loader != 'm' && *loader != 'f') {
		demountforce = 0;
		do {
			c = rbtdemount (vid, unm, dvn, loader, demountforce);
			if ((n = rbtdmntchk (&c, unm, &demountforce)) < 0)
				goto reply;
		} while (n == 1);
		if (n == 2) goto unload_loop;
	}
#ifdef FHS
	if (loader[0] == 'f')
		c = fhsexit (&vrqp, 3);
#endif
reply:
#ifdef TMS
	c = tmsexit (&vrqp, 3);
#endif

	fureq.rh.size = sizeof(struct freeunt);
	fureq.rh.code = FREEUNT;
	fureq.jid = jid;
	fureq.keeprsv = keeprsv;
	strcpy (fureq.rpn, rpn);
	fureq.ux = ux;
	c = send2tpd (&fureq, NULL, (int *)0);
	if (c < 0) c = -c;
	exit (c);
}

configdown(unm)
char *unm;
{
	struct tpconf confreq;
	int n;

	sprintf (msg, TP033, unm, hostname); /* ops msg */
	omsgr ("configdown", msg, 0);
	memset ((char *)&confreq, 0, sizeof(confreq));
	confreq.rh.size = sizeof(struct tpconf);
	confreq.rh.code = TPCONF;
	confreq.status = 0;	/* down */
	strcpy (confreq.unm[0], unm);
	confreq.count = 1;
	send2tpd (&confreq, repbuf, &n);
}

rbtdmntchk(c, unm, demountforce)
int *c;
char *unm;
unsigned int *demountforce;
{
	fd_set readfds;
	struct timeval rbttimeval;

	switch (*c) {
	case 0:
		return (0);
	case RBT_FAST_RETRY:
		omsgr (func, msg, 0);
		rbttimeval.tv_sec = RBTFASTRI;
		rbttimeval.tv_usec = 0;
		memcpy (&readfds, &readmask, sizeof(readmask));
		if (select (maxfds, &readfds, (fd_set *)0,
		    (fd_set *)0, &rbttimeval) > 0 && testorep (&readfds)) {
			checkorep (func, orepbuf);
			if (strncmp (orepbuf, "cancel", 6) == 0) {
				configdown (unm);
				*c = EIO;
				return (-1);
			}
		}
		return (1);
	case RBT_DMNT_FORCE:
		if (*demountforce) {
			configdown (unm);
			*c = EIO;
			return (-1);
		} else {
			*demountforce = 1;
			return (1);	/* retry */
		}
	case RBT_CONF_DRV_DN:
		configdown (unm);
		*c = EIO;
		return (-1);
	case RBT_OMSG_SLOW_R:
	case RBT_OMSGR:
		omsgr (func, msg, 0);
		checkorep (func, orepbuf);
		if (strncmp (orepbuf, "cancel", 6) == 0) {
			configdown (unm);
			*c = EIO;
			return (-1);
		}
		return (1);	/* retry */
	case RBT_UNLD_DMNT:
		return (2);	/* should unload and retry */
	default:
		configdown (unm);
		return (-1);	/* unrecoverable error */
	}
}
