/*
 * Copyright (C) 1990-1996 by CERN/CN/SW/CU
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tplabel.c	1.10 03/27/96 CERN CN-SW/CU Jean-Philippe Baud";
#endif /* not lint */

/*	tplabel - prelabel al and sl tapes, write 2 tape marks for nl tapes */
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include "tape.h"
extern	int	optind;
extern	char	*optarg;
int jid;
char repbuf[133];
struct	tpmount	req;
#ifdef TMS
struct	vsn_req	vrqp;
#endif

main(argc, argv)
int	argc;
char	**argv;
{
	int c, n;
	void cleanup();
	char *dp;
	int errflg = 0;
	char *getacct();
	char *getenv();
	static char labels[5][4] = {"", "al", "nl", "sl", "blp"};
	int numvid = 0;
	char *p, *q;
	char *strchr();
	char *tempnam();

	jid = findpgrp();
	req.rh.size = sizeof(struct tpmount);
	req.rh.code = TPMOUNT;
	req.uid = getuid();
	req.gid = getgid();
	req.jid = jid;
#ifdef TMS
	p = getacct();
	if (p == NULL) {
		fprintf (stderr, TP027);
		exit (1);
	}
	strcpy (req.acctname, p);
#else
	strcpy (req.acctname, "NOACCT");
#endif
	if ((p = getenv("QSUB_REQID")) != NULL)
		strcpy (req.nqsid, p);
	while ((c = getopt (argc, argv, "D:d:g:H:l:v:")) != EOF) {
		switch (c) {
		case 'D':
			if (req.dvn[0] == '\0') {
				if (strlen(optarg) < sizeof(req.dvn))
					strcpy (req.dvn, optarg);
				else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'd':
			if (req.den == 0) {
				if ((req.den = cvtden (optarg)) <= 0) {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'g':
			if (req.dgn[0] == '\0') {
				if (strlen(optarg) < sizeof(req.dgn))
					strcpy (req.dgn, optarg);
				else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'H':
			if (req.prelabel == 0) {
				req.prelabel = strtol (optarg, &dp, 10);
				if (*dp != '\0' ||
				    req.prelabel < 0 || req.prelabel > 2) {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				} else if (req.prelabel == 0)
					req.prelabel = -1;
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'l':
			if (req.lbl == 0) {
				if (!strcmp (optarg, "al")) req.lbl = AL;
				else if (!strcmp (optarg, "nl")) req.lbl = NL;
				else if (!strcmp (optarg, "sl")) req.lbl = SL;
				else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case 'v':
			if (numvid == 0) {
				p = optarg;
				if (q = strchr (p, '=')) {
					*q++ = '\0';
					if (strlen (q) > 0 && strlen (q) < 7) {
						strcpy (req.vid[numvid], q);
						UPPER (req.vid[numvid]);
					} else {
						fprintf (stderr, TP006, argv[optind-2]);
						errflg++;
					}
				}
				if (strlen (p) > 0 && strlen (p) < 7) {
					strcpy (req.vsn[numvid], p);
					UPPER (req.vsn[numvid]);
				} else {
					fprintf (stderr, TP006, argv[optind-2]);
					errflg++;
				}
				if (req.vid[numvid][0] == '\0')
					strcpy (req.vid[numvid], req.vsn[numvid]);
				numvid++;
				req.numvid = numvid;
			} else {
				fprintf (stderr, TP007, argv[optind-2]);
				errflg++;
			}
			break;
		case '?':
			errflg++;
			break;
		}
	}
	if (req.numvid == 0) {
		fprintf (stderr, TP031);
		errflg++;
	}
	if (errflg) {
		usage (argv[0]);
		exit (ETPRM);
	}

	/* Set default values */

	if (req.dgn[0] == '\0') strcpy (req.dgn, DEFDGN);
	strcpy (req.fid, "PRELABEL");
	req.filstat = 'n';
	req.fseq = 1;
	if (req.lbl == 0) req.lbl = SL;
	strcpy (req.path, tempnam(NULL, "tp"));
	if (req.prelabel == 0) req.prelabel = 1;
	req.ring = IN;

#ifdef TMS
	vrqp.num = req.numvid;
	vrqp.uid = req.uid;
	vrqp.gid = req.gid;
	vrqp.mode = req.ring == IN ? VSN_WRITE : VSN_READ;
	strcpy (vrqp.vsn[0], req.vsn[0]);
	strcpy (vrqp.vid[0], req.vid[0]);
	strcpy (vrqp.acctname, req.acctname);
	vrqp.jid = req.jid;
	strcpy (vrqp.nqsid, req.nqsid);
	vrqp.dvn[0] = '\0';
	strcpy (vrqp.path, req.path);
	strcpy (vrqp.dgn, req.dgn);
	strcpy (vrqp.lbl, labels[req.lbl]);
	c = tmsexit (&vrqp, 0);
	if (c != 0) {
		fprintf (stderr, "%s\n", repbuf);
		tmsexit (&vrqp, 5);
		exit (c);
	}
#endif
	signal (SIGHUP, cleanup);
	signal (SIGINT, cleanup);
	signal (SIGQUIT, cleanup);
	signal (SIGTERM, cleanup);

	while ((c = send2tpd (&req, repbuf, &n)) == ETVBSY) {
		if (req.nretry++ == 0)
			fprintf (stderr, "%s\n", repbuf);
		sleep (VOLBSYRI);
	}
	switch (c) {
	case 0:
		break;
	case ETDNP:
		fprintf (stderr, "%s\n", TP000);
		break;
	case ETSYS:
		fprintf (stderr, "%s\n", TP026);
		break;
	case ETTMO:
		fprintf (stderr, "%s\n", TP001);
		break;
	case ETNDV:
		fprintf (stderr, TP012);
		break;
	case ETIDG:
		fprintf (stderr, TP013);
		break;
	case ETNRS:
		fprintf (stderr, TP014);
		break;
	case ETIDN:
		fprintf (stderr, TP015);
		break;
	default:
		if (n) fprintf (stderr, "%s\n", repbuf);
		break;
	}
	exit (c);
}

void cleanup(sig)
int sig;
{
	int c;
	struct killmnt klmreq;

	signal (sig, SIG_IGN);

	klmreq.rh.size = sizeof(struct killmnt);
	klmreq.rh.code = KILLMNT;
	klmreq.jid = req.jid;
	strcpy (klmreq.path, req.path);
	c = send2tpd (&klmreq, NULL, (int *)0);
	exit (ETINTR);
}

usage(cmd)
char *cmd;
{
	fprintf (stderr, "usage: %s ", cmd);
	fprintf (stderr, "%s%s",
		"[-D device_name] [-d density] [-g device_group_name]\n",
		"[-H number_headers] [-l label_type] [-v volume_serial_number]\n");
}
