.\" @(#)tpdaemon.man	1.7 12/18/97 CERN CN-SW/CU Jean-Philippe Baud
.\" Copyright (C) 1990-1997 by CERN/CN/SW/CU
.\" All rights reserved
.\"
.TH TPDAEMON l "12/18/97"
.SH NAME
tpdaemon \- starts the tape daemon
.SH SYNOPSIS
.B  /usr/local/bin/tpdaemon
.SH DESCRIPTION
.LP
The 
.B tpdaemon
command starts the tape daemon. This will read the configuration file
/etc/TPCONFIG and look for requests. Short requests like
.B tpstat
are processed in the main loop. The daemon forks overlays to execute
long requests like mounting or unloading tapes.
.br
There must be one entry in the configuration file per tape unit giving:
.HP
unit name	as seen by the operators in the mount messages. The name
cannot exceed 8 characters.
.HP
device group	CART, 8200, 8500, DAT, DLT, NTP or SD3 (Redwood)
.HP
device name	as defined in /dev.
The device must not rewind on close and have a Berkeley behaviour.
.HP
density		corresponding to the entry in /dev
.HP
initial status	up or down
.HP
robot/manual	if the unit is defined as part of a
.BR robot ,
there will be no check on the ring status. This field may also be set to
.B fhs
if the unit is managed by the Foreign Host Server (IBM 3495 robot) or
.BI lmcp xxxx
(Library Manager Control Point as defined in /dev)
if the IBM 3494/3495 robot unit is driven directly from the RS 6000.
.HP
device type	for IBM
.B 3480
compatible units, IBM
.BR 3590 ,
STK
.B SD3
(Redwood) or drives equipped with Vision Boxes from Peripheral Vision
.RB ( /VB ) ,
the unit LED display will show, when connected to any platform (Sun/OS and
Ultrix excepted),
the vid requested or mounted or error messages like "wrong ring" or "wrong vsn".
For
.BR DLT s
and
.BR SD3 s
connected to DEC alpha systems or IBM
.BR 3590 s
connected to AIX platforms, fast tape positionning is used.
.TP 0
If a tape unit supports several densities, there must be one line per density.
.SH FILE
Here is an example of a configuration file:

#
.br
# 				Tape configuration
.br
#
.br
# unit	  dev		dev		density		initial	robot/	dev
.br
# name	  group		name		(0 = N/A)	status	manual	type
.br
#
.br
SHIFTST0 CART	/dev/nrmt0	0		up	manual	3480
.br
SHIFTST1 CART	/dev/nrmt1	0		up	manual	3480
.br
SHIFTEX1 8500		/dev/nrmt9	8500		up	manual	8500/VB
