.\" @(#)sfetch.man	1.3 05/12/93  	Felix Hassine CERN CN-SW/DC 
.\" Copyright (C) 1993 by CERN CN-SW/DC
.\" All rights reserved
.\"
.TH SFETCH/SACQUIRE-DISPOSE 1 "23/04/93"
.SH NAME
sfetch/sacquire \- Fetch a remote file from a foreign host
.br
dispose \- Dispose a local file on a foreign host
.SH SYNOPSIS
.B /usr/local/bin/sfetch 
.I local_path 
.I -t text
.I [-v] 
.I [-u user]
.if n .ti +0.5i
.I [-f mode]
.hy
.LP
.br
.B /usr/local/bin/sacquire
.I local_path
.I -t text
.I [-v]
.I [-u user]
.I [-f mode]
.hy
.LP
.br
.B /usr/local/bin/dispose
.I local_path
.I -t text
.I [-v]
.I [-u user]
.I [-f mode]
.SH DESCRIPTION
.IX  "\fLsfetch\fR"
.IX  tcp
sfetch copies a file from a remote site using FTP or RCP.
sacquire copies a file from a remote site using FTP or RCP if it is not already
on the local path.
.br
dispose copies the file specified by the local_path on the path specified with 
option -t 'text'. The syntax supported by dispose is the same as sfetch.
.hy
.LP
These commands enable to fetch/dispose a file from/to another machine to/from
the local host running UNIX. The target machines have to run VM, VMS or UNIX.
sacquire also performs a sfetch. The only difference is the fact that sacquire 
first checks that the requested file does not already exist locally.
.hy
.LP
.SH OPTIONS
.LP
Options may appear in any order, but they all must appear after the path_name.
.RS
.TP
.BI \-v\ 
verbose option. Not used by default. It displays all the internal variables
which have been set after the command line parsing.
.TP
.BI \-u\ user
specify whose account on the target machine is going to be connected by
sfetch/dispose. The default value is the current username.
.TP
.BI \-f\ mode
This option is taken into account only if selected protocol is FTP. Then the
default value is "ASCII" if not specified. The options are:
TB, BB, binary, BINARY, or bin for binary transfer mode or
TC, TR, asc, ascii, or ASCII for ascii transfer mode.
.hy
.LP
.SH CONFIGURATION
The configuration has to specify which UNIX command is going to perform the
fetch, either FTP or RCP. This specification is static for each host and is
specified into the file /etc/sfetch.cf. If it is not, the default protocol is RCP.

When RCP is used the .rhost file is supposed to be correctly set otherwise
the request will be refused.
An alias can be given for one host name by configuring the file /etc/shift.conf.
For example, if a user wants to target the machine "shift6" by specifying a 
target machine "shift-cpu", add the following line:
.br
\ \
	"NET	shift-cpu	shift6"
.hy
.LP
When an FTP is used it is assumed that the read acccess is enabled  and no 
password  is required.
.hy
.LP
.SH EXAMPLES:
.br
FROM UNIX TO UNIX:
.br
.ad l 
.nf
	sfetch local_file -t rt_host:rtfile -u acher
.br
FROM UNIX TO VM:
.br
.ad l
.nf
	sfetch profile.copy -t vm:profile.exec -u acher.191 -f ascii
.br
FROM UNIX TO VMS: 
.br
.ad n 
.nf
	sfetch file -t'rt_host:disk$c3:[user.subdir1.subdir2]filename'
.br
.ad n
	dispose file -t'rt_host::disk$c3:[user.subdir1.subdir2]filename'
.ad
.br
.SH RETRIES:
On failures, sfetch retries the command if entries such as:
.br
SFETCH SFETCHRETRY 10
.br
SFETCH SFETCHSLEEP 60 
.br
are provided into the /etc/shift.conf file. For this example, 10 retries will
be performed and the process is suspended for 60 seconds between each retry.
.br
Users can avoid performing these automatic retries by setting the variable
NORETRY to the value "yes" in their environment.
.br
.SH PORTABILITY
sfetch , sacquire, and dispose have been ported on AIX, HPUX, IRIX, and SUNOS.
The only instruction
to change is the first line which specifies the path to the bourne shell.
.RE
.SH FILES
.B /etc/sfetch.cf
.br
.B /etc/shift.conf
.SH "AUTHORS"
Felix Hassine, CERN-CN Division CH-1211 Geneva 23, Switzerland
(acher@sun2.cern.ch)
.br
Christian Boissat, CERN-CN Division CH-1211 Geneva 23, Switzerland
(boissat@vxcern.cern.ch)

