/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)tptodk.c	2.4 03/08/94 CERN CN-SW/DC Antoine Trannoy";
#endif /* not lint */

/* tptodk.c             SHIFT transferring data from local tape to remote disk.          */

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <sys/file.h>
#include <sys/types.h>

extern char * getconfent() ;
static struct stat statbuf ;

/*
 * Handler for signal SIGPIPE
 */
void hand() { (void) fprintf(stderr," CPTPDSK ! NETWORK ERROR DURING RFIO OPERATION\n") ; 
	      if ( getconfent("RTCOPYD","NETRETRY",0) != NULL && 
		     stat(NOMORETAPES, &statbuf) < 0) 
				exit(SYRETRY) ;
			else
				exit(SYERR) ;
	    }

/*
 * End of transfer
 */
main(argc,argv)
	int     argc ; 
	char ** argv ;
{
	/*
	 * To parse options.
	 */
	extern char * optarg ; 
	extern int    optind ;
	extern long strtol() ;
	char 		* cp ; 
	int 		   c ; 	
	/*
	 *  To log
	 */ 
	char 	     ptr[10] ;		/* Message to log	     */
	char 	      * ifce ;

	/*
	 * To store options.
	 */
	int	  blksiz ;		/* Block size		*/
	int 	    ibas ; 		/* Index base		*/
	char    recfm[4] ;		/* Record format	*/
	int 	   lrecl ;		/* Record length	*/
	int 	   nread ; 		/* Max nb of records	*/

	/*
	 * Buffer
	 */
	char 	    * buffer ;		/* Pointer to buffer	*/
	int	      buflen ; 		/* Buffer length	*/

	/*
	 * Disk file 
	 */
	char * filnam  ;		/* Disk file name	*/
	int filnum= 20 ; 		/* File FORTRAN number	*/

	/*
	 * Tape file 
	 */
	char * tpfil ; 			/* Tape file name	*/
	int	tpfd ;			/* Tape file descriptor	*/

	/*
	 * Counters
	 */
	int	total ; 		/* Total number of bytes transfered	*/
	int	 irec ; 		/* Index of the current record		*/

	/*
	 * Return codes for system call.
	 */
	int 	irc,rc ; 

        /*
         * To store the uid & gid & key of an external user
         */
        char    *special_uid = NULL;
        char    *special_gid = NULL;
        char    *special_key = NULL;
	char 	*reqhost     = NULL;


        (void)signal(SIGPIPE,(void (*)())hand);
	/*
	 * Initialization
	 */
	(void) fprintf(stderr," CPTPDSK -\n") ; 
	ibas  =  0 ; 
	lrecl =  0 ; 
	nread = -1 ; 
	tpfil=NULL ;
	blksiz= 32760  ;
	recfm[0] = 'U' ;
	recfm[1] = 'S' ;
	recfm[2] = 'E' ;
	recfm[3] = ' ' ;
	total= 0 ; 
	irec = 0 ; 

        special_uid=getenv("ORI_UID");
        special_gid=getenv("ORI_GID");
        special_key=getenv("KEY");
	reqhost = getenv("REQHOST");

	/* 
	 * Input parameter analysis
	 */
	while( (c= getopt(argc,argv, "ab:i:t:F:L:N:")) != EOF ) {
		switch(c) {
			case 'a':
				recfm[3]= 'A' ;
				(void) fprintf(stderr," CPTPDSK - APPEND MODE\n") ; 
				break ; 
			case 'b':
				blksiz= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr,"CPTPDSK ! INVALID BLOCK SIZE SPECIFIED\n") ;
					(void) printf("-1\n") ;
					exit(0) ;
				}
				(void) fprintf(stderr," CPTPDSK - BLOCK SIZE: %d\n",blksiz) ; 
				break ; 
			case 'i':
				ibas= (int) strtol(optarg,&cp,10) ;
				if ( * cp != '\0' ) {
					(void) fprintf(stderr,"CPTPDSK ! INVALID PARAMETER\n") ;
					(void) printf("-1\n") ;
					exit(0) ;
				}
				break ; 
			case 't':
				tpfil= optarg ;
				break ; 
			case 'F':
				if ( *optarg == 'U' ) {
					recfm[1]= 'S' ;
				}
				else if ( *optarg == 'F' ) {
					recfm[1]= 'D' ;
				}
				else	{
					(void) fprintf(stderr,"CPTPDSK ! INVALID RECORD FORMAT\n") ;
					(void) printf("-1\n") ; 
					exit(0) ;
				}
				(void) fprintf(stderr," CPTPDSK - RECORD FORMAT: %c%c\n",recfm[0],recfm[1]) ; 
				break ; 
			case 'L':
				lrecl= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr,"CPTPDSK ! INVALID RECORD LENGTH SPECIFIED\n") ;
					(void) printf("-1\n") ;
					exit(0) ;
				}
				(void) fprintf(stderr," CPTPDSK - RECORD LENGTH: %d\n",lrecl) ; 
				break ; 
			case 'N':
				nread= (int) strtol(optarg,&cp,10) ;
				if ( *cp != '\0' ) {
					(void) fprintf(stderr,"CPTPDSK ! INVALID MAX. NB OF RECORDS SPECIFIED\n") ;
					(void) printf("-1\n") ;
					exit(0) ;
				}
				if ( nread != -1 ) 
					(void) fprintf(stderr," CPTPDSK - MAX. NB OF RECORDS: %d\n",nread) ;
				break ; 
			case '?':
				(void) fprintf(stderr," CPTPDSK ! ABORT BECAUSE ILLEGAL ENTRY\n"); 
				(void) printf("-1\n") ; 
				exit(0) ;
		}
	}

	/*
	 * If direct access mode,
	 * append flag is removed.
	 */
	if ( recfm[1] == 'D' ) recfm[3]= ' ' ; 

	/*
	 * Buffer allocation
	 */
	buflen= ( recfm[1] == 'D' ) ? lrecl : blksiz ;
	if ( ( buffer= ( char *) malloc((unsigned) buflen)) == NULL ) {
		perror(" CPTPDSK ! BUFFER ALLOCATION ERROR") ; 
		(void) printf("-1\n") ; 
		exit(0) ;
	}	

	/*
	 * Getting disk file name.
	 */
	if ( optind < argc ) { 
		filnam= argv[optind] ;
	}
	else	{
		(void) printf("-1\n") ; 
		(void) fprintf(stderr," CPTPDSK ! ERROR, DISK FILE NAME MISSING\n") ; 
		exit(0) ; 
	}

	/*
	 * Opening tape file as input.
	 */
	if ( (tpfd= open(tpfil,O_RDONLY)) == -1 ) {
		(void) printf("-1\n") ;
		perror(" CPTPDSK ! ERROR WHILE OPENING TAPE FILE") ;
		exit(0) ;
	}	

	/* 
	 * Opening disk file as output
	 */
	printf("%s: %s , %s, %s\n", argv[0], special_uid, special_gid, special_key);
	if ( special_uid != NULL && special_gid != NULL && special_key !=NULL && reqhost != NULL ) {
		rc= rfio_xyopen_ext(filnam," ",filnum,lrecl,recfm,&irc,
					(uid_t)atol(special_uid),
                                        (gid_t)atol(special_gid),
                                         atoi(special_key),
					 reqhost
                                        ) ;
	else
		rc= rfio_xyopen(filnam," ",filnum,lrecl,recfm,&irc);

	if ( rc || irc  ) {
		(void) printf("-1\n") ; 
		(void) fprintf(stderr," CPTPDSK ! ERROR %d OPENING DISK FILE\n",(rc)?rc:irc) ; 
		exit(0) ;
	}
	/*
 	 * writing interface name
 	 */
	if ( (ifce=getifnam(rfio_xysock(filnum)))==NULL ) 
		strcpy(ptr, "unknown" ) ;
	else 
		strcpy(ptr, ifce) ;

	/*
	 * Starting the transfer
	 */
	for(;;) {
		int nbyte ;
		int recnum ; 

		/* 
		 * Reading data
		 */
		irc= read(tpfd,buffer,buflen) ;
		switch(irc) {
			case -1:
				(void) printf("-1\n") ; 
				perror(" CPTPDSK ! ERROR READING TAPE FILE") ; 
				exit(0) ; 
			case 0:
				(void) fprintf(stderr," CPTPDSK - END OF FILE\n") ; 
				rc= rfio_xyclose(filnum," ",&irc) ;
				if ( rc || irc ) {
					(void) printf("-1\n") ; 
					(void) fprintf(stderr," CPTPDSK ! ERROR %d CLOSING DISK FILE\n",(rc)?rc:irc) ; 
					exit(0) ;
				}
				(void) close(tpfd) ; 
				(void) printf("%d:%d:%d:%s\n",ibas+irec,nread,total,ptr) ; 
				(void) fprintf(stderr,"\n CPTPDSK - %d RECORDS COPIED\n\n",irec) ; 
				exit(0) ;
		} 
		/*
		 * Writing data	
		 */
		switch(recfm[1]) {
			case 'S':
				nbyte= irc ; 
				break ; 
			case 'D':
				if ( lrecl != irc ) {
					(void) printf("-1\n") ; 
					(void) fprintf(stderr," CPTPDSK ! BAD LENGTH TAPE BLOCK\n") ; 
					exit(0) ;
				}
				nbyte= lrecl ;
				break ;
		}
		total += nbyte ; 
		recnum= ibas+irec+1 ; 
		rc= rfio_xywrite(filnum,buffer,recnum,nbyte," ",&irc) ; 	
		if ( rc || irc ) {
			(void) printf("-1\n") ; 
			(void) fprintf(stderr," CPTPDSK ! ERROR %d WRITING ON DISK\n",(rc)?rc:irc) ; 
			exit(0) ;
		}	
		/*
	 	 * Other records to copy ?
		 */
		irec ++ ;
		if ( nread != -1 ) {
			nread -- ;
			if ( nread == 0 ) {
				(void) fprintf(stderr," CPTPDSK - END OF FILE\n") ; 
				rc= rfio_xyclose(filnum," ",&irc) ;
				if ( rc || irc ) {
					(void) printf("-1\n") ; 
					(void) fprintf(stderr," CPTPDSK ! ERROR %d CLOSING DISK FILE\n",(rc)?rc:irc) ; 
					exit(0) ;
				}
				(void) close(tpfd) ; 
				(void) printf("%d:%d:%d:%s\n",ibas+irec,nread,total,ptr) ; 
				(void) fprintf(stderr,"\n CPTPDSK - %d RECORDS COPIED\n\n",irec) ; 
				exit(0) ;
			}
		}
	}
}
