.\" @(#)rtcopyd.man	1.5 08/18/94 CERN CN-PDP/CS Felix Hassine
.\" Copyright (C) 1990-1994 by CERN/CN/SW/DC
.\" All rights reserved
.\"
.TH RTCOPYD l "1/21/93" "Release 1.3" "SHIFT REFERENCE MANUAL PAGES"
.SH NAME
rtcopyd \- Remote tape copy daemon
.SH SYNOPSIS
.B /usr/local/bin/rtcopyd 
[
.B -dls
][
.BI \-p " port"
][
.BI \-f " log_file"
]
.SH DESCRIPTION
\fIrtcopyd\fR is the daemon handling remote tape copy operations.
It is used with the corresponding \fItpread\fR and \fItpwrite\fR
client commands.
.LP
\fIrtcopyd\fR is usually started from the machine startup scripts
(\fI/etc/rc.local\fR or \fI/etc/init.d/Sxxrtcopy\fR) with the \fI -s\fR
option, but may also be started by the internet services daemon (see
\fIinetd (8)\fR).
\fIrtcopyd\fR will autofork itself when not started by \fIinetd\fR.
.LP
\fIrtcopyd\fR listens for requests on the \fIrtcopy\fR
internet port number as indicated by the \fI/etc/services\fR
file (see \fIservices (5)\fR)
.LP
\fIrtcopyd\fR operates by forking a subprocess for a client for which a
tape device is reserved and the appropriate copy operation is issued.
All errors messages are logged in \fI/usr/spool/rtcopyd.err\fR
and sent to the originator.
.SH AUTHORIZATION
The \fIrtcopyd\fR
daemon requires the cooperating hosts to share the same user
information databases, unless a user A (uidA, gidA) is explicitely mapped
to the user B (uidB, gidB) who exists is the user information database of 
the host where rtcopyd is running. The mapping can be performed by using the
/etc/ext.users mapping file. If no mapping is done, the uid, gid and usernames 
must be the same on the two cooperating hosts. Additionaly, uids below 100
will not be serviced.
.LP
\fIrtcopyd\fR will only service hosts listed in \fI/etc/rtcopyd.hosts\fR
file it it exists. Otherwise no host restriction is applied.
.SH OPTIONS
.TP
.I \-d
Used for debugging.
.TP
.I \-l
Turns on logging information in
.IR /usr/spool/rtcopy/rtcopyd.log
.TP
.I \-s
Starts the daemon as a standalone server instead of using
.IR inetd (8C).
.TP
.I \-p " port"
Specifies an alternate
.I port 
number to be used (useful for debugging).
.TP
.I \-f " log_file"
Specifies an alternate log file for the rtcopyd daemon (useful for debugging).
If stderr is specified, the the display is done on the standard error stream.
.SH CONFIGURATION
.I rtcopyd
requires a list of authorized hosts to be defined (/etc/rtcopy.hosts, 
changeable at installation by modifying the config/site.def file). For 
a "shift to shift" functionnality (i.e for two different site using SHIFT and
exchanging data), it also 
requires a mapping file ( by default /etc/ext.users ) for users attempting connection from another site and a configuration file specifying the hosts whose IP first two bytes differ from  the current IP's (/etc/shift.localhosts ).
.SH CONFIGURATION FOR RETRY PROCEDURES
The
.I rtcopy server
software can be configurated to perform retries in some cases when a tape error, a network error
or a hardware error occurs on the tape server. Several flags can be set up in the 
.I /etc/shift.conf
configuration file to trigger this behaviour. The template of this entry is:
.TP 
RTCOPYD  Error_Flag	 Retry_type
.TP
The 
.I Error_Flag
is one of the following keywords:
.RS
.TP 1.5i
.I HWERROR : 
Hardware error occured while reading the tape ( Example: The unit disabled after a self-check)
.TP
.I IORETRY : 
An I/O error occured  while reading the tape, other than a PARITY error.
It is also the flag which sets up the number of retries on "tpmnt", when
a tape cannot be mounted.
.TP
.I PARITYRETRY : 
A parity was found when reading or writing the tape
.TP
.I DEVRETRY : 
The device gave an error (Example: Interface Check on the unit )
.RE
.TP
The
.I Retry_type
is one of the following numbers:
.RS
.TP 1.5i
.I 5
For the kind of error specified by
.I Error_Flag
, a simple retry on the same unit is required, with only a rewind of the tape and restart
the read/write procedure.
.TP
.I 6 
For the kind of error specified by 
.I Error_Flag
, a retry is required, with a DEMOUNT and a retry. In this case, if another unit is available at the
time of the retry, it will go on the other unit.
.TP
.I 7
For the kind of error specified by 
.I Error_Flag
, a retry on the same unit is required, with only a rewind of the tape and restart
the read/write procedure, but twice the number of retries usually performed will be
attempted.
twice the number of retries usually performed will be
attempted.
.RE
.TP 
The 
.I number of retries 
to be performed can be set with the entry:
.TP
RTCOPYD NUMRETRIES Number
.br
.SH SHIFT FILES
The following  file names can be altered before the compilation of the SHIFT software 
by modifying the 
.I config/site.def
file.
.PD
.br
.PD 0
.TP 
.I /usr/local/bin/rtcopyd
.TP
.I /usr/spool/RTCOPY
.TP
.I /usr/spool/rtcopy/rtcopyd.log
.TP
.I /usr/spool/rtcopy/rtcopyd.err
.TP
.I /etc/rtcopyd.hosts
.TP 
.I /etc/shift.conf
.TP 
.I /etc/ext.users
.TP
.I /etc/shift.localhosts
.br
.PD
.SH SYSTEM FILES
.PD 0
.TP
.I /etc/services
.PD
.SH SEE ALSO
The
.B SHIFT Reference manual,
.br
.BR inetd (8C),
.BR services (5),
.BR tpread (l)
.BR tpwrite (l)
.SH BUGS
.LP
The log files tend to grow over time (
\fI/usr/spool/rtcopy/rtcopyd.{err,log}\fR).
 A regular cleanup of the files should be performed.
 To perform this cleanup a simple move (mv) of the log file is needed.
.LP
.I rtcopyd
creates various temporary files in the \fI/usr/spool/RTCOPY\fR
working directory. Process numbers are used in the name of those files,
but there errors due to reuse of a same file with another uid.
.SH NOTES
The location of log files (\fI/usr/spool/rtcopy/rtcopyd.log\fR,
\fI/usr/spool/rtcopy/rtcopyd.err\fR), the host authorization file
(\fI/etc/rtcopy.hosts\fR), and the working directory
(\fI/usr/spool/RTCOPY\fR) may be altered by recompiling the rtcopy
subdirectory source tree after modifying the \fIImakefile\fR file.
.SH AUTHORS
Jean-Philippe Baud,
Felix Hassine,
Frederic Hemmer,
Antoine Trannoy
.TP
CERN-CN Division CH-1211 Geneva 23, Switzerland
