/*
 * Copyright (C) 1994-1998 by CERN/CN/PDP/CS
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)rfcp.c	1.27 11/12/98 CERN CN-PDP/CS Felix Hassine ";
#endif /* not lint */

#include <fcntl.h>
#define RFIO_KERNEL 1
#include <rfio.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifndef TRANSFER_UNIT
#define TRANSFER_UNIT   131072 
#endif

#if defined(HPSSCLIENT)
#if !defined(TRANSFER_UNIT_HPSS)
#define TRANSFER_UNIT_HPSS   4*1024*1024 
#endif /* TRANSFER_UNIT_HPSS */
#endif /* HPSSCLIENT */

#if !defined(vms)
#define SYERR 2
#define USERR 1
#define OK    0
#else
#define SYERR 2*2
#define USERR 1*2
#define OK    1
#endif  /* vms */

extern int errno;
extern int serrno ;
extern int rfio_errno ;
#ifndef linux
extern char *sys_errlist[];
#endif
extern char *getconfent() ;

#if defined(vms) && (vms == 1)
#include <unixio.h>
#if !defined(S_ISDIR)
#define S_ISDIR(m)	(((m)&S_IFMT) == S_IFDIR)
#endif /* S_ISDIR */
#if !defined(S_ISCHR)
#define S_ISCHR(m)	(((m)&S_IFMT) == S_IFCHR)
#endif /* S_ISCHR */
#if !defined(S_ISBLK)
#define S_ISBLK(m) 	(((m)&S_IFMT) == S_IFBLK)
#endif /* S_ISBLK */
#define	unlink	delete
#endif /* vms */
#if defined(_WIN32)
#define S_ISDIR(m)  (((m)&S_IFMT) == S_IFDIR)
#define S_ISCHR(m)  (((m)&S_IFMT) == S_IFCHR)
#endif

#if defined(HPSSCLIENT)
/*
 * Prototype the workers
 */
#ifdef __STDC__
int (*worker)(int, char *, int, int);
int local_read(int, char *, int, int);
int local_write(int, char *, int, int);
#else /* __STDC__ */
int (*worker)();
int local_read();
int local_write();
#endif /* __STDC__ */
/*
 * Data needed by the workers
 */
static char local_file[BUFSIZ];
static int local_binmode;
static int local_mode;
#endif /* HPSSCLIENT */

main(argc, argv)
int argc;
char *argv[];
{
  int argvindx;		/* argument index in program argv */
#if defined(_WIN32)
  int binmode = O_BINARY;
#else
  int binmode = 0;
#endif
  int c;
  int cfargc;		/* number of arguments in command file */
  char **cfargv;	/* arguments in command file */
  int cfargvindx;	/* argument index in command file */
  char *curargv;	/* current argv */
  int  fd1, fd2;
  int incmdfile;	/* 1 = processing command file */
  struct stat sbuf, sbuf2;
  long   starttime, endtime, size;
  int rc ;
  char filename[BUFSIZ], inpfile[BUFSIZ], outfile[BUFSIZ] ;
  char *cp , *ifce ;
  char ifce1[8] ;
  char ifce2[8] ;
  char *host1, *host2, *path1, *path2 ;
  char shost1[32];
  int l1, l2 ;
  int v;
  int maxsize = -1;
  extern char * getifnam() ;
#if defined(_WIN32)
  WSADATA wsadata;
#endif

  cfargc = 0;
  cfargvindx = 0;
  inpfile[0] = '\0';
  outfile[0] = '\0';
  for (argvindx = 1; argvindx < argc || cfargvindx < cfargc; ) {
	if (cfargvindx >= cfargc)
		incmdfile = 0;
	curargv = incmdfile ? cfargv[cfargvindx++] : argv[argvindx++];
#if defined(_WIN32)
	if (strcmp (curargv, "-a") == 0) {
		binmode = O_TEXT;
		continue;
	} else if (strcmp (curargv, "-b") == 0) {
		binmode = O_BINARY;
		continue;
	} else if (*curargv == '@') {
		if ((cfargc = cmdf2argv (curargv+1, &cfargv)) < 0) exit (USERR);
		if (cfargc == 0) continue;
		incmdfile = 1;
		cfargvindx = 0;
		continue;
	}
#endif
        if (strcmp (curargv, "-s") == 0) {
	  curargv = incmdfile ? cfargv[cfargvindx++] : argv[argvindx++];
	  maxsize = strtol(curargv, (char **) NULL, 10);
	  if (maxsize == 0)
            usage();
	  curargv = incmdfile ? cfargv[cfargvindx++] : argv[argvindx++];
        }

 /* Special treatment for filenames starting with /scratch/... */
	if (inpfile[0] == '\0')
		if (!strncmp ("/scratch/", curargv, 9) &&
		    (cp = getconfent ("SHIFT", "SCRATCH", 0)) != NULL) {
			strcpy (inpfile, cp);
			strcat (inpfile, curargv+9);
		} else
#if defined(HPSSCLIENT)
 /* Special treatment for filenames starting with /hpss/... */
		  if ( !strncmp("/hpss/",curargv,6) &&
		       (cp = getconfent("SHIFT","HPSS",0)) != NULL) {
		        strcpy(inpfile,cp);
			strcat(inpfile,curargv+6);
		  } else
#endif /* HPSSCLIENT */
			strcpy (inpfile, curargv);
	else
		if (!strncmp ("/scratch/", curargv, 9) &&
		    (cp = getconfent ("SHIFT", "SCRATCH", 0)) != NULL) {
			strcpy (outfile, cp);
			strcat (outfile, curargv+9);
		} else
#if defined(HPSSCLIENT)
 /* Special treatment for filenames starting with /hpss/... */
		  if ( !strncmp("/hpss/",curargv,6) &&
		       (cp = getconfent("SHIFT","HPSS",0)) != NULL) {
		        strcpy(outfile,cp);
			strcat(outfile,curargv+6);
		  } else
#endif /* HPSSCLIENT */
			strcpy (outfile, curargv);
      }

  	if (! outfile[0]) usage();

 /* Check that files are not identical ! */
#if defined(_WIN32)
	if (WSAStartup (MAKEWORD (2, 0), &wsadata)) {
		fprintf (stderr, "WSAStartup unsuccessful\n");
		exit (SYERR);
	}
#endif
	l1 = rfio_parseln( inpfile , &host1, &path1, NORDLINKS ) ;
	if ( l1 )
		strcpy(shost1,host1) ;
	strcpy( filename, path1 );

	l2 = rfio_parseln( outfile , &host2, &path2, NORDLINKS ) ;

	if ( ( l1 == 0 && l2 == 0 && !strcmp(filename,path2) ) ||
	     ( l1 && l2 && !strcmp( shost1, host2 ) && !strcmp( filename, path2) ) ) {
		printf("files are identical \n");
#if defined(_WIN32)
		WSACleanup();
#endif
		exit (OK) ;
	}

  /* Command is of the form cp f1 f2. */
	rc = rfio_stat(inpfile, &sbuf);
	if ( rc == 0 && ( S_ISDIR(sbuf.st_mode) || S_ISCHR(sbuf.st_mode)
#if !defined(_WIN32)
		|| S_ISBLK(sbuf.st_mode)
#endif
								) ) {
		fprintf(stderr,"file %s: Not a regular file\n",inpfile);
#if defined(_WIN32)
		WSACleanup();
#endif
		exit(USERR) ;
	}
	if ( rfio_stat( outfile, &sbuf2) == 0 &&  
		S_ISDIR(sbuf2.st_mode) ) {
		if ( (cp = strrchr(inpfile,'/'))  != NULL  ) cp++;
		else cp = inpfile;
		sprintf(filename, "%s/%s", outfile, cp);
	}
	else
		strcpy(filename,outfile) ;

#if defined(HPSSCLIENT)
	worker = NULL;
	/*
	 * Special signature of an HPSS file. First check input file
	*/
	if ( sbuf.st_dev  == 0 && sbuf.st_ino  == 1 ) {
		worker = local_write;
		strcpy(local_file,filename);
		local_mode = sbuf.st_mode;
		local_binmode = binmode;
	}
	/*
	 * Then check the output file. If both input and output are HPSS
	 * we will be steered by the mover for the output file. This allows
	 * the use of rfcp to copy a file from one COS to another.
	*/
	cp = strrchr(filename,'/');
	if ( cp != NULL ) {
		*cp = '\0';
		if ( *filename ) rc = rfio_stat(filename,&sbuf2);
		*cp = '/';
		if ( sbuf2.st_dev == 0 && sbuf2.st_ino == 1 ) {
			worker = local_read;
			strcpy(local_file,inpfile);
			local_mode  = sbuf2.st_mode;
			local_binmode = binmode;
		}
	}
	/*
	 * Only allow V3 if both files are non-HPSS
	 */
	if ( worker == NULL ) {
#endif /* HPSSCLIENT */
	/* Activate new transfer mode for source file */
	v = RFIO_STREAM;
	rfiosetopt(RFIO_READOPT,&v,4); 
#if defined(HPSSCLIENT)
	} /* worker == NULL */
#endif /* HPSSCLIENT */
	
  	serrno = 0 ;
  	rfio_errno = 0 ;
  	fd1 = rfio_open(inpfile,O_RDONLY|binmode ,0644);
  	if (fd1 < 0) {
         	if (serrno) {
                        rfio_perror(inpfile);
                        c = SYERR;
         	}
         	else
                   switch (rfio_errno) {
                        case EACCES:
                        case EISDIR:
                        case ENOENT:
                        case EPERM :
                                rfio_perror(inpfile);
                                c = USERR;
                                break ;
                        case 0:
                                switch(errno) {
                                        case EACCES:
                                        case EISDIR:
                                        case ENOENT:
                                        case EPERM :
                                                rfio_perror(inpfile);
                                                c = USERR;
                                                break;
                                        default:
                                                rfio_perror(inpfile);
                                                c = SYERR;
                                }
                                break;
                        default:
                                rfio_perror(inpfile);
                                c = SYERR;
          	 }
#if defined(_WIN32)
			WSACleanup();
#endif
			exit (c);
  	}
	if ( (ifce=getifnam(fd1))==NULL ) 
                strcpy(ifce1,"local");
        else
                strcpy(ifce1,ifce) ;

#if defined(HPSSCLIENT)
	/* Only allow V3 if both files are non-HPSS */
	if ( worker == NULL ) {
#endif /* HPSSCLIENT */
	/* Activate new transfer mode for target file */
	v = RFIO_STREAM;
	rfiosetopt(RFIO_READOPT,&v,4); 
#if defined(HPSSCLIENT)
	} /* worker == NULL */
#endif /* HPSSCLIENT */

        serrno = 0 ;
        rfio_errno = 0 ;
	fd2 = rfio_open(filename , O_WRONLY|O_CREAT|O_TRUNC|binmode ,sbuf.st_mode & 0777);
	if (fd2 < 0) {
		if (serrno) {
			rfio_perror(outfile);
			c = SYERR;
		}
		else
		   switch (rfio_errno) {
			case EACCES:
			case EISDIR:
			case ENOENT:
			case EPERM :
				rfio_perror(outfile); 
				c = USERR;
				break;
			case 0:
				switch(errno) {
					case EACCES:
					case EISDIR:
					case ENOENT:
					case EPERM :
						rfio_perror(outfile); 
						c = USERR;
						break;
					default:
						rfio_perror(outfile);
						c = SYERR;
				}
				break;
			default:
				rfio_perror(outfile);
				c = SYERR;
		   }
#if defined(_WIN32)
		WSACleanup();
#endif
		exit (c);
	}
	/*
	 * Get interfaces names
	 */
	if ( (ifce=getifnam(fd2))==NULL ) 
                strcpy(ifce2,"local");
        else
                strcpy(ifce2,ifce) ;

	time(&starttime);
#if defined(HPSSCLIENT)
	if ( worker == NULL )
	  size = copyfile(fd1, fd2, outfile, maxsize);
	else
	  size = copyfile_hpss(fd1,fd2,filename,&sbuf,maxsize);
#else /* HPSSCLIENT */
	size = copyfile(fd1, fd2, outfile, maxsize);
#endif /* HPSSCLIENT */
	time(&endtime);
	if (size>0)  {
		fprintf(stdout,"%d bytes in %d seconds through %s (in) and %s (out)",size, endtime-starttime,ifce1,ifce2);
		l1 = endtime-starttime ;
		if ( l1 > 0) {
			fprintf(stdout," (%d KB/sec)\n",size/(1024*l1) );
		}
		else    {
			fprintf(stdout,"\n");
		}
	}
	else    {
		fprintf(stdout,"%d bytes transferred !!\n",size);
	}
#if defined(_WIN32)
  WSACleanup();
#endif
  exit(OK);
}

copyfile(fd1, fd2, name, maxsize)
int fd1, fd2, maxsize;
char *name;
{
  int n, m, mode;
  struct stat sbuf;
  int effsize=0;
  char  *p;
  int bufsize = TRANSFER_UNIT;
  char * cpbuf;
  extern char *getenv();		/* External declaration */
  int total_bytes = 0;

  if ((p=getenv("RFCPBUFSIZ")) == NULL) {
	if ((p=getconfent("RFCP","BUFFERSIZE",0)) == NULL) {
	      bufsize=TRANSFER_UNIT;
	} else  {
	      bufsize=atoi(p);
	}
  } else {
	bufsize=atoi(p);
  }
  if (bufsize<=0) bufsize=TRANSFER_UNIT;

  if ( ( cpbuf = malloc(bufsize) ) == NULL ) {
	perror("malloc");
#if defined(_WIN32)
	WSACleanup();
#endif
	exit (SYERR);
  }

  do {
    if (maxsize != -1) {
      if ((maxsize - total_bytes) < bufsize)
        bufsize = maxsize - total_bytes;
    }
    n = rfio_read(fd1, cpbuf, bufsize);
    if (n > 0) {
      int count = 0;
      
      total_bytes += n;
      effsize += n;
      while (count != n && (m = rfio_write(fd2, cpbuf+count, n-count)) > 0)
	count += m;
 
      if (m < 0) {
	/* Write failed.  Don't keep truncated regular file. */
	rfio_perror("rfcp");
	rfio_close(fd2);
	rfio_stat(name, &sbuf);	/* check for special files */
	mode = sbuf.st_mode & S_IFMT;
	if (mode == S_IFREG) rfio_unlink(name);
#if defined(_WIN32)
	WSACleanup();
#endif
	exit(SYERR);
      }
    } else {
      if (n < 0) {
	rfio_perror("cp: read error");
	break;
      }
    }
  } while ((total_bytes != maxsize) && (n > 0));
  if (rfio_close(fd1) < 0) {
    rfio_perror("close source");
#if defined(_WIN32)
    WSACleanup();
#endif
    exit(SYERR);
  }

  if (rfio_close(fd2) < 0) {
    rfio_perror("close target");
    rfio_stat(name, &sbuf);	/* check for special files */
    mode = sbuf.st_mode & S_IFMT;
    if (mode == S_IFREG) 
      rfio_unlink(name);
#if defined(_WIN32)
    WSACleanup();
#endif
    exit(SYERR);
  }
  return(effsize);
}

usage()
{
  fprintf(stderr,"Usage:  rfcp [-s maxsize] f1 f2; or rfcp f1 <dir2>\n");
  exit(USERR);
}

#if defined(HPSSCLIENT)
int copyfile_hpss(fd1,fd2,name,sbuf,maxsiz)
int fd1, fd2;
int maxsiz;
char *name;
struct stat *sbuf;
{
  int bufsize = TRANSFER_UNIT_HPSS;
  int effsize=0;
  int mode,cosid = 0;
  int nb_ports = 1;
  char *p;
  char * cpbuf;
  struct stat sbuf2;

  extern char *getenv();		/* External declaration */

  if ((p=getenv("RFCP_HPSSBUFSIZ")) == NULL) {
	if ((p=getconfent("RFCP","HPSSBUFSIZ",0)) == NULL) {
	      bufsize=TRANSFER_UNIT_HPSS;
	} else  {
	      bufsize=atoi(p);
	}
  } else {
	bufsize=atoi(p);
  }
  if ((p=getenv("RFCP_HPSSCOS")) == NULL) {
	if ((p=getconfent("RFCP","HPSSCOS",0)) == NULL) {
	      cosid = 0;
	} else  {
	      cosid=atoi(p);
	}
  } else {
        cosid=atoi(p);
  }
  if (bufsize<=0) bufsize=TRANSFER_UNIT_HPSS;

  if ( ( cpbuf = malloc(bufsize) ) == NULL ) {
	perror("malloc");
#if defined(_WIN32)
	WSACleanup();
#endif
	exit (SYERR);
  }

  if ((p=getenv("RFCP_NBPORTS")) == NULL) {
	if ((p=getconfent("RFCP","NBPORTS",0)) == NULL) {
	      nb_ports=1;
	} else  {
	      nb_ports=atoi(p);
	}
  } else {
	nb_ports=atoi(p);
  }
  if (nb_ports<=0) nb_ports=1;

  if ( maxsiz <= 0 ) maxsiz = sbuf->st_size;
  maxsiz = min(maxsiz,sbuf->st_size);
  if ( worker == local_read ) {
    if ( cosid ) rfio_setcos(fd2,0,cosid);
    /* We don't need the local file descr. any longer. each worker will create its own descr. */
    rfio_close(fd1);
    fd1 = -1;
    if ( sbuf->st_size > 0 ) effsize = rfio_writelist(fd2,0,maxsiz,nb_ports,
						     worker,cpbuf,bufsize);
    if ( effsize < 0 ) rfio_perror("rfio_writelist()");
  } else if ( worker == local_write ) {
    /* We don't need the local file descr. any longer. each worker will create its own descr. */
    rfio_close(fd2);
    /* Make sure to have write access to the local file.... */
    if ( ! (local_mode & S_IWUSR) && chmod(local_file,local_mode | S_IWUSR) < 0 ) {
      rfio_perror("chmod()");
      exit(USERR);
    }
    fd2 = -1;
    if ( sbuf->st_size > 0 ) effsize = rfio_readlist(fd1,0,maxsiz,nb_ports,
						    worker,cpbuf,bufsize);
    if ( effsize < 0 ) rfio_perror("rfio_readlist()");
  } else {
    fprintf(stderr,"copyfile_hpss(): worker function (0x%x) not defined\n",worker);
  }
  if ( sbuf->st_size > 0 && effsize != maxsiz ) {
    fprintf(stderr,"copyfile_hpss(): %d bytes out of %d transfered\n",effsize,maxsiz);
    /* Write failed.  Don't keep truncated regular file. */
    rfio_perror("rfcp");
    rfio_close(fd2);
    mode = sbuf->st_mode & S_IFMT;
    if (mode == S_IFREG) rfio_unlink(name);
#if defined(_WIN32)
    WSACleanup();
#endif
    exit(SYERR);
  }
  if (fd1 >= 0 && rfio_close(fd1) < 0) {
    rfio_perror("close source");
#if defined(_WIN32)
    WSACleanup();
#endif
    exit(SYERR);
  }

  if (fd2 >= 0 && rfio_close(fd2) < 0) {
    rfio_perror("close target");
    mode = sbuf->st_mode & S_IFMT;
    if (mode == S_IFREG) 
      rfio_unlink(name);
#if defined(_WIN32)
    WSACleanup();
#endif
    exit(SYERR);
  }
  return(effsize > 0 ? effsize : 0);
}
local_read(fd,buf,bufsize,offset)
int fd,bufsize,offset;
char *buf;
{
  static int local_fd = -1;
  int rc,tot;

  if ( local_fd == -1 ) {
    local_fd = rfio_open(local_file,O_RDONLY | local_binmode, 0644);
    if ( local_fd < 0 ) {
      rfio_perror(local_file);
      return(local_fd);
    }
  }

  if ( bufsize<0 || offset<0) {
    rfio_close(local_fd);
    local_fd = -1;
    return(bufsize);
  }

  if ( buf == NULL ) {
    return(bufsize);
  }
  if ( bufsize == 0 ) return(bufsize);
  if ( rfio_lseek(local_fd,(off_t)offset,SEEK_SET) != (off_t)offset ) {
    rfio_perror(local_file);
    return(-1);
  }
  tot = 0;
  while ( tot < bufsize ) {
    rc = rfio_read(local_fd,(char *)(buf+tot),bufsize-tot);
    if ( rc < 0 ) {
      rfio_perror(local_file);
      return(rc);
    }
    tot += rc;
  }
  return(tot);
}
local_write(fd,buf,bufsize,offset)
int fd,bufsize,offset;
char *buf;
{
  static int local_fd = -1;
  int rc,tot;
  char *locbuf;

  if ( local_fd == -1 ) {
    local_fd = rfio_open(local_file , O_WRONLY|O_CREAT ,local_mode & 0777);
    if ( local_fd < 0 ) {
      rfio_perror(local_file);
      return(local_fd);
    }
  }
  if ( bufsize<0 || offset<0) {
    rfio_close(local_fd);
    local_fd = -1;
    return(bufsize);
  }

  locbuf = buf;
  if ( bufsize == 0 ) return(bufsize);
  if ( rfio_lseek(local_fd,(off_t)offset,SEEK_SET) != (off_t)offset ) {
    rfio_perror(local_file);
    return(-1);
  }
  if ( buf == NULL && bufsize > 0 ) {
    /* 
     * A true gap
     */
    if ( rfio_lseek(local_fd,(off_t)bufsize,SEEK_CUR) != (off_t)(offset+bufsize)) {
      rfio_perror(local_file);
      return(-1);
    }
    return(bufsize);
  }
  tot = 0;
  while ( tot < bufsize ) {
    rc = rfio_write(local_fd,(char *)(locbuf+tot),bufsize-tot);
    if ( rc < 0 ) {
      rfio_perror(local_file);
      return(rc);
    }
    tot += rc;
  }
  return(tot);
}
#endif /* HPSSCLIENT */
