/*
 * Copyright (C) 1990-1998 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)msgr.c	1.12 05/06/98 CERN CN-SW/DC Antoine Trannoy";
#endif /* not lint */

/* msgr.c		SHIFT sending message to remote message daemon	*/

#include <stdio.h>
#if defined(sun) || defined(ultrix) || defined(sgi)
#include <unistd.h>
#endif	/* sun || ultrix || sgi*/
#if (defined(_AIX) && defined(_IBMESA)) || (defined(__osf__) && defined(__alpha)) || defined(linux)
extern char *cuserid();
#endif
#include "msg.h"

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <string.h>

/*
 * Networking.
 */
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>

/*
 * Error and message handling.
 */
#include <errno.h>
#include <serrno.h>
#include <log.h>
extern int errno ;
extern int sys_nerr ;
extern void perror() ;
#if !defined(linux)
extern char *sys_errlist[] ;
#endif

/*
 * Process handling.
 */
#include <signal.h>		/* Signal handling	*/
#include <setjmp.h>		/* To switch context	*/
static jmp_buf	ctxt ;		/* To save context	*/
#define INTCAUGHT	1	/* longjump return value*/
#if defined(apollo)
#define SIG_ERR	(void(*)())-1
#endif	/* apollo */

/*
 * Pointer to the command name.
 */
static char * command ;

/*
 * SIGINT interrupt handler.
 */
void actionSIGINT() 
{
	longjmp(ctxt,INTCAUGHT) ;
}

/*
 * Combining sndmsgr() and rcvmsgr().
 * It is used to build the command msgr.
 * ^C is trapped to abort.
 */
int msgr(msg,rep,repsiz)
	char * msg ; 
	char * rep ; 
	int repsiz ;
{
	int 		         sock ;	/* Socket identifier.		*/
	int			 type ; /* Type of message received	*/
	int			 auth ;	/* My authentification		*/
	int			index ;	/* Index message.		*/
	int 		     port = 0 ;	/* Port number.			*/

	/*
	 * Opening reception socket.
	 */
	if ( (sock= opnmsgr(&port)) == -1 ) {
		return -1 ;
	}

	/*
	 * Sending message.
	 */
	if ( sndmsgr(msg,port,0) == -1 ) { 
		(void) close(sock) ; 
		return -1 ;
	}	

	/*
	 * Waiting for index number.
	 */ 
	if ( rcvmsgr(sock,&type,&auth,&index,rep,repsiz) == -1 ) {
		(void) close(sock) ; 
		return -1 ;
	}
	if ( type != ACKN_MSGR ) {
		(void) close(sock) ; 
		serrno= SEINTERNAL ;
		return -1 ;
	}

	/*
	 * Trapping abort requests.
	 * The pending message is canceled.
	 */
	if ( setjmp(ctxt) == INTCAUGHT ) {
		(void) close(sock) ;
		(void) canmsgr(index) ; 
		exit(1) ;
	}
	signal(SIGINT,( void (*)())actionSIGINT) ;

	/*
	 * Waiting for reply.
	 */
	if ( rcvmsgr(sock,&type,&auth,&index,rep,repsiz) == -1 ) {
		(void) close(sock) ; 
		return -1 ;
	}
	if ( type != GIVE_REPL ) {
		(void) close(sock) ; 
		serrno= SEINTERNAL ;
		return -1 ;
	}

	(void) close(sock) ; 
	return 0 ;
}

/*
 * msgr, or msgi,  command.
 */
main(argc,argv)
	int 	argc ;
	char  **argv ;
{
	char hostname[MAXHOSTNAMELEN] ;
	char  		  msg[MSGSIZ] ;
	char  		  rep[MSGSIZ] ;
	char 		*sender= NULL ;
	char 		     uidst[6] ;
	int 			    i ;

	/* 
	 * Stripping the command name from its full path name.
	 */
	if ( (command= strrchr(argv[0],'/')) == NULL ) 
		command= argv[0] ;
	else
		command ++ ;

	/*
	 * Getting sender name as well as machine name.
	 * Add it at the beginning of the message.
	 */
	sender = cuserid(sender) ;
	if ( gethostname(hostname,MAXHOSTNAMELEN) == -1 ) {
		perror("command failed getting hostname") ; 
		exit(1) ; 
	}
	sprintf(uidst,"%d", getuid() ) ;
	sprintf(msg,"%s@%s:",(sender==NULL?uidst:sender) ,hostname) ; 

	/*
	 * Getting message.
	 */
	if ( sender != NULL ) {
	   for(i=1;i<argc;i++) {
		if ( ((int)strlen(msg)+(int)strlen(argv[i])+2) > MSGSIZ ) {
			serrno= SEUMSG2LONG ;
			sperror("command failed") ;
			exit(1) ;
		}
		strcat(msg," ") ;	
		strcat(msg,argv[i]) ;
	   }
	}
	else 
		strcat(msg, " User not registered on system");
	
	/*
	 * Sending message.
	 */
	if ( ! strcmp(command,"msgr")) {
		/*
		 * MSGR
		 */
		if ( msgr(msg,rep,MSGSIZ) == -1 ) {
			sperror("command failed") ;
			exit(1) ;	
		}
		else	{
			fprintf(stdout,"%s\n",rep) ;
			fflush(stdout) ;
		}
	}
	else if ( ! strcmp(command,"msgi")) {
		/*
		 * MSGI
		 */
		if ( sndmsgi(msg) == -1 ) {
			sperror("command failed") ;
			exit(1) ;
		}
	}
	/*
	 * Returning
	 */
	exit(0) ;
}

