/*
 * Copyright (C) 1990-1998 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)msgdb.c	1.6 05/06/98 CERN CN-SW/DC Antoine Trannoy";
#endif /* not lint */

/* msgdb.c      SHIFT remote message daemon data management.         */

#include <stdio.h>
#if defined(sun) || defined(ultrix) || defined(sgi)
#include <unistd.h>
#endif	/* sun || ultrix || sgi */
#include "msg.h"

#if defined(sun) || defined(ultrix) || defined(sgi)
#include <malloc.h>
#endif 	/* sun || ultrix || sgi */
#include <memory.h>
#include <sys/param.h>
#include <sys/types.h>
#include <netinet/in.h>

/*
 * Error and message handling.
 */
#include <errno.h>
#include <syslog.h>
#include <log.h>
extern void 		perror() ; 
extern int		   errno ; 
#if !defined(linux)
extern char 	 * sys_errlist[] ; 
#endif

/*
 * Structure to build a list of msgr messages.
 */
struct msgrlist {
	int   		    index ;	/* Message index 	*/
	int		identifier;	/* Sender private field	*/
	time_t 	             time ;	/* Time of the request	*/
	char   	      msg[MSGSIZ] ; 	/* Pointer to the msg	*/
	struct sockaddr_in   addr ;	/* Reply address	*/
	struct msgrlist    * next ; 	/* Next message 	*/
} ; 

/*
 * Structure to build a list of msgi messages.
 */
struct msgilist {
	time_t 	             time ;	/* Time of the request	*/
	char	      msg[MSGSIZ] ;	/* Pointer to the msg	*/
	struct msgilist    * next ;	/* next message		*/
} ;

/*
 * Beginning of the message lists.
 */
static struct msgrlist * rlist = NULL ; 
static struct msgilist * ilist = NULL ; 

/*
 * Pointers to the last element of the lists.
 */
static struct msgrlist * rlast = NULL ; 
static struct msgilist * ilast = NULL ; 

/*
 * Number of messages in the base.
 */
static int msgrnumber = 0 ;
static int msginumber = 0 ;

/*
 * Sending back the number of msgr
 * messages in the list.
 */
int msgrnum()
{
	return msgrnumber ;
}

/*
 * Sending back the number of msgi
 * messages in the list.
 */
int msginum()
{
	return msginumber ;
}

/*
 * Adding a msgr message in the list.
 * Returns -1 in case of error.
 */
int addmsgr(index,identifier,time,msg,addr) 
	int   index ;
	time_t time ;
	char *  msg ;
	int identifier ;
	struct sockaddr_in * addr ;
{
	struct msgrlist * new ;
	
	/*
	 * Creating a new structure.
	 * Initializing it.
	 */
	if ((new= (struct msgrlist *) malloc(sizeof(struct msgrlist))) == NULL) {
		log(LOG_ERR,"malloc(): %s\n",sys_errlist[errno]) ; 
		return -1 ; 	
	}
	new->identifier= identifier ;
	new->index= index ;
	new->time = time ; 
	(void) strcpy(new->msg,msg) ;
	(void) memcpy(&new->addr,addr,sizeof(struct sockaddr_in)) ; 
	new->next= NULL ;

	/*
	 * Inserting it at the end of the list.
	 */
	if ( rlist == NULL ) {
		/*
	 	 * It is the first message in the list.
		 */
		rlast=rlist= new ; 
	}
	else 	{
		rlast->next= new ; 
		rlast= new ;	
	}

	msgrnumber ++ ;
	return 0 ; 
}

/*
 * Adding a msgi message in the list.
 * Returns -1 in case of error.
 */
int addmsgi(time,msg,addr) 
	time_t time ;
	char *  msg ;
	struct sockaddr_in * addr ;
{
	struct msgilist * new ;
	
	/*
	 * Creating a new structure.
	 * Initializing it.
	 */
	if ((new= (struct msgilist *) malloc(sizeof(struct msgilist))) == NULL) {
		log(LOG_ERR,"malloc(): %s\n",sys_errlist[errno]) ; 
		return -1 ; 	
	}
	new->time = time ; 
	(void) strcpy(new->msg,msg) ;
	new->next= NULL ;

	/*
	 * Inserting it at the end of the list.
	 */
	if ( ilist == NULL ) {
		/*
	 	 * It is the first message in the list.
		 */
		ilast=ilist= new ; 
	}
	else 	{
		ilast->next= new ; 
		ilast= new ;	
	}
	msginumber ++ ;
	return 0 ; 
}

/*
 * Delete msgr message in the list.
 * Return -1 if the record is not found.
 */
int delmsgr(index) 
	int index ;
{
	struct  msgrlist * prev = NULL ; 
	struct  msgrlist * curr = rlist ; 

	while( curr != NULL ) {
		if ( curr->index == index ) {
			/*
			 * Extracting from the list the structure 
			 * pointed to by curr.
			 */
			if ( curr == rlast ) 
				rlast= prev ;
			if ( prev == NULL ) 
				rlist= curr->next ; 
			else		
				prev->next= curr->next ; 	

			/*
			 * Freeing memory.
			 */
			free( curr ) ; 
		
			/*
			 * Returning.
			 */
			msgrnumber -- ;
			return 0 ; 
		}
		else 	{
			/*
			 * Pointing to the next structure in the list,
			 * if any.
			 */
			prev= curr ;
			curr= curr->next ;	
		}
	}
	/*
	 * The record has not been found.
	 */
	return -1 ; 
}

/*
 * Getting address of a msgr message sender.
 * Deleting the message from the DataBase.
 * Returns -1 in case of a problem.
 */
int addrmsgr(index,identifier,addr)
	int index ;
	int * identifier ;
	struct sockaddr_in * addr ;
{
	struct  msgrlist * prev = NULL ; 
	struct  msgrlist * curr = rlist ; 

	while( curr != NULL ) {
		if ( curr->index == index ) {
			/*
			 * Getting the address
			 */
			(void) memcpy(addr,&curr->addr,sizeof(struct sockaddr_in));
			*identifier= curr->identifier ;

			/*
			 * Extracting from the list the structure 
			 * pointed to by curr.
			 */
			if ( curr == rlast ) 
				rlast= prev ;
			if ( prev == NULL ) 
				rlist= curr->next ; 
			else		
				prev->next= curr->next ; 	

			/*
			 * Freeing memory.
			 */
			free( curr ) ; 
		
			/*
			 * Returning.
			 */
			msgrnumber -- ;
			return 0 ; 
		}
		else 	{
			/*
			 * Pointing to the next structure in the list,
			 * if any.
			 */
			prev= curr ;
			curr= curr->next ;	
		}
	}
	/*
	 * The record has not been found.
	 */
	return -1 ; 
}

/*
 * The following functions are used to scan
 * the whole lists of msg messages.
 */
static struct msgrlist * msgrptr ;

/*
 * Initializing msgrptr to the beginning
 * of the msgr list.
 */
void setmsgrlist()
{
	msgrptr= rlist ;
}

/*
 * Getting next msgr message in the list.
 */
int getmsgrent(index,time,msg)
	int   * index ;
	time_t * time ;
	char    ** msg ;
{
	/*
	 * If no more element in the list.
	 */
	if ( msgrptr == NULL ) 
		return -1 ;

	/*
	 * Getting data.
	 */
	*index= msgrptr->index ;
	* time= msgrptr->time  ;
	*  msg= msgrptr->msg ;

	/*
	 * Incrementing pointer.
	 */
	msgrptr= msgrptr->next ;
	return 0 ;
}

/*
 * Remove message from the list and return 
 * its content.
 */
int remmsgient(time,msg)
	time_t * time ;
	char    * msg ;
{
	struct msgilist * ptr ; 

	/*
	 * If no more element in the list.
	 */
	if ( ilist == NULL ) 
		return -1 ;

	/*
	 * Getting data.
	 */
	* time= ilist->time  ;
	(void) strcpy(msg,ilist->msg) ;

	/*
	 * Removing record.
	 */
	ptr= ilist ; 
	ilist= ilist->next ;	
	free(ptr) ;
	msginumber -- ;
	return 0 ;
}
