#ifndef RFIO_HPSS_H
#define RFIO_HPSS_H
#ifdef HPSS

#define RFIO_PRINCIPAL "rfiod"
#define RFIO_KEYTAB    "/krb5/rfiod.keytabs"

#ifndef MAX_THREADS
#define MAX_THREADS 20
#endif /* MAX_THREADS */
#ifndef DIRENT_CACHESIZE
#define DIRENT_CACHESIZE 10
#endif /* DIRENT_CACHESIZE */
#define MAX_PRIVHOST_LEN 4096
/*
 * Thread globals. Rather than using a key we use the accept socket to
 * index the thread global data in the global_defs array. This saves
 * us a lot of phtread_getspecific() calls at the expense of extra
 * memory usage (~0.5M). Note that we cannot allow to close the accept
 * socket until the thread has finished with current request. 
 */

struct global_defs {
  char 	*_rqstbuf ;        /* Request buffer		*/
  char  *_filename ;       /* file name            	*/
  char  *_from_host;       /* client host name           */
  
  char     * _iobuffer ; /* Data communication buffer    */
  void     *_current_dir;
  void     *_dirhandle;
  void     *_user_cred;
  void     *_dirent_cache; /* Cached dirent structures  */
  void   *_current_dirent; /* Pointer to current dirent */
  unsigned long  _dir_offset;    /* Offset of current dir entry */
  int      _iobufsiz;		/* Current io buffer size       */
  
  /* Warning : the new sequential transfer mode cannot be used with 
     several files open at a time (because of those global variables)*/
  int _data_s;     /* Data listen socket (v3) */
  int _data_sock;  /* Data accept socket (v3) */
  int _ctrl_sock;  /* the control socket (v3) */
  int _first_write;
  int _first_read;
  int _byte_read_from_network;
  int _is_remote;
  int _is_unix;   /* Flag to indicate if thread is doing UNIX I/O */
  struct rfiostat _myinfo;
};

/*
 * Request data. One structure for each worker thread. 
 * Data sharing with main thread is synchronized using a
 * condition variable (start).
 */
struct rfio_threadData {
  int ns;
  struct sockaddr_in from;
  char _from_host[MAXHOSTNAMELEN];
  char _rqstbuf[BUFSIZ] ;		/* Request buffer		*/
  char _filename[MAXFILENAMSIZE];       /* file name            	*/
  char _current_dir[MAXFILENAMSIZE];    /* Current directory    	*/
  char *_iobuffer;
  /*
   * These two are allocated on the heap to avoid typing them. Otherwise
   * hpss includes are necessary in rfio_serv.c
   */
  void *_dirhandle;
  void *_user_cred;

  void *_dirent_cache;
  int _iobufsiz;
  int mode;
  int _is_remote;
  pthread_t       id;
  pthread_mutex_t inuse;
  pthread_cond_t  start;
};

/*
 * Prototypes for all interface routines
 */
int rhpss_cleanup();
int rhpss_init();
int rhpss_startreq();
int rhpss_fstat();
int rhpss_lstat();
int rhpss_stat();
off_t rhpss_lseek();
int rhpss_close();
ssize_t rhpss_read();
ssize_t rhpss_write();
FILE *rhpss_popen();
DIR *rhpss_opendir();
struct dirent *rhpss_readdir();
int rhpss_rewinddir();
int rhpss_closedir();
int rhpss_chown();
int rhpss_access();
int rhpss_open();
int rhpss_unlink();
int rhpss_symlink();
int rhpss_readlink();
int rhpss_rmdir();
int rhpss_mkdir();
int rhpss_rename();
int rhpss_setcos();
#define rqstbuf global[s]._rqstbuf
#define filename global[s]._filename
#define iobuffer global[s]._iobuffer
#define iobufsiz global[s]._iobufsiz
#define current_dir global[s]._current_dir
/*
#define user_cred (hsec_UserCred_t *)global[s]._user_cred
#define dirhandle (ns_OjbHandle_t *)global[s]._dirhandle
#define dirent_cache (ns_DirEntry_t *)global[s]._dirent_cache
*/
#define user_cred ((hsec_UserCred_t *)(global[s]._user_cred))
#define dirhandle ((ns_ObjHandle_t *)(global[s]._dirhandle))
#define dirent_cache ((ns_DirEntry_t *)(global[s]._dirent_cache))
#define current_dirent ((ns_DirEntry_t *)(global[s]._current_dirent))

#define dir_offset global[s]._dir_offset
#define data_s global[s]._data_s
#define data_sock global[s]._data_sock
#define ctrl_sock global[s]._ctrl_sock
#define first_write global[s]._first_write
#define first_read global[s]._first_read
#define byte_read_from_network global[s]._byte_read_from_network
#define is_remote global[s]._is_remote
#define is_unix global[s]._is_unix
#define myinfo global[s]._myinfo
#define from_host global[s]._from_host
#ifdef TRACEMALLOC
extern char *rfio_malloc();
extern void rfio_free();
#define malloc(X) rfio_malloc(X,__FILE__,__LINE__)
#define free(X) rfio_free(X,__FILE__,__LINE__)
#endif
#endif /* HPSS */
#endif /* RFIO_HPSS_H */
