/*
 * @(#)mvr_protocol.h	1.1 11/04/98 CERN IT-PDP/DM Olof Barring
 */
 
/* static char SccsId[] = "include/mvr_protocol.h, gen, 3v2   12/3/97   14:22:29   "; */
/*===========================================================================
 *
 * Include Name:	mvr_protocol.h
 * 
 * Description:
 *	This file contains definitions for the structures and routines
 *	needed to implement the mover copy protocol.
 *
 * Traceability:
 *	Version		Date		Description
 *	-------		----		-----------
 *	2.1		05/16/95	Initial D2 version.
 *	4.2		01/29/97	Added #ifdef NODCE and necessary defines
 *	4.3		07/09/97	Added MVRPROT_UNS64_SIZE
 *	4.4		11/25/97	Timeout prototypes, interoperability
 *					mods.
 *							.
 *
 *  Notes:
 *       Licensed Materials
 *
 *       (C) Copyright International Business Machines Corp. 1994
 *       (C) Copyright Martin Marietta Energy Systems, Inc. and
 *                     Oak Ridge National Laboratory 1994
 *                     under CRADA No. Y1293-0203
 *       (C) Copyright Regents of The University of California and
 *                     Lawrence Livermore National Laboratory 1994
 *                     under CRADA No. T-253-92-C (as modified by T-325-92-C)
 *       (C) Copyright Regents of The University of California and
 *                     Los Alamos National Laboratory 1994
 *                     under CRADA No. LA93C10085
 *       (C) Copyright Sandia Corporation and Sandia National Laboratories 1994
 *                     under CRADA No. SC93/01198
 * 
 *       All rights reserved.
 * 
 *	None.
 *
 *--------------------------------------------------------------------------*/

#ifndef MVR_PROTOCOL_H
#define MVR_PROTOCOL_H

#if defined(NO_DCE)
/*
 * Address types.
 */

#define  NET_ADDRESS		1
#define  IPI_ADDRESS		2
#define  VESTA_ADDRESS		3
#define  FILE_ADDRESS		4
#define  SSEG_ADDRESS		5
#define  VVOL_ADDRESS		6
#define  PVOL_ADDRESS		7
#define  DEVICE_ADDRESS		8
#define  STRIPE_ADDRESS		9
#define  MEMORY_ADDRESS		10
#define  CLIENTFILE_ADDRESS	11

typedef struct shmaddress {
	unsigned32		Flags;
	unsigned32		ShmID;
	unsigned32		ShmOffset;
} shmaddress_t;

typedef struct netaddress {
	u_signed64		SockTransferID;
	struct {
		signed32	addr;
		signed32	port;
		signed32	family;
		} SockAddr;
	u_signed64		SockOffset;
} netaddress_t;

typedef struct ipiaddress {
	unsigned32		IPI3TransferID;
	struct {
		signed16	Interface;
		signed16	Pad1;
		char		Name[32];
		} IPI3Addr;
	u_signed64		IPI3Offset;
} ipiaddress_t;

#else	/* NODCE */

#include "hpss_iod.h"

#endif	/* NODCE */

/*
 *  The initiator message.  This is sent from active to passive and
 *  if the passive side will be the transfer initiator, replied with
 *  from passive to active.
 */

#define MVRPROT_TICKET_LENGTH		(8)

typedef struct initiator_msg {
	u_signed64	Delimiter;
	unsigned32	Flags;
	unsigned32	Type;
	u_signed64	Offset;
	u_signed64	Length;
	u_signed64	BlockSize;
	u_signed64	StripeWidth;
	u_signed64	Stride;
	u_signed64	TotalLength;
	char		SecurityTicket[MVRPROT_TICKET_LENGTH];
	u_signed64	CheckSum;
} initiator_msg_t;

/*
 *  Common byte offsets within the encoded arrays.
 */

#define MVRPROT_DELIM_OFFSET		(0)
#define MVRPROT_FLAGS_OFFSET		(8)

#define MVRPROT_INIT_TYPE_OFFSET	(12)
#define MVRPROT_INIT_OFFS_OFFSET	(16)
#define MVRPROT_INIT_LEN_OFFSET		(24)
#define MVRPROT_INIT_BLKSZ_OFFSET	(32)
#define MVRPROT_INIT_STRW_OFFSET	(40)
#define MVRPROT_INIT_STRIDE_OFFSET	(48)
#define MVRPROT_INIT_TOTLEN_OFFSET	(56)
#define MVRPROT_INIT_SECTKT_OFFSET	(64)
#define MVRPROT_INIT_CHKSUM_OFFSET	(72)

/*
 *  Flags bit values.
 */

#define MVRPROT_RESPONDER	0x00000001	/* request responder */
#define MVRPROT_ADDR_FOLLOWS	0x00000002	/* address follows msg */
#define MVRPROT_COMP_REPLY	0x00000004	/* send completion reply */
#define MVRPROT_HOLD_RESOURCES	0x00000008	/* don't close connection */

/*
 *  Message structure used to pass IP addresses.
 */

typedef struct initiator_ipaddr {
	u_signed64	Delimiter;
	unsigned32	Flags;
	netaddress_t	IpAddr;
	char		SecurityTicket[MVRPROT_TICKET_LENGTH];
	u_signed64	CheckSum;
} initiator_ipaddr_t;

#define MVRPROT_IPADDR_XFERID_OFFSET	(12)
#define MVRPROT_IPADDR_ADDR_OFFSET	(20)
#define MVRPROT_IPADDR_PORT_OFFSET	(24)
#define MVRPROT_IPADDR_FAMILY_OFFSET	(28)
#define MVRPROT_IPADDR_OFFS_OFFSET	(32)
#define MVRPROT_IPADDR_SECTKT_OFFSET    (40)
#define MVRPROT_IPADDR_CHKSUM_OFFSET	(48)

/*
 *  Message structure used to pass IPI-3 addresses.
 */

typedef struct initiator_ipi3addr {
	u_signed64	Delimiter;
	unsigned32	Flags;
	ipiaddress_t	Ipi3Addr;
	char		SecurityTicket[MVRPROT_TICKET_LENGTH];
	u_signed64	CheckSum;
} initiator_ipi3addr_t;

#define MVRPROT_IPIADDR_XFERID_OFFSET	(12)
#define MVRPROT_IPIADDR_INTRFC_OFFSET	(16)
#define MVRPROT_IPIADDR_NAME_OFFSET	(18)
#define MVRPROT_IPIADDR_OFFS_OFFSET	(50)
#define MVRPROT_IPIADDR_SECTKT_OFFSET	(58)
#define MVRPROT_IPIADDR_CHKSUM_OFFSET	(66)

/*
 *  Message structure used to pass Shared Memory addresses.
 */

typedef struct initiator_shmaddr {
	u_signed64	Delimiter;
	unsigned32	Flags;
	shmaddress_t	ShmAddr;
	char		SecurityTicket[MVRPROT_TICKET_LENGTH];
	u_signed64	CheckSum;
} initiator_shmaddr_t;

#define MVRPROT_SHMADDR_FLAGS_OFFSET	(12)
#define MVRPROT_SHMADDR_SHMID_OFFSET	(16)
#define MVRPROT_SHMADDR_OFFS_OFFSET	(20)
#define MVRPROT_SHMADDR_SECTKT_OFFSET	(24)
#define MVRPROT_SHMADDR_CHKSUM_OFFSET	(32)

/*
 *  Completion message optionally sent from the transfer responder to
 *  the transfer initiator.
 */

typedef struct completion_msg {
	u_signed64	Delimiter;
	unsigned32	Flags;
	unsigned32	Status;
	u_signed64	BytesMoved;
	char		SecurityTicket[MVRPROT_TICKET_LENGTH];
	u_signed64	CheckSum;
} completion_msg_t;

#define MVRPROT_COMP_STATUS_OFFSET	(12)
#define MVRPROT_COMP_BMOVED_OFFSET	(16)
#define MVRPROT_COMP_SECTKT_OFFSET	(24)
#define MVRPROT_COMP_CHKSUM_OFFSET	(32)

/*
 *  Macros to build and verify the message delimiters.
 */

#define MVRPROT_BUILDDELIM(d)	\
		((d) = bld64m(0x01234567,0x89ABCDEF))

#define MVRPROT_CHECKDELIM(d)	\
		(neq64m((d),bld64m(0x01234567,0x89ABCDEF)))

/*
 *  The following constants are used for the sizes of taken up
 *  in the character arrays used to transfer data between machines.
 */

#define	MVRPROT_SHORT_SIZE	(2)
#define MVRPROT_LONG_SIZE	(4)
#define MVRPROT_UNS64_SIZE	(8)

#define MVRPROT_INITMSG_SIZE	(80)
#define MVRPROT_COMPMSG_SIZE	(40)
#define MVRPROT_IPADDR_SIZE	(56)
#define MVRPROT_IPI3ADDR_SIZE	(74)
#define MVRPROT_SHMADDR_SIZE	(40)

/*
 *  Prototypes.
 */

void
mvrprot_decode_chars(
char			*DataPtr,
int			Index,
char			*CharPtr,
int			Count);

void
mvrprot_encode_chars(
char			*DataPtr,
int			Index,
char			*CharPtr,
int			Count);

void
mvrprot_decode_16(
char			*DataPtr,
int			Index,
unsigned16		*ShortPtr);

void
mvrprot_encode_16(
char			*DataPtr,
int			Index,
unsigned16		ShortValue);

void
mvrprot_decode_32(
char			*DataPtr,
int			Index,
unsigned32		*LongPtr);

void
mvrprot_encode_32(
char			*DataPtr,
int			Index,
unsigned32		LongValue);

void
mvrprot_decode_64(
char			*DataPtr,
int			Index,
u_signed64		*BigPtr);

void
mvrprot_encode_64(
char			*DataPtr,
int			Index,
u_signed64		BigValue);

long
mvrprot_recv_initmsg(
int			SockFD,
initiator_msg_t		*InitPtr);

long
mvrprot_recv_initmsg_timeout(
int			SockFD,
initiator_msg_t		*InitPtr,
int			SecTimeout);

long
mvrprot_send_initmsg(
int			SockFD,
initiator_msg_t		*InitPtr);

long
mvrprot_send_initmsg_timeout(
int			SockFD,
initiator_msg_t		*InitPtr,
int			SecTimeout);

long
mvrprot_recv_ipaddr(
int			SockFD,
initiator_ipaddr_t	*InitIpPtr);

long
mvrprot_recv_ipaddr_timeout(
int			SockFD,
initiator_ipaddr_t	*InitIpPtr,
int			SecTimeout);

long
mvrprot_send_ipaddr(
int			SockFD,
initiator_ipaddr_t	*InitIpPtr);

long
mvrprot_send_ipaddr_timeout(
int			SockFD,
initiator_ipaddr_t	*InitIpPtr,
int			SecTimeout);

long
mvrprot_recv_ipi3addr(
int			SockFD,
initiator_ipi3addr_t	*InitIpi3Ptr);

long
mvrprot_recv_ipi3addr_timeout(
int			SockFD,
initiator_ipi3addr_t	*InitIpi3Ptr,
int			SecTimeout);

long
mvrprot_send_ipi3addr(
int			SockFD,
initiator_ipi3addr_t	*InitIpi3Ptr);

long
mvrprot_send_ipi3addr_timeout(
int			SockFD,
initiator_ipi3addr_t	*InitIpi3Ptr,
int			SecTimeout);

long
mvrprot_recv_shmaddr(
int			SockFD,
initiator_shmaddr_t	*ShmAddrPtr);

long
mvrprot_recv_shmaddr_timeout(
int			SockFD,
initiator_shmaddr_t	*ShmAddrPtr,
int			SecTimeout);

long
mvrprot_send_shmaddr(
int			SockFD,
initiator_shmaddr_t	*ShmAddrPtr);

long
mvrprot_send_shmaddr_timeout(
int			SockFD,
initiator_shmaddr_t	*ShmAddrPtr,
int			SecTimeout);

long
mvrprot_recv_compmsg(
int			SockFD,
completion_msg_t	*CompPtr);

long
mvrprot_recv_compmsg_timeout(
int			SockFD,
completion_msg_t	*CompPtr,
int			SecTimeout);

long
mvrprot_send_compmsg(
int			SockFD,
completion_msg_t	*CompPtr);

long
mvrprot_send_compmsg_timeout(
int			SockFD,
completion_msg_t	*CompPtr,
int			SecTimeout);

#endif		/* ifndef MVR_PROTOCOL_H */
