/*
 * @(#)hpss_types.h	1.1 11/04/98 CERN IT-PDP/DM Olof Barring
 */
 
/* static char SccsId[] = "include/hpss_types.h, gen, 3v2   11/25/97   15:57:33   "; */
/*==============================================================================
 *
 * Include Name:
 *      hpss_types.h
 *
 * Description:
 *      Include file for common, basic data types.  Compile with NO_DCE if
 *      not using DCE.
 *
 * Traceability:
 *      Version   Author     Date    Description
 *      -------  --------  --------  -------------------------------------------
 *          1.0     tyler  07/19/93  Initial version
 *          1.2     tyler  05/03/94  Changed #if !defined for dependency tool
 *         1.x     07/05/94   Copyright Update
 *          4.1    hilary  05/10/96  AIX 4.1 upgrade: get typedef of byte
 *                                   from <dce/dce.h>; rename unsigned64
 *	    4.2    WHR     10/09/97  Modified defined(cray) ... to BYTE8INT
 *	    4.3    WHR     10/25/97  Fix for TERAFLOP
 *
 *  Notes:
 *       Licensed Materials
 *
 *       (C) Copyright International Business Machines Corp. 1994
 *       (C) Copyright Martin Marietta Energy Systems, Inc. and
 *                     Oak Ridge National Laboratory 1994
 *                     under CRADA No. Y1293-0203
 *       (C) Copyright Regents of The University of California and
 *                     Lawrence Livermore National Laboratory 1994
 *                     under CRADA No. T-253-92-C (as modified by T-325-92-C)
 *       (C) Copyright Regents of The University of California and
 *                     Los Alamos National Laboratory 1994
 *                     under CRADA No. LA93C10085
 *       (C) Copyright Sandia Corporation and Sandia National Laboratories 1994
 *                     under CRADA No. SC93/01198
 * 
 *       All rights reserved.
 * 
 *      None
 *
 *----------------------------------------------------------------------------*/

#ifndef hpss_types_h
#define hpss_types_h

#ifdef NO_DCE

#define USE_DEFAULT_REPS

/*==============================================================================
 * Cray specific definitions
 *============================================================================*/

#if defined(BYTE8INT)

#undef USE_DEFAULT_REPS

#define byte             unsigned char
#if defined(__alpha) && defined(__osf__)
#define signed8          char
#define unsigned8        unsigned char
#else
#define signed8          short int
#define unsigned8        unsigned short int
#endif
#define signed16         short int
#define unsigned16       unsigned short int
#define signed32         int
#define unsigned32       unsigned int
#define u_signed64       unsigned long int

#endif	/* BYTE8INT */


/*==============================================================================
 * Vax, M_I86, MIPSEL, __i860__ specific definitions
 *============================================================================*/

#if defined(LITTLEEND) && !defined(BYTE8INT) && !defined(__TERAFLOP__)

#undef USE_DEFAULT_REPS

#define byte             unsigned char
#define signed8          char
#define unsigned8        unsigned char
#define signed16         short int
#define unsigned16       unsigned short int
#define signed32         long int
#define unsigned32       unsigned long int
				/* Use little-endian for u_signed64 */
struct u_signed64_rep    {unsigned32 low; unsigned32 high;};
#define u_signed64       struct u_signed64_rep

#endif	/* LITTLEEND  && ! BYTE8INT */

/*==============================================================================
 * Default definitions (for 32-bit architectures)
 *============================================================================*/

#ifdef USE_DEFAULT_REPS

#define byte             unsigned char
#define signed8          char
#define unsigned8        unsigned char
#define signed16         short int
#define unsigned16       unsigned short int
#define signed32         long int
#define unsigned32       unsigned long int
				/* Use big-endian for u_signed64 */
struct u_signed64_rep    {unsigned32 high; unsigned32 low;};
#define u_signed64       struct u_signed64_rep

#endif	/* USE_DEFAULT_REPS */

#else	/* NO_DCE - Use DCE NCA definitions */

#if defined(_AIX41) || defined(__alpha)
#include <dce/dce.h>		/* Has typedef for byte */
#endif	/* _AIX41 || __alpha */
#include "hpss_idl_types.h"
#if !defined(_AIX41) && !defined(__alpha)
typedef idl_byte	byte;
#endif

#endif	/* NO_DCE */

#endif	/* hpss_types_h */
