#!/bin/ksh
#
#		Copyright (C) 1996-1997 by CERN/IT/PDP/DM
#		All rights reserved
#
# @(#)tpcpin.ksh	1.5 04/14/99 CERN IT-PDP/DM Christian Boissat
#
# Temporary version of stagein, to have it operate with
# the copytape facility
#
# Dependencies:
#	${STAGEIN}
#	${STAGEQRY}
#
STAGEIN=/usr/local/bin/stagein
STAGEQRY=/usr/local/bin/stageqry
TPCPD=/usr/spool/copytape/tpcopy	# Directory for on-going requests
TPCPF=tpcopy_				# Associated filenames
STAGERC=" 0 | 193 | 194 | 195 | 197 "	# Possible successful return codes
PATH=${PATH}:/usr/ucb			# Path extended (for Solaris)
#
#	Kill the named process
killproc() {
#
#		Retrieve child process identifier
	line="`ps -fu ${user} | grep -v grep | grep \"$$.*${STAGEIN}\"`"
	test -n "${line}" && kill -INT `echo ${line} | cut -d' ' -f2`
}
trap 'killproc; rm -f ${tpfile} ${tpfile}[-+]*; exit 1' 2 15	# Interrupted command
#
#	Local variables
user=`whoami`
fseqs=1
vid=""
#
#	Find parent process
ppid=`ps -fp $$ | grep -v PPID | cut -c1-40 | awk '{print $3}'`
tpfile=${TPCPD}/${TPCPF}${ppid}
#
#	Save arguments list
args="$*"
nargs="`echo ${args} | sed -e 's/-z //'`"
#
#	Scan arguments list
set -- `getopt A:b:C:d:E:F:f:Gg:h:I:L:l:N:op:q:S:s:TU:u:V:v:X:z $*`
if [ $? -eq 0 ]; then
	while [ $# -gt 1 ]
	do
		case $1 in
		-G|-o|-T|-z)
			;;
		-A)
#			Deferred allocation
			shift
			;;
		-q)
#
#				File sequence numbers specified ?
			shift
			fseqs=$1
			;;
		-V)
#
#				Volume identifier specified ?
			shift
			vid=$1
			;;
		*)
			shift
		esac
		shift
	done
fi
#
#	File creation mask
umask 0
#
#	Upate control files
if [ -d ${TPCPD} -a -n "${vid}" ]; then
#
#		Create control file if needed
	test -s ${tpfile} || > ${tpfile}
#
#		Find all file sequence numbers
	line="${vid}"
	for fseq in `echo ${fseqs} | tr ',' ' '`
	do
		fsq111="0`echo ${fseq} | cut -d'-' -f1`"
		fsq11=`expr ${fsq111} + 0`
		fsq1=${fsq11:-1}
		fsq222="0`echo ${fseq} | cut -d'-' -f2`"
		fsq22=`expr ${fsq222} + 0`
		fsq2=${fsq22:-1}
#
#			Find all pathnames
		while [ ${fsq1} -le ${fsq2} ]
		do
			line="${line}|\.${fsq1}\."
			fsq1=`expr ${fsq1} + 1`
		done
	done
#
#		${tpfile}- has the following format:
#			vid|\.fsq1\.|\.fsq2\.|...|\.fsqn\.
	echo "${line}" > ${tpfile}-
fi
#
#	Execute stage command in background
jobs > /dev/null 2>&1
${STAGEIN} ${nargs} &
#
#	Wait for end of command
wait %1
stagerc=$?
#
#	Execute stage command in background again to have filenames in order
if [[ ${STAGERC} = +(* ${stagerc} *) ]]; then
	jobs > /dev/null 2>&1
	( ${STAGEIN} ${args} 2>&1 | grep STG47 1>&2 ) &
	wait %1
#
#		Add full pathnames for staged files
	if [ -f ${tpfile} -a -f ${tpfile}- ]; then
		fseqs="`cat ${tpfile}- | cut -d'|' -f2-`"
		${STAGEQRY} -V${vid} -P | egrep "${fseqs}" >> ${tpfile}
	fi
else
	rm -f ${tpfile}
fi
#
#	Remove obsolete information
rm -f ${tpfile}-
#
#	Exit
exit ${stagerc}
#EOF
