/*
 * Copyright (C) 1995-1998 by CERN/CN/PDP/DS
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)ctpdaemon.c	1.20 05/05/98 CERN CN-PDP/DS Jean-Philippe Baud";
#endif /* not lint */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#include <sys/types.h>
#include <fcntl.h>
#if sgi || sun || ultrix
#include <sys/termio.h>
#endif
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/time.h>
#if _AIX
#include <sys/un.h>
#endif
#if _AIX && _IBMR2
#include <sys/select.h>
#endif
#include <sys/wait.h>
#if defined(ultrix) || (defined(sun) && !defined(SOLARIS))
#include <sys/resource.h>
#endif
#include "copytape.h"
#include "marshall.h"
#undef  unmarshall_STRING
#define unmarshall_STRING(ptr,str)  { str = ptr ; INC_PTR(ptr,strlen(str)+1) ; }
#include "net.h"
#include "rfio.h"
extern char *getconfent();
extern char *optarg;
extern int optind;
#if !defined(linux)
extern char *sys_errlist[];
#endif
char func[16];
int inpflg;
char inpvid1[7];
char logbuf[PRTBUFSZ];
int maxfds;
int nb_inp_tp;
int nb_out_tp;
int outflg;
char outvid1[7];
fd_set readfd, readmask;
int reqid;
int rpfd;
int run_limit;
int running;
#if (defined(_AIX) && defined(_IBMR2)) || defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha)) || defined(linux)
struct sigaction sa;
#endif
struct waitq *waitqp;

main()
{
	int c, l;
	char *clienthost;
	int ctp_s;
	struct sockaddr_in from;
	int fromlen = sizeof(from);
	struct hostent *hp;
	int magic;
	int msglen;
	char *rbp;
	char req_data[REQBUFSZ-3*LONGSIZE];
	char req_hdr[3*LONGSIZE];
	int req_type;
	int rqfd;
	struct sockaddr_in sin;		/* internet address */
	struct servent *sp;
	struct stat st;
	struct timeval timeval;
	void wait4child();

#if defined(ultrix) || (defined(sun) && !defined(SOLARIS)) || (defined(__osf__) && defined(__alpha)) || defined(linux)
        maxfds = getdtablesize();
#else
	maxfds = _NFILE;
#endif
#ifndef TEST
	/* Background */
	if ((c = fork()) < 0) {
		fprintf (stderr, "ctpdaemon: cannot fork\n");
		exit (1);
	} else
		if (c > 0) exit (0);
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(_IBMESA)
	c = setpgrp(0, getpid());
#else
#if (defined(__osf__) && defined(__alpha)) || defined(linux)
	c = setsid();
#else
#if HPUX10
	c = setpgrp3();
#else
	c = setpgrp();
#endif
#endif
#endif
	for (c = 0; c < maxfds; c++)
		close (c);
#if ultrix || sun || sgi
	c = open ("/dev/tty", O_RDWR);
	if (c >= 0) {
		ioctl (c, TIOCNOTTY, 0);
		(void) close(c);
	}
#endif
#endif
#if defined(ultrix) || (defined(sun) && !defined(SOLARIS)) || (defined(_AIX) && defined(_IBMESA))
        signal (SIGCHLD, wait4child);
#else
#if (defined(sgi) && !defined(IRIX5)) || defined(hpux)
        signal (SIGCLD, wait4child);
#else
#if (defined(_AIX) && defined(_IBMR2)) || defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha)) || defined(linux)
        sa.sa_handler = wait4child;
        sa.sa_flags = SA_RESTART;
        sigaction (SIGCHLD, &sa, NULL);
#endif
#endif
#endif
	strcpy (func, "ctpdaemon");
	ctplogit (func, "started\n");

	FD_ZERO (&readmask);
	FD_ZERO (&readfd);
	signal (SIGPIPE,SIG_IGN);

	umask (0);
	c = RFIO_NONET;
	rfiosetopt (RFIO_NETOPT, &c, 4);

	/* Open request socket */

	if ((ctp_s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
		ctplogit (func, CTP08, "", "socket", sys_errlist[errno]);
		exit (CONFERR);
	}
	if ((sp = getservbyname ("copytape", "tcp")) == NULL) {
		ctplogit (func, CTP24, "copytape not defined in /etc/services");
		exit (CONFERR);
	}
	memset ((char *)&sin, 0, sizeof(struct sockaddr_in)) ;
	sin.sin_family = AF_INET ;
	sin.sin_port = sp->s_port;
	sin.sin_addr.s_addr = htonl(INADDR_ANY);
	if (bind (ctp_s, (struct sockaddr *) &sin, sizeof(sin)) < 0) {
		ctplogit (func, CTP08, "", "bind", sys_errlist[errno]);
		exit (CONFERR);
	}
	listen (ctp_s, 1) ;
	
	FD_SET (ctp_s, &readmask);

	/* main loop */

	while (1) {
		checkwaitq ();
		if (FD_ISSET (ctp_s, &readfd)) {
			rqfd = accept (ctp_s, (struct sockaddr *) &from, &fromlen);
			reqid++;
			l = netread (rqfd, req_hdr, sizeof(req_hdr));
			if (l == sizeof(req_hdr)) {
				rbp = req_hdr;
				unmarshall_LONG (rbp, magic);
				unmarshall_LONG (rbp, req_type);
				unmarshall_LONG (rbp, msglen);
				rpfd = rqfd;
				l = msglen - sizeof(req_hdr);
				netread (rqfd, req_data, l);
				if (req_type == TPCOPY)
					if (stat (NOMORECPTP, &st) == 0) {
						sendrep (rpfd, COPYTAPERC,
							req_type, ESTNACT);
						goto endreq;
				}
				if (getpeername (rqfd, (struct sockaddr*)&from,
					&fromlen) < 0) {
					ctplogit (func, CTP08, "", "getpeername",
						sys_errlist[errno]);
				}
				hp = gethostbyaddr ((char *)(&from.sin_addr),
					sizeof(struct in_addr),from.sin_family);
				if (hp == NULL)
					clienthost = inet_ntoa (from.sin_addr);
				else
					clienthost = hp->h_name ;
				switch (req_type) {
				case TPCOPY:
					proccpreq (req_data, clienthost, l);
					break;
				case CTPKILL:
					prockilreq (req_data, clienthost);
					break;
				case CTPQRY:
					procqryreq (req_data, clienthost);
					break;
				default:
					sendrep (rpfd, MSG_ERR, CTP15, req_type);
					sendrep (rpfd, COPYTAPERC, req_type, USERR);
				}
			} else {
				close (rqfd);
				if (l != 0)
					ctplogit (func, CTP17, l);
			}
endreq:
			FD_CLR (rqfd, &readfd);
		}
		memcpy (&readfd, &readmask, sizeof(readmask));
		timeval.tv_sec = CHECKI;	/* must set each time for linux */
		timeval.tv_usec = 0;
		if (select (maxfds, &readfd, (fd_set *)0, (fd_set *)0, &timeval) < 0) {
			FD_ZERO (&readfd);
		}
	}
}

proccpreq(req_data, clienthost, reqlen)
char *req_data;
char *clienthost;
int reqlen;
{
	struct waitq *add2wq();
	char **argv;
	int c, i;
	int clientpid;
	gid_t gid;
#if (defined(sun) && !defined(SOLARIS)) || defined(ultrix) || defined(vms)
	int mask;
#else
	mode_t mask;
#endif
	char *name;
	int nargs;
	char *rbp;
	uid_t uid;
	char *user;
	struct waitq *wqp = NULL;

	inpflg = 0;
	inpvid1[0] = '\0';
	nb_inp_tp = 0;
	nb_out_tp = 0;
	outflg = 0;
	outvid1[0] = '\0';
	rbp = req_data;
	unmarshall_STRING (rbp, user);	/* login name */
	unmarshall_STRING (rbp, name);
	unmarshall_WORD (rbp, uid);
	unmarshall_WORD (rbp, gid);
	unmarshall_WORD (rbp, mask);
	unmarshall_WORD (rbp, clientpid);
	unmarshall_WORD (rbp, nargs);
	argv = (char **) malloc ((nargs + 1) * sizeof(char *));
	unmarshall_STRING (rbp, argv[0]);
	strcpy (logbuf, argv[0]);
	for (i = 1; i < nargs; i++) {
		unmarshall_STRING (rbp, argv[i]);
		strcat (logbuf, " ");
		strcat (logbuf, argv[i]);
	}
	argv[nargs] = NULL;
	ctplogit (func, "request by %s (%d,%d) from %s\n",
		user, uid, gid, clienthost);
	ctplogit (func, CTP98, logbuf);

	if (chkopt (nargs, argv)) {
		c = USERR;
		goto reply;
	}
	wqp = add2wq (clienthost, user, uid, gid, clientpid);
	wqp->reqlen = reqlen;
	wqp->req_data = (char *) malloc (reqlen);
	memcpy (wqp->req_data, req_data, reqlen);

	if (c = procinpdir (rbp, req_data + reqlen)) goto reply;
	strcpy (wqp->inpvid1, inpvid1);
	strcpy (wqp->outvid1, outvid1);
	sendrep (rpfd, MSG_ERR, CTP27);		/* request queued */
	free (argv);
	return;
reply:
	if (wqp)
		rmfromwq (wqp);
        free (argv);
        sendrep (rpfd, COPYTAPERC, TPCOPY, c);
}

prockilreq(req_data, clienthost)
char *req_data;
char *clienthost;
{
	int clientpid;
	gid_t gid;
	char *rbp;
	char *user;
	struct waitq *wqp;

	rbp = req_data;
	unmarshall_STRING (rbp, user);	/* login name */
	unmarshall_WORD (rbp, gid);
	unmarshall_WORD (rbp, clientpid);

	wqp = waitqp;
	while (wqp) {
		if (wqp->clientpid == clientpid &&
		    strcmp (wqp->clienthost, clienthost) == 0 &&
		    wqp->gid == gid &&
		    strcmp (wqp->user, user) == 0) {
			ctplogit (func, "kill received for request %d\n", wqp->reqid);
			if (wqp->ovl_pid) {
				ctplogit (func, "killing process %d\n", wqp->ovl_pid);
				wqp->status = REQSIGD;	/* request signalled */
				kill (wqp->ovl_pid, SIGINT);
			} else
				wqp->status = REQKILD;	/* request killed */
			break;
		} else {
			wqp = wqp->next;
		}
	}
	close (rpfd);
}

procqryreq(req_data, clienthost)
char *req_data;
char *clienthost;
{
	gid_t gid;
	int hdrprinted = 0;
	char p_stat[8];
	char *rbp;
	static char title[] =
		"1st inp vid    1st out vid    Owner    State    Request\n";
	char *user;
	struct waitq *wqp;

	rbp = req_data;
	unmarshall_STRING (rbp, user);	/* login name */
	unmarshall_WORD (rbp, gid);
	ctplogit (func, CTP98, "copytape -Q");

	wqp = waitqp;
	while (wqp) {
		if (hdrprinted++ == 0) {
			sendrep (rpfd, MSG_OUT, title);
		}
		if (wqp->req_data)
			strcpy (p_stat, "QUEUED");
		else
			strcpy (p_stat, "RUNNING");
		sendrep (rpfd, MSG_OUT, "%-6s         %-6s         %-8.8s %-7.7s  %-6d\n",
			wqp->inpvid1, wqp->outvid1, wqp->user, p_stat, wqp->reqid);
		wqp = wqp->next;
	}
	sendrep (rpfd, COPYTAPERC, CTPQRY, 0);
}

struct waitq *
add2wq(clienthost, user, uid, gid, clientpid)
char *clienthost;
char *user;
uid_t uid;
gid_t gid;
int clientpid;
{
	/* add request to the wait queue */
	struct waitq *prev, *wqp;

	wqp = waitqp;
	while (wqp) {
		prev = wqp;
		wqp = wqp->next;
	}
	wqp = (struct waitq *) calloc (1, sizeof(struct waitq));
	if (!waitqp) {	/* queue is empty */
		waitqp = wqp;
	} else {
		prev->next = wqp;
		wqp->prev = prev;
	}
	strcpy (wqp->clienthost, clienthost);
	strcpy (wqp->user, user);
	wqp->uid = uid;
	wqp->gid = gid;
	wqp->clientpid = clientpid;
	wqp->reqid = reqid;
	wqp->rpfd = rpfd;
	wqp->ovl_pid = 0;
	wqp->status = -1;
	return (wqp);
}

checkfseq(fseq)
char *fseq;
{
	char *dp;
	int n1, n2;
	int nbtpf;
	char *p, *q;

	if (*(fseq + strlen (fseq) - 1) == '-') {
		if (! inpflg) {
			sendrep (rpfd, MSG_ERR, CTP13);
			return (0);
		}
		/* *(fseq + strlen (fseq) - 1) = '\0'; */
		sendrep (rpfd, MSG_ERR, "trailing dash in -q option is not supported yet\n");
		return (0);
	}
	switch (*fseq) {
	case 'n':
		if (! outflg) {
			sendrep (rpfd, MSG_ERR, CTP12, "-qn", "input tape");
			return (0);
		}
	case 'u':
		if (strlen (fseq) == 1) {
			nbtpf = 1;
		} else {
			nbtpf = strtol (fseq + 1, &dp, 10);
			if (*dp != '\0') {
				sendrep (rpfd, MSG_ERR, CTP02, "-q");
				return (0);
			}
		}
		break;
	default:
		nbtpf = 0;
		n2 = 0;
		p = strtok (fseq, ",");
		while (p) {
			if (q = strchr (p, '-')) {
				*q = '\0';
				n1 = strtol (p, &dp, 10);
				if (*dp != '\0' ||
				    (outflg && n2 && n1 != (n2 + 1))) {
					sendrep (rpfd, MSG_ERR, CTP02, "-q");
					return (0);
				}
				n2 = strtol (q + 1, &dp, 10);
				if (*dp != '\0') {
					sendrep (rpfd, MSG_ERR, CTP02, "-q");
					return (0);
				}
				*q = '-';
			} else {
				n1 = strtol (p, &dp, 10);
				if (*dp != '\0' ||
				    (outflg && n2 && n1 != (n2 + 1))) {
					sendrep (rpfd, MSG_ERR, CTP02, "-q");
					return (0);
				}
				n2 = n1;
			}
			nbtpf += n2 - n1 + 1;
			if (p = strtok (NULL, ",")) *(p - 1) = ',';
		}
	}
	return (nbtpf);
}

void
checkovlstatus(pid, status)
int pid;
int status;
{
	int found;
	int savereqid;
	struct waitq *wqp;

	savereqid = reqid;
	found =  0;
	wqp = waitqp;
	while (wqp) {
		if (wqp->ovl_pid == pid) {
			found = 1;
			break;
		}
		wqp = wqp->next;
	}
	if (! found) {          /* entry already discarded from waitq */
		reqid = 0;
	} else {		/* request previously running */
		reqid = wqp->reqid;
		wqp->ovl_pid = 0;
		if (wqp->status < 0 || wqp->status == REQSIGD)
			wqp->status = (status & 0xFF) ?
				SYERR : ((status >> 8) & 0xFF);
		running--;
	}
	ctplogit (func, "tpcopy process %d exiting with status %x\n",
		pid, status & 0xFFFF);
	reqid = savereqid;
}

/*
 *  Three possible different states for a copytape request...
 *    waiting : status<0  && ovl_pid=0
 *    running : status<0  && ovl_pid>0
 *    exiting : status>=0 && ovl_pid>=0
 *  The selection criteria are to start a new request...
 *    running request  : weight=MAXINT
 *    waiting request  : weight='number of older requests for the same user'
 *    selected request : running<run_limit && 0<=min(weights)<MAXINT
 *
 */
checkwaitq()
{
	int c;
	char *p;
	int savereqid;
	struct waitq *wqp, *wqp1, *wqp2, *b_wqp;
	int b_weight, c_weight;

	if (waitqp) {
		savereqid = reqid;
		wqp = waitqp;
		while (wqp) {	/* remove exited or killed requests */
			reqid = wqp->reqid;
			if (wqp->status >= 0 && wqp->status != REQSIGD) {
				if (wqp->status != REQKILD)
					sendrep (wqp->rpfd, COPYTAPERC, TPCOPY,
						wqp->status);
				else
					close (wqp->rpfd);
				wqp1 = wqp;
				wqp = wqp->next;
				rmfromwq (wqp1);
			} else
				wqp = wqp->next;
		}
		if ((p = getconfent ("CPTAPE", "RUN_LIMIT", 0)) == NULL ||
		    (run_limit = atoi (p)) <= 0)
			run_limit = 1;
		if (running < run_limit) {	/* there is a free slot */
			wqp = waitqp;
			b_weight = MAXINT, b_wqp = NULL;
			while (wqp) {
				reqid = wqp->reqid;
				if (wqp->status < 0 && wqp->ovl_pid == 0) {
					c_weight = 0;
					wqp2 = waitqp;
					while (wqp2 != wqp) {
						if (wqp2->uid == wqp->uid)
							c_weight++;
						wqp2 = wqp2->next;
					}
					ctplogit (func, "current weight %d\n",
						c_weight);
				} else		/* running or exiting request */
					c_weight = MAXINT;
				if (c_weight < b_weight) {	/* select a better one */
					b_weight = c_weight;
					b_wqp = wqp;
				}
				if (c_weight == 0) break;	/* break condition */
				wqp = wqp->next;
			}
			if (b_wqp != NULL) {	/* start the best one */
				ctplogit (func, "free slot: running %d run_limit %d\n",
					running, run_limit);
				if (c = fork_exec_tpcopy (b_wqp)) {
					b_wqp->status = c;
				} else {
					free (b_wqp->req_data);
					b_wqp->req_data = 0;
				}
			}
		}
		reqid = savereqid;
	}
}

chkopt(nargs, argv)
int nargs;
char **argv;
{
	int c;
	char *dp;
	int errflg = 0;
	int fflag = 0;
	int keepid = 0;	/* keep vid/fseq from input tape in fid of output tape */
	int n;
	char *p;

	optind = 1;
	while ((c = getopt (nargs, argv, "b:C:d:E:F:f:Gg:kL:l:mN:q:S:s:Tt:V:v:")) != EOF) {
		switch (c) {
		case 'b':
			n = strtol (optarg, &dp, 10);
			if (*dp != '\0' || n == 0) {
				sendrep (rpfd, MSG_ERR, CTP02, "-b");
				errflg++;
			}
			break;
		case 'C':	/* character conversion */
			if (strcmp (optarg, "ebcdic") &&
			    strcmp (optarg, "ascii")) {
				fprintf (stderr, CTP02, "-C");
				errflg++;
			}
			break;
		case 'E':
			if (strcmp (optarg, "skip") &&
			    strcmp (optarg, "keep") &&
			    strcmp (optarg, "ignoreeoi") &&
			    strcmp (optarg, "halt")) {
				sendrep (rpfd, MSG_ERR, CTP02, "-E");
				errflg++;
			}
			break;
		case 'F':
			if (strcmp (optarg, "F") && strcmp (optarg, "FB") &&
			    strcmp (optarg, "FBS") && strcmp (optarg, "FS") &&
			    strcmp (optarg, "U")) {
				sendrep (rpfd, MSG_ERR, CTP02, "-F");
				errflg++;
			}
			break;
		case 'f':
			if (keepid) {
				sendrep (rpfd, MSG_ERR, CTP16);
				errflg++;
			} else
				fflag++;
			break;
		case 'k':
			if (fflag) {
				sendrep (rpfd, MSG_ERR, CTP16);
				errflg++;
			} else
				keepid++;
			break;
		case 'L':
			n = strtol (optarg, &dp, 10);
			if (*dp != '\0' || n == 0) {
				sendrep (rpfd, MSG_ERR, CTP02, "-L");
				errflg++;
			}
			break;
		case 'l':
			if (strcmp (optarg, "blp") == 0 && ! inpflg) {
				sendrep (rpfd, MSG_ERR, CTP12, "-l blp", "output tape");
				errflg++;
			}
			break;
		case 'N':
			n = strtol (optarg, &dp, 10);
			if (*dp != '\0') {
				sendrep (rpfd, MSG_ERR, CTP02, "-N");
				errflg++;
			}
			break;
		case 'q':
			if (checkfseq (optarg) == 0)
				errflg++;
			break;
		case 's':
			p = strtok (optarg, ":");
			while (p) {
				n = strtol (p, &dp, 10);
				if (*dp != '\0') {
					sendrep (rpfd, MSG_ERR, CTP02, "-s");
					errflg++;
				}
				if (p = strtok (NULL, ":")) *(p - 1) = ':';
			}
			break;
		case 't':
			n = strtol (optarg, &dp, 10);
			if (*dp != '\0') {
				sendrep (rpfd, MSG_ERR, CTP02, "-t");
				errflg++;
			}
			break;
		case 'V':
			if (inpflg && inpvid1[0] == '\0')
				strcpy (inpvid1, optarg);
			else if (outflg && outvid1[0] == '\0')
				strcpy (outvid1, optarg);
			break;
		}
	}
	return (errflg);
}

dir2argv(inpdir, argvp)
char *inpdir;
char ***argvp;
{
	char **argv;
	int c;
	int nargs;
	char *p;
	int parm;

	nargs = 1;
	p = inpdir;
	parm = 0;
	while (c = *p++) {
		if (c == ' ' || c == '\t') {
			parm = 0;
		} else if (!parm) {
				parm++;
				nargs++;
		}
	}
	argv = (char **) malloc ((nargs + 1) * sizeof(char *));
	argv[0] = "copytape";
	nargs = 1;
	p = inpdir;
	parm = 0;
	while (c = *p++) {
		if (c == ' ' || c == '\t') {
			if (parm) {
				parm = 0;
				*(p - 1) = '\0';
			}
		} else if (!parm) {
			parm++;
			argv[nargs++] = p - 1;
		}
	}
	argv[nargs] = NULL;
	*argvp = argv;
	return (nargs);
}

fork_exec_tpcopy(wqp)
struct waitq *wqp;
{
	char arg_reqid[7], arg_reqlen[5], arg_rpfd[3];
	int c;
	static int pfd[2];
	int pid;
	char progfullpath[MAXPATH];

	if (pipe (pfd) < 0) {
		sendrep (wqp->rpfd, MSG_ERR, CTP08, "", "pipe", sys_errlist[errno]);
		return (SYERR);
	}
	wqp->ovl_pid = fork ();
	pid = wqp->ovl_pid;
	if (pid < 0) {
		sendrep (wqp->rpfd, MSG_ERR, CTP08, "", "fork", sys_errlist[errno]);
		return (SYERR);
	} else if (pid == 0) {  /* we are in the child */
		for (c = 0; c < maxfds; c++)
			if (c != pfd[0] && c != wqp->rpfd) close (c);
		dup2 (pfd[0], 0);
		sprintf (progfullpath, "%s/tpcopy", BIN);
		sprintf (arg_reqid, "%d", wqp->reqid);
		sprintf (arg_rpfd, "%d", wqp->rpfd);
		sprintf (arg_reqlen, "%d", wqp->reqlen);
		ctplogit (func, "execing tpcopy, pid=%d\n", getpid());
		execl (progfullpath, "tpcopy", arg_reqid, arg_rpfd, arg_reqlen, 0);
		ctplogit (func, CTP08, "tpcopy", "execl", sys_errlist[errno]);
		exit (SYERR);
	} else {
		running++;
		close (pfd[0]);
		write (pfd[1], wqp->req_data, wqp->reqlen);
		close (pfd[1]);
	}
	return (0);
}

get_nb_in_out_tp()
{
	char *q;

	q = strtok (NULL, " \t");
	nb_inp_tp = atoi (q);
	q = strtok (NULL, " \t");
	nb_out_tp = atoi (q);
}

procinpdir(inpdir, reqend)
char *inpdir;
char *reqend;
{
	char **argv_d;
	int blindmode = 0;
	char *buf;
	char *dp;
	int errflg = 0;
	int mergemode = 0;
	int n;
	int nargs;
	int inp_tp_index;
	int out_tp_index;
	char *p;
	char *rbp;
	int splitmode = 0;

	/* check the directives */

	rbp = inpdir;
	while (rbp < reqend) {
		unmarshall_STRING (rbp, buf);
		ctplogit (func, CTP97, buf);
		p = buf + strspn (buf, " \t");
		if (*p != '-') {
			p = strtok (p, " \t");
			UPPER (p);
			if (strcmp (p, "BLIND") == 0) {
				(void) get_nb_in_out_tp();
				if (nb_inp_tp <= 0 || nb_out_tp != nb_inp_tp) {
					sendrep (rpfd, MSG_ERR, CTP01, p);
					return (USERR);
				}
				blindmode = 1;
			} else if (strcmp (p, "MERGE") == 0) {
				(void) get_nb_in_out_tp();
				if (nb_inp_tp <= 0 || nb_out_tp != 1) {
					sendrep (rpfd, MSG_ERR, CTP01, p);
					return (USERR);
				}
				mergemode = 1;
			} else if (strcmp (p, "SPLIT") == 0) {
				(void) get_nb_in_out_tp();
				if (nb_inp_tp != 1 || nb_out_tp <= 0) {
					sendrep (rpfd, MSG_ERR, CTP01, p);
					return (USERR);
				}
				splitmode = 1;
			} else if (strcmp (p, "INPUT") == 0) {
				inpflg = 1;
				outflg = 0;
				if ((blindmode + mergemode + splitmode) == 0)
					nb_inp_tp = 1;
				inp_tp_index = 0;
			} else if (strcmp (p, "OUTPUT") == 0) {
				inpflg = 0;
				outflg = 1;
				if ((blindmode + mergemode + splitmode) == 0)
					nb_out_tp = 1;
				out_tp_index = 0;
			} else {
				n = strtol (p, &dp, 10);
				if (*dp != '\0') {
					sendrep (rpfd, MSG_ERR, CTP01, p);
					return (USERR);
				}
				if (inpflg) {
					if (n != inp_tp_index + 1) {
						sendrep (rpfd, MSG_ERR, CTP03);
						return (USERR);
					}
					inp_tp_index++;
				} else if (outflg) {
					if (n != out_tp_index + 1) {
						sendrep (rpfd, MSG_ERR, CTP03);
						return (USERR);
					}
					out_tp_index++;
				} else {
					sendrep (rpfd, MSG_ERR, CTP01, p);
					return (USERR);
				}
				p += strlen (p) + 1;
				nargs = dir2argv (p, &argv_d);
				if (chkopt (nargs, argv_d))
					errflg++;
				free (argv_d);
			}
		} else {
			nargs = dir2argv (p, &argv_d);
			if (!inpflg && !outflg) {	/* common options */
				if (chkopt (nargs, argv_d))
					errflg++;
			} else if (inpflg) {	/* common input options */
				if (chkopt (nargs, argv_d))
					errflg++;
			} else {		/* common output options */
				if (chkopt (nargs, argv_d))
					errflg++;
			}
			free (argv_d);
		}
	}
	if (errflg)
		return (USERR);
	if (inp_tp_index != nb_inp_tp || out_tp_index != nb_out_tp) {
		sendrep (rpfd, MSG_ERR, CTP07);
		return (USERR);
	}
	return (0);
}

rmfromwq(wqp)
struct waitq *wqp;
{
	if (wqp->req_data)
		free (wqp->req_data);
	if (wqp->prev) (wqp->prev)->next = wqp->next;
	else waitqp = wqp->next;
	if (wqp->next) (wqp->next)->prev = wqp->prev;
	free (wqp);
}

#if defined(ultrix) || (defined(sun) && !defined(SOLARIS))
void wait4child()
{
	int pid;
	union wait status;

	while ((pid = wait3 (&status, WNOHANG, (struct rusage *) 0)) > 0)
		checkovlstatus (pid, status.w_status);
}
#else
void wait4child()
{
	int pid;
	int status;

#if defined(_IBMR2) || defined(SOLARIS) || defined(IRIX5) || (defined(__osf__) && defined(__alpha)) || defined(linux)
	while ((pid = waitpid (-1, &status, WNOHANG)) > 0)
		checkovlstatus (pid, status);
#else
	pid = wait (&status);
	checkovlstatus (pid, status);
#if _IBMESA
	signal (SIGCHLD, wait4child);
#else
	signal (SIGCLD, wait4child);
#endif
#endif
}
#endif
