/*
 * Copyright (C) 1990,1991 by CERN/CN/SW/DC
 * All rights reserved
 */

#ifndef lint
static char sccsid[] = "@(#)ferror.sc	1.1 02/08/91 CERN CN-SW/DC trn";
#endif /* not lint */

/* ferror.c     Fortran error handler                                   */

/* changed by   date               description                          */
/*+-----------+-----------+--------------------------------------------+*/
/* A. Trannoy   22 Jan 91       Initial writing for CRAY                */
/* F. Hemmer    24 Jan 91       Under SCCS control                      */

#if defined(CRAY)
#include <stdio.h>
#include <fortran.h>
#include <sys/errno.h>

extern char * sys_errlist[] ;
extern char * f_errlist[] ;
extern int errno ;


/*
 * To print FORTRAN I/O error on CRAY
 */
void FERROR(fstr,err)
	_fcd fstr ;
	int  *err ;
{
	char *  str ; 
	char * strp ; 
	int    strl ;

	/*
	 * Getting FORTRAN string.
	 */
	strp= _fcdtocp(fstr) ; 
	strl= _fcdlen(fstr) ; 

	if ( (str= ( char *) malloc(strl+1)) == NULL ) {
		fprintf(stderr,"ERROR WHILE ALLOCATING MEMORY : %s\n",sys_errlist[errno]); 
		return ; 
	}	
	(void) strncpy(str,strp,strl) ; 
	str[strl]= '\0' ;

	/*	
	 * Logging
	 */
	fprintf(stderr,"%s: %s\n",str,f_errlist[(*err)-100]) ; 

	/*
	 * Freeing memory.
	 */
	(void) free(str) ; 
}
#endif /* CRAY */
