/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.cpu;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUCCTContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.MethodIdMap;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNodeBacked;
import org.graalvm.visualvm.lib.jfluid.utils.IntVector;

public class CPUCCTClassContainer
extends CPUCCTContainer {
    protected int view;
    private CPUCCTContainer sourceContainer;
    private MethodIdMap methodIdMap;
    private long childTotalTime0;
    private long childTotalTime1;

    public CPUCCTClassContainer(CPUCCTContainer sourceContainer, MethodIdMap methodIdMap, int view) {
        super(sourceContainer.cpuResSnapshot);
        this.view = view;
        this.sourceContainer = sourceContainer;
        this.threadId = sourceContainer.threadId;
        this.threadName = sourceContainer.threadName;
        this.wholeGraphNetTime0 = sourceContainer.wholeGraphNetTime0;
        this.wholeGraphNetTime1 = sourceContainer.wholeGraphNetTime1;
        this.childOfsSize = 3;
        this.collectingTwoTimeStamps = sourceContainer.collectingTwoTimeStamps;
        this.nodeSize = sourceContainer.nodeSize;
        this.compactData = new byte[sourceContainer.compactData.length];
        this.methodIdMap = methodIdMap;
        IntVector rootMethodVec = new IntVector();
        rootMethodVec.add(0);
        int lastOfs = this.generateClassNodeFromMethodNodes(rootMethodVec, 0);
        byte[] oldData = this.compactData;
        this.compactData = new byte[lastOfs];
        System.arraycopy(oldData, 0, this.compactData, 0, lastOfs);
        this.rootNode = new PrestimeCPUCCTNodeBacked(this, null, 0);
        if (this.rootNode.getMethodId() == 0) {
            this.rootNode.setThreadNode();
        }
    }

    @Override
    public String[] getMethodClassNameAndSig(int methodId) {
        return this.cpuResSnapshot.getMethodClassNameAndSig(methodId, this.view);
    }

    protected int generateClassNodeFromMethodNodes(IntVector methodNodes, int dataOfs) {
        int nMethodNodes = methodNodes.size();
        int nCalls = 0;
        long time0 = 0L;
        long time1 = 0L;
        for (int i = 0; i < nMethodNodes; ++i) {
            int methodNodeOfs = methodNodes.get(i);
            nCalls += this.sourceContainer.getNCallsForNodeOfs(methodNodeOfs);
            time0 += this.sourceContainer.getSelfTime0ForNodeOfs(methodNodeOfs);
            if (!this.collectingTwoTimeStamps) continue;
            time1 += this.sourceContainer.getSelfTime1ForNodeOfs(methodNodeOfs);
        }
        int methodId = this.sourceContainer.getMethodIdForNodeOfs(methodNodes.get(0));
        if (methodId != 0) {
            methodId = this.methodIdMap.getClassOrPackageIdForMethodId(methodId);
        }
        this.setMethodIdForNodeOfs(dataOfs, methodId);
        this.setNCallsForNodeOfs(dataOfs, nCalls);
        this.setSelfTime0ForNodeOfs(dataOfs, time0);
        if (this.collectingTwoTimeStamps) {
            this.setSelfTime1ForNodeOfs(dataOfs, time1);
        }
        IntVector sourceChildren = new IntVector();
        HashSet uniqChildrenCache = new HashSet();
        for (int i = 0; i < nMethodNodes; ++i) {
            int methodNodeOfs = methodNodes.get(i);
            int nChildren = this.sourceContainer.getNChildrenForNodeOfs(methodNodeOfs);
            if (nChildren <= 0) continue;
            this.processChildren(dataOfs, methodNodeOfs, nChildren, sourceChildren, uniqChildrenCache);
        }
        int thisNodeNChildren = uniqChildrenCache.size();
        int nextNodeOfs = dataOfs + this.nodeSize + thisNodeNChildren * this.childOfsSize;
        if (thisNodeNChildren == 0) {
            this.childTotalTime0 = this.getSelfTime0ForNodeOfs(dataOfs);
            if (this.collectingTwoTimeStamps) {
                this.childTotalTime1 = this.getSelfTime1ForNodeOfs(dataOfs);
            }
            this.setTotalTime0ForNodeOfs(dataOfs, this.childTotalTime0);
            if (this.collectingTwoTimeStamps) {
                this.setTotalTime1ForNodeOfs(dataOfs, this.childTotalTime1);
            }
            return nextNodeOfs;
        }
        time0 = this.getSelfTime0ForNodeOfs(dataOfs);
        if (this.collectingTwoTimeStamps) {
            time1 = this.getSelfTime1ForNodeOfs(dataOfs);
        }
        this.setNChildrenForNodeOfs(dataOfs, thisNodeNChildren);
        IntVector sameTypeChildren = new IntVector();
        int nAllChildren = sourceChildren.size();
        int[] sourceChildrenClassIds = new int[nAllChildren];
        for (int i = 0; i < nAllChildren; ++i) {
            int mid = this.sourceContainer.getMethodIdForNodeOfs(sourceChildren.get(i));
            sourceChildrenClassIds[i] = this.methodIdMap.getClassOrPackageIdForMethodId(mid);
        }
        Iterator e = uniqChildrenCache.iterator();
        int i = 0;
        while (e.hasNext()) {
            sameTypeChildren.clear();
            int sourceChildClassOrPackageId = (Integer)e.next();
            for (int j = 0; j < nAllChildren; ++j) {
                if (sourceChildrenClassIds[j] != sourceChildClassOrPackageId) continue;
                sameTypeChildren.add(sourceChildren.get(j));
            }
            this.setChildOfsForNodeOfs(dataOfs, i, nextNodeOfs);
            nextNodeOfs = this.generateClassNodeFromMethodNodes(sameTypeChildren, nextNodeOfs);
            time0 += this.childTotalTime0;
            if (this.collectingTwoTimeStamps) {
                time1 += this.childTotalTime1;
            }
            ++i;
        }
        this.setTotalTime0ForNodeOfs(dataOfs, time0);
        if (this.collectingTwoTimeStamps) {
            this.setTotalTime1ForNodeOfs(dataOfs, time1);
        }
        this.childTotalTime0 = time0;
        if (this.collectingTwoTimeStamps) {
            this.childTotalTime1 = time1;
        }
        return nextNodeOfs;
    }

    protected void processChildren(int dataOfs, int methodNodeOfs, int nChildren, IntVector allSourceChildren, Set uniqChildCache) {
        int thisNodeClassOrPackageId = this.getMethodIdForNodeOfs(dataOfs);
        int nCalls = 0;
        long time0 = 0L;
        long time1 = 0L;
        for (int i = 0; i < nChildren; ++i) {
            int sourceChildOfs = this.sourceContainer.getChildOfsForNodeOfs(methodNodeOfs, i);
            int sourceChildClassOrPackageId = this.methodIdMap.getClassOrPackageIdForMethodId(this.sourceContainer.getMethodIdForNodeOfs(sourceChildOfs));
            if (sourceChildClassOrPackageId == thisNodeClassOrPackageId) {
                int nSourceChildChildren;
                nCalls += this.sourceContainer.getNCallsForNodeOfs(sourceChildOfs);
                time0 += this.sourceContainer.getSelfTime0ForNodeOfs(sourceChildOfs);
                if (this.collectingTwoTimeStamps) {
                    time1 += this.sourceContainer.getSelfTime1ForNodeOfs(sourceChildOfs);
                }
                if ((nSourceChildChildren = this.sourceContainer.getNChildrenForNodeOfs(sourceChildOfs)) <= 0) continue;
                this.processChildren(dataOfs, sourceChildOfs, nSourceChildChildren, allSourceChildren, uniqChildCache);
                continue;
            }
            Integer key = sourceChildClassOrPackageId;
            uniqChildCache.add(key);
            allSourceChildren.add(sourceChildOfs);
        }
        nCalls += this.getNCallsForNodeOfs(dataOfs);
        time0 += this.getSelfTime0ForNodeOfs(dataOfs);
        if (this.collectingTwoTimeStamps) {
            time1 += this.getSelfTime1ForNodeOfs(dataOfs);
        }
        this.setNCallsForNodeOfs(dataOfs, nCalls);
        this.setSelfTime0ForNodeOfs(dataOfs, time0);
        if (this.collectingTwoTimeStamps) {
            this.setSelfTime1ForNodeOfs(dataOfs, time1);
        }
    }
}

