/*
 * Decompiled with CFR 0.152.
 */
package tr.view.project.chooser;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import tr.model.project.Project;
import tr.model.topic.Topic;

public class ProjectTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final Icon iconOpened;
    private final Icon iconClosed;

    public ProjectTreeCellRenderer(Icon iconClosed, Icon iconOpened) {
        this.iconOpened = iconOpened;
        this.iconClosed = iconClosed;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setForeground(this.getProjectColor(value));
        this.setIcon(expanded ? this.iconOpened : this.iconClosed);
        return this;
    }

    protected Color getProjectColor(Object value) {
        Project project;
        Topic topic;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject() instanceof Project && (topic = (project = (Project)node.getUserObject()).getTopic()) != null) {
            return topic.getForeground();
        }
        return Color.black;
    }
}

