/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec.vp8;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.codec.vp8.Vp8Utils;
import org.jitsi.nlj.rtp.ParsedVideoPacket;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi_modified.impl.neomedia.codec.video.vp8.DePacketizer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001f\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 22\u00020\u0001:\u00012B[\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000e\u0010\u0010J\b\u0010\u0013\u001a\u00020\bH\u0016J\b\u00100\u001a\u00020-H\u0016J\b\u00101\u001a\u00020\u0000H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0011R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0018\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u0011\u0010%\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001fR\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001fR\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00063"}, d2={"Lorg/jitsi/nlj/rtp/codec/vp8/Vp8Packet;", "Lorg/jitsi/nlj/rtp/ParsedVideoPacket;", "buffer", "", "offset", "", "length", "isKeyframe", "", "isStartOfFrame", "encodingId", "height", "pictureId", "TL0PICIDX", "<init>", "([BIILjava/lang/Boolean;Ljava/lang/Boolean;ILjava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)V", "([BII)V", "()Z", "isEndOfFrame", "meetsRoutingNeeds", "hasTemporalLayerIndex", "getHasTemporalLayerIndex", "hasPictureId", "getHasPictureId", "hasExtendedPictureId", "getHasExtendedPictureId", "hasTL0PICIDX", "getHasTL0PICIDX", "_TL0PICIDX", "newValue", "getTL0PICIDX", "()I", "setTL0PICIDX", "(I)V", "_pictureId", "getPictureId", "setPictureId", "temporalLayerIndex", "getTemporalLayerIndex", "layerIds", "", "getLayerIds", "()Ljava/util/Collection;", "getHeight", "payloadVerification", "", "getPayloadVerification", "()Ljava/lang/String;", "toString", "clone", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nVp8Packet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vp8Packet.kt\norg/jitsi/nlj/rtp/codec/vp8/Vp8Packet\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n69#2,4:177\n69#2,4:181\n1#3:185\n*S KotlinDebug\n*F\n+ 1 Vp8Packet.kt\norg/jitsi/nlj/rtp/codec/vp8/Vp8Packet\n*L\n101#1:177,4\n117#1:181,4\n*E\n"})
public final class Vp8Packet
extends ParsedVideoPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isKeyframe;
    private final boolean isStartOfFrame;
    private final boolean hasTemporalLayerIndex;
    private final boolean hasPictureId;
    private final boolean hasExtendedPictureId;
    private final boolean hasTL0PICIDX;
    private int _TL0PICIDX;
    private int _pictureId;
    private final int temporalLayerIndex;
    private final int height;
    @NotNull
    private static final Logger logger = LoggerExtensionsKt.createLogger$default(Companion, null, null, 3, null);

    private Vp8Packet(byte[] buffer, int offset, int length, Boolean isKeyframe, Boolean isStartOfFrame, int encodingId, Integer height, Integer pictureId, Integer TL0PICIDX) {
        super(buffer, offset, length, encodingId);
        Boolean bl = isKeyframe;
        this.isKeyframe = bl != null ? bl : DePacketizer.isKeyFrame(this.buffer, this.getPayloadOffset(), this.getPayloadLength());
        Boolean bl2 = isStartOfFrame;
        this.isStartOfFrame = bl2 != null ? bl2 : DePacketizer.VP8PayloadDescriptor.isStartOfFrame(buffer, this.getPayloadOffset());
        this.hasTemporalLayerIndex = DePacketizer.VP8PayloadDescriptor.hasTemporalLayerIndex(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.hasPictureId = DePacketizer.VP8PayloadDescriptor.hasPictureId(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.hasExtendedPictureId = DePacketizer.VP8PayloadDescriptor.hasExtendedPictureId(buffer, this.getPayloadOffset(), this.getPayloadLength());
        this.hasTL0PICIDX = DePacketizer.VP8PayloadDescriptor.hasTL0PICIDX(buffer, this.getPayloadOffset(), this.getPayloadLength());
        Integer n = TL0PICIDX;
        this._TL0PICIDX = n != null ? n : DePacketizer.VP8PayloadDescriptor.getTL0PICIDX(buffer, this.getPayloadOffset(), this.getPayloadLength());
        Integer n2 = pictureId;
        this._pictureId = n2 != null ? n2 : DePacketizer.VP8PayloadDescriptor.getPictureId(buffer, this.getPayloadOffset());
        this.temporalLayerIndex = Vp8Utils.Companion.getTemporalLayerIdOfFrame(this);
        Integer n3 = height;
        this.height = n3 != null ? n3 : (this.isKeyframe() ? Vp8Utils.Companion.getHeightFromKeyFrame(this) : -1);
    }

    public Vp8Packet(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this(buffer, offset, length, null, null, -1, null, null, null);
    }

    @Override
    public boolean isKeyframe() {
        return this.isKeyframe;
    }

    @Override
    public boolean isStartOfFrame() {
        return this.isStartOfFrame;
    }

    @Override
    public boolean isEndOfFrame() {
        return this.isMarked();
    }

    @Override
    public boolean meetsRoutingNeeds() {
        return this.hasPictureId && this.hasTemporalLayerIndex;
    }

    public final boolean getHasTemporalLayerIndex() {
        return this.hasTemporalLayerIndex;
    }

    public final boolean getHasPictureId() {
        return this.hasPictureId;
    }

    public final boolean getHasExtendedPictureId() {
        return this.hasExtendedPictureId;
    }

    public final boolean getHasTL0PICIDX() {
        return this.hasTL0PICIDX;
    }

    public final int getTL0PICIDX() {
        return this._TL0PICIDX;
    }

    public final void setTL0PICIDX(int newValue) {
        this._TL0PICIDX = newValue;
        if (newValue != -1 && !DePacketizer.VP8PayloadDescriptor.setTL0PICIDX(this.buffer, this.getPayloadOffset(), this.getPayloadLength(), newValue)) {
            Logger $this$cwarn$iv = logger;
            boolean $i$f$cwarn = false;
            if ($this$cwarn$iv.isWarnEnabled()) {
                Logger logger = $this$cwarn$iv;
                boolean bl = false;
                logger.warn("Failed to set the TL0PICIDX of a VP8 packet.");
            }
        }
    }

    public final int getPictureId() {
        return this._pictureId;
    }

    public final void setPictureId(int newValue) {
        this._pictureId = newValue;
        if (!DePacketizer.VP8PayloadDescriptor.setExtendedPictureId(this.buffer, this.getPayloadOffset(), this.getPayloadLength(), newValue)) {
            Logger $this$cwarn$iv = logger;
            boolean $i$f$cwarn = false;
            if ($this$cwarn$iv.isWarnEnabled()) {
                Logger logger = $this$cwarn$iv;
                boolean bl = false;
                logger.warn("Failed to set the picture id of a VP8 packet.");
            }
        }
    }

    public final int getTemporalLayerIndex() {
        return this.temporalLayerIndex;
    }

    @Override
    @NotNull
    public Collection<Integer> getLayerIds() {
        return this.hasTemporalLayerIndex ? (Collection)CollectionsKt.listOf(RtpLayerDesc.Companion.getIndex(0, 0, this.temporalLayerIndex)) : super.getLayerIds();
    }

    public final int getHeight() {
        return this.height;
    }

    @Override
    @NotNull
    public String getPayloadVerification() {
        int rtpPayloadLength = this.getPayloadLength();
        int rtpPayloadOffset = this.getPayloadOffset();
        int vp8pdSize = DePacketizer.VP8PayloadDescriptor.getSize(this.buffer, rtpPayloadOffset, rtpPayloadLength);
        int vp8PayloadLength = rtpPayloadLength - vp8pdSize;
        Intrinsics.checkNotNullExpressionValue(this.buffer, "buffer");
        int hashCode = ByteArrayExtensionsKt.hashCodeOfSegment(this.buffer, this.getPayloadOffset() + vp8pdSize, rtpPayloadOffset + rtpPayloadLength);
        return "type=Vp8Packet len=" + vp8PayloadLength + " hashCode=" + hashCode;
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + ", TID=" + this.temporalLayerIndex;
    }

    @Override
    @NotNull
    public Vp8Packet clone() {
        Vp8Packet vp8Packet;
        Vp8Packet it = vp8Packet = new Vp8Packet(this.cloneBuffer(10), 10, this.length, this.isKeyframe(), this.isStartOfFrame(), this.getEncodingId(), this.height, this.getPictureId(), this.getTL0PICIDX());
        boolean bl = false;
        this.postClone(it);
        return vp8Packet;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/nlj/rtp/codec/vp8/Vp8Packet$Companion;", "", "<init>", "()V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

