/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.PageCreator;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.FileTreeNodeFactoryProvider;
import org.jd.gui.view.component.ManifestFilePage;
import org.jd.gui.view.data.TreeNodeBean;

public class ManifestFileTreeNodeFactoryProvider
extends FileTreeNodeFactoryProvider {
    protected static final ImageIcon ICON = new ImageIcon(ManifestFileTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/manifest_obj.png"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:META-INF/MANIFEST.MF");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        String location = new File(entry.getUri()).getPath();
        return (T)new TreeNode(entry, new TreeNodeBean("MANIFEST.MF", "Location: " + location, (Icon)ICON));
    }

    protected static class TreeNode
    extends FileTreeNodeFactoryProvider.TreeNode
    implements PageCreator {
        public TreeNode(Container.Entry entry, Object userObject) {
            super(entry, userObject);
        }

        @Override
        public <T extends JComponent> T createPage(API api) {
            return (T)new ManifestFilePage(api, this.entry);
        }
    }
}

