/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.util.SimpleTimer;

public class OutboundCache {
    final Map<HashPair, TunnelInfo> tunnelCache = new HashMap<HashPair, TunnelInfo>(64);
    final Map<HashPair, TunnelInfo> backloggedTunnelCache = new HashMap<HashPair, TunnelInfo>(64);
    final ConcurrentHashMap<HashPair, LeaseSet> leaseSetCache = new ConcurrentHashMap(64);
    final ConcurrentHashMap<HashPair, Lease> leaseCache = new ConcurrentHashMap(64);
    final Map<HashPair, Long> lastReplyRequestCache = new ConcurrentHashMap<HashPair, Long>(64);
    public final ConcurrentHashMap<Hash, LeaseSet> multihomedCache = new ConcurrentHashMap(64);
    private final RouterContext _context;
    private static final int CLEAN_INTERVAL = 300000;

    public OutboundCache(RouterContext ctx) {
        this._context = ctx;
        this._context.simpleTimer2().addPeriodicEvent(new OCMOSJCacheCleaner(), 300000L, 300000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCaches(HashPair hashPair, Lease lease, TunnelInfo inTunnel, TunnelInfo outTunnel) {
        if (inTunnel != null) {
            this.leaseSetCache.remove(hashPair);
        }
        if (lease != null) {
            this.leaseCache.remove(hashPair, lease);
        }
        if (outTunnel != null) {
            Map<HashPair, TunnelInfo> map = this.tunnelCache;
            synchronized (map) {
                TunnelInfo t = this.backloggedTunnelCache.get(hashPair);
                if (t != null && t.equals(outTunnel)) {
                    this.backloggedTunnelCache.remove(hashPair);
                }
                if ((t = this.tunnelCache.get(hashPair)) != null && t.equals(outTunnel)) {
                    this.tunnelCache.remove(hashPair);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCaches() {
        this.leaseSetCache.clear();
        this.leaseCache.clear();
        Map<HashPair, TunnelInfo> map = this.tunnelCache;
        synchronized (map) {
            this.backloggedTunnelCache.clear();
            this.tunnelCache.clear();
        }
        this.lastReplyRequestCache.clear();
    }

    private static void cleanLeaseSetCache(RouterContext ctx, Map<HashPair, LeaseSet> tc) {
        long now = ctx.clock().now();
        Iterator<LeaseSet> iter = tc.values().iterator();
        while (iter.hasNext()) {
            LeaseSet l = iter.next();
            if (l.getEarliestLeaseDate() >= now) continue;
            iter.remove();
        }
    }

    private static void cleanLeaseCache(Map<HashPair, Lease> tc) {
        Iterator<Lease> iter = tc.values().iterator();
        while (iter.hasNext()) {
            Lease l = iter.next();
            if (!l.isExpired(60000L)) continue;
            iter.remove();
        }
    }

    private static void cleanTunnelCache(RouterContext ctx, Map<HashPair, TunnelInfo> tc) {
        Iterator<Map.Entry<HashPair, TunnelInfo>> iter = tc.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<HashPair, TunnelInfo> entry = iter.next();
            HashPair k = entry.getKey();
            TunnelInfo tunnel = entry.getValue();
            if (ctx.tunnelManager().isValidTunnel(k.sh, tunnel)) continue;
            iter.remove();
        }
    }

    private static void cleanReplyCache(RouterContext ctx, Map<HashPair, Long> tc) {
        long now = ctx.clock().now();
        Iterator<Long> iter = tc.values().iterator();
        while (iter.hasNext()) {
            Long l = iter.next();
            if (l >= now - 300000L) continue;
            iter.remove();
        }
    }

    private class OCMOSJCacheCleaner
    implements SimpleTimer.TimedEvent {
        private OCMOSJCacheCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            OutboundCache.cleanLeaseSetCache(OutboundCache.this._context, OutboundCache.this.leaseSetCache);
            OutboundCache.cleanLeaseCache(OutboundCache.this.leaseCache);
            Map<HashPair, TunnelInfo> map = OutboundCache.this.tunnelCache;
            synchronized (map) {
                OutboundCache.cleanTunnelCache(OutboundCache.this._context, OutboundCache.this.tunnelCache);
                OutboundCache.cleanTunnelCache(OutboundCache.this._context, OutboundCache.this.backloggedTunnelCache);
            }
            OutboundCache.cleanReplyCache(OutboundCache.this._context, OutboundCache.this.lastReplyRequestCache);
        }
    }

    static class HashPair {
        private final Hash sh;
        private final Hash dh;

        public HashPair(Hash s, Hash d) {
            this.sh = s;
            this.dh = d;
        }

        public int hashCode() {
            return this.sh.hashCode() ^ this.dh.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof HashPair)) {
                return false;
            }
            HashPair hp = (HashPair)o;
            return this.sh.equals(hp.sh) && this.dh.equals(hp.dh);
        }
    }
}

