"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
class NotificationsService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend GET channels API from the Notifications plugin
     * to retrieve the channel config with the specific ID.
     */
    _defineProperty(this, "getChannel", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const client = this.getClient(request, context);
        const getResponse = await client(_constants.CLIENT_NOTIFICATIONS_METHODS.GET_CHANNEL, {
          id
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getResponse
          }
        });
      } catch (err) {
        console.error('Security Analytics - NotificationsService - getChannel:', err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    /**
     * Calls backend GET channels API from the Notifications plugin.
     */
    _defineProperty(this, "getChannels", async (context, request, response) => {
      try {
        const client = this.getClient(request, context);
        const getChannelsResponse = await client(_constants.CLIENT_NOTIFICATIONS_METHODS.GET_CHANNELS);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getChannelsResponse
          }
        });
      } catch (err) {
        console.error('Security Analytics - NotificationsService - getChannels:', err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "getNotificationsFeatures", async (context, request, response) => {
      try {
        const client = this.getClient(request, context);
        const getFeaturesResponse = await client(_constants.CLIENT_NOTIFICATIONS_METHODS.GET_FEATURES);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getFeaturesResponse.allowed_config_type_list
          }
        });
      } catch (err) {
        console.error('Security Analytics - NotificationsService - getFeatures:', err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = NotificationsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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