"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMetricsRoute = registerMetricsRoute;
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerMetricsRoute(router) {
  router.get({
    path: _common.ServiceEndpoints.GetStats,
    validate: false,
    options: {
      authRequired: false
    }
  }, async (context, _, response) => {
    try {
      const metrics = context.searchRelevance.metricsService.getStats();
      return response.ok({
        body: JSON.stringify(metrics, null, 2)
      });
    } catch (error) {
      console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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