/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.impl;

import org.graalvm.visualvm.lib.profiler.impl.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.spi.ProfilerDialogsProvider;
import org.graalvm.visualvm.lib.profiler.ui.NBHTMLLabel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public final class ProfilerDialogsProviderImpl
extends ProfilerDialogsProvider {
    public void displayInfo(String message, String caption, String details) {
        this.displayMessage(message, caption, details, 1);
    }

    public void displayInfoDNSA(String message, String caption, String dnsaMessage, String key, boolean dnsaDefault) {
        this.displayDNSAMessage(message, caption, dnsaMessage, key, dnsaDefault, 1);
    }

    public void displayWarning(String message, String caption, String details) {
        this.displayMessage(message, caption, details, 2);
    }

    public void displayWarningDNSA(String message, String caption, String dnsaMessage, String key, boolean dnsaDefault) {
        this.displayDNSAMessage(message, caption, dnsaMessage, key, dnsaDefault, 2);
    }

    public void displayError(String message, String caption, String details) {
        this.displayMessage(message, caption, details, 0);
    }

    public Boolean displayConfirmation(String message, String caption, boolean cancellable) {
        Object ret;
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, cancellable ? 1 : 0);
        if (caption != null) {
            nd.setTitle(caption);
        }
        if ((ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd)) == NotifyDescriptor.YES_OPTION) {
            return Boolean.TRUE;
        }
        if (ret == NotifyDescriptor.NO_OPTION) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Boolean displayConfirmationDNSA(String message, String caption, String dnsaMessage, boolean cancellable, String key, boolean dnsaDefault) {
        ProfilerDialogs.DNSAConfirmation dnsa = new ProfilerDialogs.DNSAConfirmation(key, (Object)message, cancellable ? 1 : 0);
        if (caption != null) {
            dnsa.setTitle(caption);
        }
        if (dnsaMessage != null) {
            dnsa.setDNSAMessage(dnsaMessage);
        }
        dnsa.setDNSADefault(dnsaDefault);
        Object ret = ProfilerDialogs.notify((NotifyDescriptor)dnsa);
        if (ret == NotifyDescriptor.YES_OPTION) {
            return Boolean.TRUE;
        }
        if (ret == NotifyDescriptor.NO_OPTION) {
            return Boolean.FALSE;
        }
        return null;
    }

    private void displayMessage(String message, String caption, String details, int type) {
        Object nd;
        Object msg = message;
        Object det = details;
        if (ProfilerDialogsProviderImpl.isHtmlString(message)) {
            msg = new NBHTMLLabel(message);
        }
        if (ProfilerDialogsProviderImpl.isHtmlString(details)) {
            det = new NBHTMLLabel(message);
        }
        Object object = nd = det == null ? new NotifyDescriptor.Message(msg, type) : new ProfilerDialogs.MessageWithDetails(msg, det, type, false);
        if (caption != null) {
            nd.setTitle(caption);
        }
        ProfilerDialogs.notify((NotifyDescriptor)nd);
    }

    private void displayDNSAMessage(String message, String caption, String dnsaMessage, String key, boolean dnsaDefault, int type) {
        ProfilerDialogs.DNSAMessage dnsa = new ProfilerDialogs.DNSAMessage(key, message, type);
        if (caption != null) {
            dnsa.setTitle(caption);
        }
        if (dnsaMessage != null) {
            dnsa.setDNSAMessage(dnsaMessage);
        }
        dnsa.setDNSADefault(dnsaDefault);
        ProfilerDialogs.notify((NotifyDescriptor)dnsa);
    }

    private static boolean isHtmlString(String string) {
        if (string == null) {
            return false;
        }
        return string.contains("<") && string.contains(">");
    }
}

