/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.ValidationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

class IfNode {
    final Statement value;
    IfNode innerNode;
    EdgeType innerType;
    IfNode successorNode;
    EdgeType successorType;

    private IfNode(Statement value) {
        ValidationHelper.notNull(value);
        this.value = value;
    }

    private void setInner(IfNode ifNode, EdgeType indirect) {
        ValidationHelper.notNull(ifNode);
        ValidationHelper.notNull((Object)indirect);
        this.innerNode = ifNode;
        this.innerType = indirect;
    }

    private void setSuccessor(IfNode ifNode, EdgeType indirect) {
        ValidationHelper.notNull(ifNode);
        ValidationHelper.notNull((Object)indirect);
        this.successorNode = ifNode;
        this.successorType = indirect;
    }

    static IfNode build(IfStatement stat, boolean stsingle) {
        IfNode res = new IfNode(stat);
        if (stat.getIfstat() == null) {
            res.setInner(new IfNode(stat.getIfEdge().getDestination()), EdgeType.INDIRECT);
        } else {
            res.setInner(IfNode.buildSubIfNode(stat.getIfstat()), EdgeType.DIRECT);
        }
        if (stat.iftype == 1) {
            res.setSuccessor(IfNode.buildSubIfNode(stat.getElsestat()), EdgeType.ELSE);
        } else {
            StatEdge edge = stat.getFirstSuccessor();
            if (stsingle || edge.getType() != 1) {
                res.setSuccessor(new IfNode(edge.getDestination()), EdgeType.INDIRECT);
            } else {
                res.setSuccessor(IfNode.buildSubIfNode(edge.getDestination()), EdgeType.DIRECT);
            }
        }
        return res;
    }

    private static IfNode buildSubIfNode(Statement statement) {
        IfNode ifnode = new IfNode(statement);
        if (statement instanceof IfStatement && ((IfStatement)statement).iftype == 0) {
            IfStatement ifStatement = (IfStatement)statement;
            ifnode.setInner(new IfNode(ifStatement.getIfEdge().getDestination()), ifStatement.getIfstat() == null ? EdgeType.INDIRECT : EdgeType.DIRECT);
        }
        if (statement.hasAnySuccessor()) {
            ifnode.setSuccessor(new IfNode(statement.getFirstSuccessor().getDestination()), EdgeType.INDIRECT);
        }
        return ifnode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.value.id);
        if (this.innerNode != null) {
            sb.append(": inner(").append((Object)this.innerType).append(") {").append(this.innerNode).append("}");
        }
        if (this.successorNode != null) {
            if (this.innerNode == null) {
                sb.append(": ");
            }
            sb.append(" successor(").append((Object)this.successorType).append(") {").append(this.successorNode).append("}");
        }
        return sb.toString();
    }

    static enum EdgeType {
        DIRECT,
        INDIRECT,
        ELSE;

    }
}

