/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.ikvm;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MapFileGenerator {
    private List<String> m_responseList;
    private static final Map<Class<?>, String> TYPE_MAP = new HashMap();
    private static final String[] IGNORED_METHODS;

    public static void main(String[] stringArray) throws ClassNotFoundException, XMLStreamException, IOException, IntrospectionException {
        if (stringArray.length != 3) {
            System.out.println("Usage: MapFileGenerator <file.jar> <remapfile.xml> <map class methods flag>");
        } else {
            MapFileGenerator mapFileGenerator = new MapFileGenerator();
            mapFileGenerator.generateMapFile(new File(stringArray[0]), stringArray[1], Boolean.parseBoolean(stringArray[2]));
        }
    }

    public void generateMapFile(File file, String string, boolean bl) throws XMLStreamException, IOException, ClassNotFoundException, IntrospectionException {
        this.m_responseList = new LinkedList<String>();
        this.writeMapFile(string, file, bl);
    }

    private void writeMapFile(String string, File file, boolean bl) throws IOException, XMLStreamException, ClassNotFoundException, IntrospectionException {
        FileWriter fileWriter = new FileWriter(string);
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(fileWriter);
        xMLStreamWriter.writeStartDocument();
        xMLStreamWriter.writeStartElement("root");
        xMLStreamWriter.writeStartElement("assembly");
        this.addClasses(xMLStreamWriter, file, bl);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndDocument();
        xMLStreamWriter.flush();
        xMLStreamWriter.close();
        fileWriter.flush();
        fileWriter.close();
    }

    private void addClasses(XMLStreamWriter xMLStreamWriter, File file, boolean bl) throws IOException, ClassNotFoundException, XMLStreamException, IntrospectionException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()}, classLoader);
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
            this.addClass(uRLClassLoader, jarEntry, xMLStreamWriter, bl);
        }
        jarFile.close();
    }

    private void addClass(URLClassLoader uRLClassLoader, JarEntry jarEntry, XMLStreamWriter xMLStreamWriter, boolean bl) throws ClassNotFoundException, XMLStreamException, IntrospectionException {
        String string = jarEntry.getName().replaceAll("\\.class", "").replaceAll("/", ".");
        xMLStreamWriter.writeStartElement("class");
        xMLStreamWriter.writeAttribute("name", string);
        HashSet<Method> hashSet = new HashSet<Method>();
        Class<?> clazz = uRLClassLoader.loadClass(string);
        this.processProperties(xMLStreamWriter, hashSet, clazz);
        if (bl && !Modifier.isInterface(clazz.getModifiers())) {
            this.processClassMethods(xMLStreamWriter, clazz, hashSet);
        }
        xMLStreamWriter.writeEndElement();
    }

    private void processProperties(XMLStreamWriter xMLStreamWriter, Set<Method> set, Class<?> clazz) throws IntrospectionException, XMLStreamException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz, clazz.getSuperclass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (propertyDescriptor.getPropertyType() != null) {
                String string = propertyDescriptor.getName();
                Method method = propertyDescriptor.getReadMethod();
                Method method2 = propertyDescriptor.getWriteMethod();
                String string2 = method == null ? null : method.getName();
                String string3 = method2 == null ? null : method2.getName();
                this.addProperty(xMLStreamWriter, string, propertyDescriptor.getPropertyType(), string2, string3);
                if (method != null) {
                    set.add(method);
                }
                if (method2 == null) continue;
                set.add(method2);
                continue;
            }
            this.processAmbiguousProperty(xMLStreamWriter, set, clazz, propertyDescriptor);
        }
    }

    private void addProperty(XMLStreamWriter xMLStreamWriter, String string, Class<?> clazz, String string2, String string3) throws XMLStreamException {
        if (string.length() != 0) {
            xMLStreamWriter.writeStartElement("property");
            String string4 = string.substring(0, 1).toUpperCase() + string.substring(1);
            xMLStreamWriter.writeAttribute("name", string4);
            String string5 = this.getTypeString(clazz);
            xMLStreamWriter.writeAttribute("sig", "()" + string5);
            if (string2 != null) {
                xMLStreamWriter.writeStartElement("getter");
                xMLStreamWriter.writeAttribute("name", string2);
                xMLStreamWriter.writeAttribute("sig", "()" + string5);
                xMLStreamWriter.writeEndElement();
            }
            if (string3 != null) {
                xMLStreamWriter.writeStartElement("setter");
                xMLStreamWriter.writeAttribute("name", string3);
                xMLStreamWriter.writeAttribute("sig", "(" + string5 + ")V");
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndElement();
        }
    }

    private String getTypeString(Class<?> clazz) {
        Object object = TYPE_MAP.get(clazz);
        if (object == null && !((String)(object = clazz.getName())).endsWith(";") && !((String)object).startsWith("[")) {
            object = "L" + (String)object + ";";
        }
        return object;
    }

    private void processAmbiguousProperty(XMLStreamWriter xMLStreamWriter, Set<Method> set, Class<?> clazz, PropertyDescriptor propertyDescriptor) throws SecurityException, XMLStreamException {
        Object object = propertyDescriptor.getName();
        object = ((String)object).toUpperCase().charAt(0) + ((String)object).substring(1);
        Method method = null;
        try {
            method = clazz.getMethod("get" + (String)object, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null) {
            Method method2 = null;
            try {
                method2 = clazz.getMethod("set" + (String)object, method.getReturnType());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            String string = method.getName();
            String string2 = method2 == null ? null : method2.getName();
            this.addProperty(xMLStreamWriter, (String)object, method.getReturnType(), string, string2);
            set.add(method);
            if (method2 != null) {
                set.add(method2);
            }
        }
    }

    private void processClassMethods(XMLStreamWriter xMLStreamWriter, Class<?> clazz, Set<Method> set) throws XMLStreamException {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            if (set.contains(method) || !Modifier.isPublic(method.getModifiers()) || Modifier.isInterface(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            Object object = method.getName();
            String string = this.createMethodSignature(method);
            String string2 = clazz.getCanonicalName() + "." + (String)object + string;
            if (this.ignoreMethod(string2)) continue;
            xMLStreamWriter.writeStartElement("method");
            xMLStreamWriter.writeAttribute("name", (String)object);
            xMLStreamWriter.writeAttribute("sig", string);
            xMLStreamWriter.writeStartElement("attribute");
            xMLStreamWriter.writeAttribute("type", "System.ComponentModel.EditorBrowsableAttribute");
            xMLStreamWriter.writeAttribute("sig", "(Lcli.System.ComponentModel.EditorBrowsableState;)V");
            xMLStreamWriter.writeStartElement("parameter");
            xMLStreamWriter.writeCharacters("Never");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            object = ((String)object).toUpperCase().charAt(0) + ((String)object).substring(1);
            xMLStreamWriter.writeStartElement("method");
            xMLStreamWriter.writeAttribute("name", (String)object);
            xMLStreamWriter.writeAttribute("sig", string);
            xMLStreamWriter.writeAttribute("modifiers", "public");
            xMLStreamWriter.writeStartElement("body");
            for (int i = 0; i <= method.getParameterTypes().length; ++i) {
                if (i < 4) {
                    xMLStreamWriter.writeEmptyElement("ldarg_" + i);
                    continue;
                }
                xMLStreamWriter.writeStartElement("ldarg_s");
                xMLStreamWriter.writeAttribute("argNum", Integer.toString(i));
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeStartElement("callvirt");
            xMLStreamWriter.writeAttribute("class", clazz.getName());
            xMLStreamWriter.writeAttribute("name", method.getName());
            xMLStreamWriter.writeAttribute("sig", string);
            xMLStreamWriter.writeEndElement();
            if (!method.getReturnType().getName().equals("void")) {
                xMLStreamWriter.writeEmptyElement("ldnull");
                xMLStreamWriter.writeEmptyElement("pop");
            }
            xMLStreamWriter.writeEmptyElement("ret");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
            this.m_responseList.add(string2);
        }
    }

    private boolean ignoreMethod(String string) {
        boolean bl = false;
        for (String string2 : IGNORED_METHODS) {
            if (!string.matches(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String createMethodSignature(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (Class<?> clazz : method.getParameterTypes()) {
            stringBuilder.append(this.getTypeString(clazz));
        }
        stringBuilder.append(")");
        Class<?> clazz = method.getReturnType();
        if (clazz.getName().equals("void")) {
            stringBuilder.append("V");
        } else {
            stringBuilder.append(this.getTypeString(clazz));
        }
        return stringBuilder.toString();
    }

    static {
        TYPE_MAP.put(Boolean.TYPE, "Z");
        TYPE_MAP.put(Byte.TYPE, "B");
        TYPE_MAP.put(Short.TYPE, "S");
        TYPE_MAP.put(Character.TYPE, "C");
        TYPE_MAP.put(Integer.TYPE, "I");
        TYPE_MAP.put(Long.TYPE, "J");
        TYPE_MAP.put(Float.TYPE, "F");
        TYPE_MAP.put(Double.TYPE, "D");
        IGNORED_METHODS = new String[]{".*\\.toString\\(\\)Ljava.lang.String;"};
    }
}

