/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ChildTaskContainer;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectConfig;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.asta.RowComparator;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;

final class AstaReader {
    private ProjectFile m_project = new ProjectFile();
    private EventManager m_eventManager = this.m_project.getEventManager();
    private static final Double COMPLETE = 100.0;
    private static final Double INCOMPLETE = 0.0;
    private static final Duration ZERO_HOURS = Duration.getInstance(0, TimeUnit.HOURS);
    private static final String LINE_BREAK = "|@|||";
    private static final RowComparator LEAF_COMPARATOR = new RowComparator("NATURAL_ORDER", "NATURAO_ORDER");
    private static final RowComparator BAR_COMPARATOR = new RowComparator("EXPANDED_TASK", "NATURAL_ORDER");
    private static final RelationType[] RELATION_TYPES = new RelationType[]{RelationType.FINISH_START, RelationType.START_START, RelationType.FINISH_FINISH, RelationType.START_FINISH};

    public AstaReader() {
        ProjectConfig projectConfig = this.m_project.getProjectConfig();
        projectConfig.setAutoTaskUniqueID(false);
        projectConfig.setAutoResourceUniqueID(false);
        projectConfig.setAutoCalendarUniqueID(false);
        this.m_project.getProjectProperties().setFileApplication("Asta");
        this.m_project.getProjectProperties().setFileType("PP");
    }

    public ProjectFile getProject() {
        return this.m_project;
    }

    public void processProjectProperties(Row row) {
        ProjectProperties projectProperties = this.m_project.getProjectProperties();
        projectProperties.setDuration(row.getDuration("DURATIONHOURS"));
        projectProperties.setStartDate(row.getDate("STARU"));
        projectProperties.setFinishDate(row.getDate("ENE"));
        projectProperties.setName(row.getString("SHORT_NAME"));
        projectProperties.setAuthor(row.getString("PROJECT_BY"));
        projectProperties.setLastSaved(row.getDate("LAST_EDITED_DATE"));
    }

    public void processResources(List<Row> list, List<Row> list2) {
        Resource resource;
        for (Row row : list) {
            resource = this.m_project.addResource();
            resource.setType(ResourceType.WORK);
            resource.setUniqueID(row.getInteger("PERMANENT_RESOURCEID"));
            resource.setEmailAddress(row.getString("EMAIL_ADDRESS"));
            resource.setName(row.getString("NASE"));
            resource.setResourceCalendar(this.deriveResourceCalendar(row.getInteger("CALENDAV")));
            resource.setMaxUnits(row.getDouble("AVAILABILITY") * 100.0);
            resource.setIsGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setInitials(this.getInitials(resource.getName()));
        }
        for (Row row : list2) {
            resource = this.m_project.addResource();
            resource.setType(ResourceType.MATERIAL);
            resource.setUniqueID(row.getInteger("CONSUMABLE_RESOURCEID"));
            resource.setCostPerUse(row.getDouble("COST_PER_USEDEFAULTSAMOUNT"));
            resource.setPeakUnits(row.getDouble("AVAILABILITY") * 100.0);
            resource.setName(row.getString("NASE"));
            resource.setResourceCalendar(this.deriveResourceCalendar(row.getInteger("CALENDAV")));
            resource.setAvailableFrom(row.getDate("AVAILABLE_FROM"));
            resource.setAvailableTo(row.getDate("AVAILABLE_TO"));
            resource.setIsGeneric(row.getBoolean("CREATED_AS_FOLDER"));
            resource.setMaterialLabel(row.getString("MEASUREMENT"));
            resource.setInitials(this.getInitials(resource.getName()));
        }
    }

    private ProjectCalendar deriveResourceCalendar(Integer n) {
        ProjectCalendar projectCalendar = this.m_project.addDefaultDerivedCalendar();
        projectCalendar.setUniqueID(this.m_project.getProjectConfig().getNextCalendarUniqueID());
        projectCalendar.setParent(this.m_project.getCalendarByUniqueID(n));
        return projectCalendar;
    }

    public void processTasks(List<Row> list, List<Row> list2, List<Row> list3, List<Row> list4) {
        List<Row> list5 = this.buildRowHierarchy(list, list2, list3, list4);
        this.createTasks(this.m_project, "", list5);
        this.deriveProjectCalendar();
        this.updateStructure();
    }

    /*
     * WARNING - void declaration
     */
    private List<Row> buildRowHierarchy(List<Row> list, List<Row> list2, List<Row> list3, List<Row> list4) {
        void var8_12;
        Row row;
        Object object;
        Row row22;
        ArrayList<Row> arrayList = new ArrayList<Row>();
        arrayList.addAll(list3);
        arrayList.addAll(list4);
        Collections.sort(list, BAR_COMPARATOR);
        Collections.sort(arrayList, LEAF_COMPARATOR);
        HashMap<Integer, Row> hashMap = new HashMap<Integer, Row>();
        for (Row list52 : list) {
            hashMap.put(list52.getInteger("BARID"), list52);
        }
        HashMap hashMap2 = new HashMap();
        for (Row row3 : list2) {
            row22 = (Row)hashMap.get(row3.getInteger("BAR"));
            row22.merge(row3, "_");
            object = row22.getInteger("_EXPANDED_TASKID");
            hashMap2.put(object, row22);
        }
        ArrayList<Row> arrayList2 = new ArrayList<Row>();
        for (Row row22 : list) {
            object = row22.getInteger("EXPANDED_TASK");
            row = (Row)hashMap2.get(object);
            if (row == null) {
                arrayList2.add(row22);
                continue;
            }
            row.addChild(row22);
        }
        for (Row row22 : arrayList) {
            object = row22.getInteger("BAR");
            row = (Row)hashMap.get(object);
            row.addChild(row22);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            row22 = (Row)iterator.next();
            object = row22.getString("NAMH");
            if (object != null && !((String)object).isEmpty() && !((String)object).equals("Displaced Items")) continue;
            iterator.remove();
        }
        if (arrayList2.size() == 1) {
            List<Row> list5 = ((Row)arrayList2.get(0)).getChildRows();
        }
        return var8_12;
    }

    private void createTasks(ChildTaskContainer childTaskContainer, String string, List<Row> list) {
        for (Row row : list) {
            Task task = childTaskContainer.addTask();
            if (row.getInteger("BARID") != null) {
                if (this.skipBar(row)) {
                    this.populateLeaf(row.getString("NAMH"), row.getChildRows().get(0), task);
                } else {
                    this.populateBar(row, task);
                    this.createTasks(task, task.getName(), row.getChildRows());
                }
            } else {
                this.populateLeaf(string, row, task);
            }
            this.m_eventManager.fireTaskReadEvent(task);
        }
    }

    private boolean skipBar(Row row) {
        List<Row> list = row.getChildRows();
        return list.size() == 1 && list.get(0).getChildRows().isEmpty();
    }

    private void populateLeaf(String string, Row row, Task task) {
        if (row.getInteger("TASKID") != null) {
            this.populateTask(row, task);
        } else {
            this.populateMilestone(row, task);
        }
        String string2 = task.getName();
        if (string2 == null || string2.isEmpty()) {
            task.setName(string);
        }
    }

    private void populateTask(Row row, Task task) {
        task.setUniqueID(row.getInteger("TASKID"));
        task.setDuration(row.getDuration("GIVEN_DURATIONHOURS"));
        task.setResume(row.getDate("RESUME"));
        task.setActualDuration(row.getDuration("ACTUAL_DURATIONHOURS"));
        task.setEarlyStart(row.getDate("EARLY_START_DATE"));
        task.setLateStart(row.getDate("LATE_START_DATE"));
        task.setPercentageComplete(row.getDouble("OVERALL_PERCENV_COMPLETE"));
        task.setName(row.getString("NARE"));
        task.setNotes(this.getNotes(row));
        task.setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAU")));
        task.setStart(row.getDate("STARZ"));
        task.setFinish(row.getDate("ENJ"));
        this.processConstraints(row, task);
        if (NumberHelper.getInt(task.getPercentageComplete()) != 0) {
            task.setActualStart(task.getStart());
            if (task.getPercentageComplete().intValue() == 100) {
                task.setActualFinish(task.getFinish());
                task.setDuration(task.getActualDuration());
            }
        }
    }

    private void populateBar(Row row, Task task) {
        Integer n = row.getInteger("CALENDAU");
        ProjectCalendar projectCalendar = this.m_project.getCalendarByUniqueID(n);
        task.setUniqueID(row.getInteger("BARID"));
        task.setStart(row.getDate("STARV"));
        task.setFinish(row.getDate("ENF"));
        task.setName(row.getString("NAMH"));
        task.setCalendar(projectCalendar);
    }

    private void populateMilestone(Row row, Task task) {
        task.setMilestone(true);
        task.setUniqueID(row.getInteger("MILESTONEID"));
        task.setStart(row.getDate("GIVEN_DATE_TIME"));
        task.setFinish(row.getDate("GIVEN_DATE_TIME"));
        task.setPercentageComplete(row.getBoolean("COMPLETED") ? COMPLETE : INCOMPLETE);
        task.setEarlyStart(row.getDate("EARLY_START_DATE"));
        task.setLateStart(row.getDate("LATE_START_DATE"));
        task.setName(row.getString("NARE"));
        task.setCalendar(this.m_project.getCalendarByUniqueID(row.getInteger("CALENDAU")));
        task.setDuration(ZERO_HOURS);
    }

    private void updateStructure() {
        int n = 1;
        Integer n2 = 1;
        for (Task task : this.m_project.getChildTasks()) {
            n = this.updateStructure(n, task, n2);
        }
    }

    private int updateStructure(int n, Task task, Integer n2) {
        task.setID(n++);
        task.setOutlineLevel(n2);
        n2 = n2 + 1;
        for (Task task2 : task.getChildTasks()) {
            n = this.updateStructure(n, task2, n2);
        }
        return n;
    }

    public void processPredecessors(List<Row> list) {
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("START_TASK"));
            Task task2 = this.m_project.getTaskByUniqueID(row.getInteger("END_TASK"));
            if (task == null || task2 == null) continue;
            RelationType relationType = this.getRelationType(row.getInt("TYPI"));
            Duration duration = row.getDuration("START_LAG_TIMEHOURS");
            Duration duration2 = row.getDuration("END_LAG_TIMEHOURS");
            Duration duration3 = null;
            if (duration.getDuration() != 0.0) {
                duration3 = duration;
            } else if (duration2.getDuration() != 0.0) {
                duration3 = duration2;
            }
            task2.addPredecessor(task, relationType, duration3);
        }
    }

    public void processAssignments(List<Row> list) {
        for (Row row : list) {
            Task task = this.m_project.getTaskByUniqueID(row.getInteger("ALLOCATEE_TO"));
            Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("PLAYER"));
            if (task == null || resource == null) continue;
            double d = row.getDouble("PERCENT_COMPLETE");
            Duration duration = row.getWork("EFFORW");
            double d2 = duration.getDuration() * d;
            double d3 = duration.getDuration() - d2;
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            resourceAssignment.setUniqueID(row.getInteger("PERMANENT_SCHEDUL_ALLOCATIONID"));
            resourceAssignment.setStart(row.getDate("STARZ"));
            resourceAssignment.setFinish(row.getDate("ENJ"));
            resourceAssignment.setUnits(row.getDouble("GIVEN_ALLOCATION") * 100.0);
            resourceAssignment.setDelay(row.getDuration("DELAAHOURS"));
            resourceAssignment.setPercentageWorkComplete(d * 100.0);
            resourceAssignment.setWork(duration);
            resourceAssignment.setActualWork(Duration.getInstance(d2, duration.getUnits()));
            resourceAssignment.setRemainingWork(Duration.getInstance(d3, duration.getUnits()));
        }
    }

    private RelationType getRelationType(int n) {
        if (n < 0 || n > RELATION_TYPES.length) {
            n = 0;
        }
        return RELATION_TYPES[n];
    }

    private String getInitials(String string) {
        String string2 = null;
        if (string != null && string.length() != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string.charAt(0));
            int n = 1;
            while ((n = string.indexOf(32, n)) != -1) {
                if (++n < string.length() && string.charAt(n) != ' ') {
                    stringBuilder.append(string.charAt(n));
                }
                ++n;
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private void deriveProjectCalendar() {
        Comparable<Task> comparable22;
        HashMap hashMap = new HashMap();
        for (Comparable<Task> comparable22 : this.m_project.getTasks()) {
            void object;
            ProjectCalendar projectCalendar = comparable22.getCalendar();
            Integer n = (Integer)hashMap.get(projectCalendar);
            if (n == null) {
                Integer n2 = 1;
            } else {
                Integer n3 = n + 1;
            }
            hashMap.put(projectCalendar, object);
        }
        int n = 0;
        comparable22 = null;
        for (Map.Entry entry : hashMap.entrySet()) {
            if ((Integer)entry.getValue() <= n) continue;
            n = (Integer)entry.getValue();
            comparable22 = (ProjectCalendar)entry.getKey();
        }
        if (comparable22 != null) {
            this.m_project.setDefaultCalendar((ProjectCalendar)comparable22);
            for (Task task : this.m_project.getTasks()) {
                if (task.getCalendar() != comparable22) continue;
                task.setCalendar(null);
            }
        }
    }

    private void processConstraints(Row row, Task task) {
        ConstraintType constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
        Date date = null;
        switch (row.getInt("CONSTRAINU")) {
            case 0: {
                if (row.getInt("PLACEMENT") == 0) {
                    constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
                    break;
                }
                constraintType = ConstraintType.AS_LATE_AS_POSSIBLE;
                break;
            }
            case 1: {
                constraintType = ConstraintType.MUST_START_ON;
                date = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 2: {
                constraintType = ConstraintType.START_NO_LATER_THAN;
                date = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 3: {
                constraintType = ConstraintType.START_NO_EARLIER_THAN;
                date = row.getDate("START_CONSTRAINT_DATE");
                break;
            }
            case 4: {
                constraintType = ConstraintType.MUST_FINISH_ON;
                date = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 5: {
                constraintType = ConstraintType.FINISH_NO_LATER_THAN;
                date = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 6: {
                constraintType = ConstraintType.FINISH_NO_EARLIER_THAN;
                date = row.getDate("END_CONSTRAINT_DATE");
                break;
            }
            case 8: {
                task.setDeadline(row.getDate("END_CONSTRAINT_DATE"));
            }
        }
        task.setConstraintType(constraintType);
        task.setConstraintDate(date);
    }

    public Map<Integer, DayType> createExceptionTypeMap(List<Row> list) {
        HashMap<Integer, DayType> hashMap = new HashMap<Integer, DayType>();
        for (Row row : list) {
            Integer n = row.getInteger("EXCEPTIONNID");
            hashMap.put(n, switch (row.getInt("UNIQUE_BIT_FIELD")) {
                case 8, 32, 128 -> DayType.WORKING;
                default -> DayType.NON_WORKING;
            });
        }
        return hashMap;
    }

    public Map<Integer, Row> createWorkPatternMap(List<Row> list) {
        HashMap<Integer, Row> hashMap = new HashMap<Integer, Row>();
        for (Row row : list) {
            hashMap.put(row.getInteger("WORK_PATTERNID"), row);
        }
        return hashMap;
    }

    public Map<Integer, List<Row>> createWorkPatternAssignmentMap(List<Row> list) {
        HashMap<Integer, List<Row>> hashMap = new HashMap<Integer, List<Row>>();
        for (Row row : list) {
            Integer n = row.getInteger("WORK_PATTERN_ASSIGNMENTID");
            LinkedList<Row> linkedList = (LinkedList<Row>)hashMap.get(n);
            if (linkedList == null) {
                linkedList = new LinkedList<Row>();
                hashMap.put(n, linkedList);
            }
            linkedList.add(row);
        }
        return hashMap;
    }

    public Map<Integer, List<Row>> createExceptionAssignmentMap(List<Row> list) {
        HashMap<Integer, List<Row>> hashMap = new HashMap<Integer, List<Row>>();
        for (Row row : list) {
            Integer n = row.getInteger("EXCEPTION_ASSIGNMENTID");
            LinkedList<Row> linkedList = (LinkedList<Row>)hashMap.get(n);
            if (linkedList == null) {
                linkedList = new LinkedList<Row>();
                hashMap.put(n, linkedList);
            }
            linkedList.add(row);
        }
        return hashMap;
    }

    public Map<Integer, List<Row>> createTimeEntryMap(List<Row> list) {
        HashMap<Integer, List<Row>> hashMap = new HashMap<Integer, List<Row>>();
        for (Row row : list) {
            Integer n = row.getInteger("TIME_ENTRYID");
            LinkedList<Row> linkedList = (LinkedList<Row>)hashMap.get(n);
            if (linkedList == null) {
                linkedList = new LinkedList<Row>();
                hashMap.put(n, linkedList);
            }
            linkedList.add(row);
        }
        return hashMap;
    }

    public void processCalendar(Row row, Map<Integer, Row> map, Map<Integer, List<Row>> map2, Map<Integer, List<Row>> map3, Map<Integer, List<Row>> map4, Map<Integer, DayType> map5) {
        Comparable<ProjectCalendarWeek> comparable;
        Comparable<Integer> comparable2;
        ProjectCalendar projectCalendar = this.m_project.addCalendar();
        Integer n = row.getInteger("DOMINANT_WORK_PATTERN");
        projectCalendar.setUniqueID(row.getInteger("CALENDARID"));
        this.processWorkPattern(projectCalendar, n, map, map4, map5);
        projectCalendar.setName(row.getString("NAMK"));
        List<Row> list = map2.get(projectCalendar.getUniqueID());
        if (list != null) {
            for (Row row2 : list) {
                comparable2 = row2.getInteger("WORK_PATTERN");
                if (comparable2.equals(n)) continue;
                comparable = projectCalendar.addWorkWeek();
                comparable.setDateRange(new DateRange(row2.getDate("START_DATE"), row2.getDate("END_DATE")));
                this.processWorkPattern((ProjectCalendarWeek)comparable, (Integer)comparable2, map, map4, map5);
            }
        }
        if ((list = map3.get(projectCalendar.getUniqueID())) != null) {
            for (Row row2 : list) {
                comparable2 = row2.getDate("STARU_DATE");
                comparable = row2.getDate("ENE_DATE");
                projectCalendar.addCalendarException((Date)comparable2, (Date)comparable);
            }
        }
        this.m_eventManager.fireCalendarReadEvent(projectCalendar);
    }

    private void processWorkPattern(ProjectCalendarWeek projectCalendarWeek, Integer n, Map<Integer, Row> map, Map<Integer, List<Row>> map2, Map<Integer, DayType> map3) {
        Row row = map.get(n);
        if (row != null) {
            projectCalendarWeek.setName(row.getString("NAMN"));
            List<Row> list = map2.get(n);
            if (list != null) {
                long l = Long.MIN_VALUE;
                Day day = Day.SUNDAY;
                ProjectCalendarHours projectCalendarHours = projectCalendarWeek.addCalendarHours(day);
                Arrays.fill(projectCalendarWeek.getDays(), DayType.NON_WORKING);
                for (Row row2 : list) {
                    Object object;
                    Date date = row2.getDate("START_TIME");
                    Date date2 = row2.getDate("END_TIME");
                    if (date == null) {
                        date = DateHelper.getDayStartDate(new Date(0L));
                    }
                    if (date2 == null) {
                        date2 = DateHelper.getDayEndDate(new Date(0L));
                    }
                    if (date.getTime() > date2.getTime()) {
                        object = Calendar.getInstance();
                        ((Calendar)object).setTime(date2);
                        ((Calendar)object).add(6, 1);
                        date2 = ((Calendar)object).getTime();
                    }
                    if (date.getTime() < l) {
                        day = day.getNextDay();
                        projectCalendarHours = projectCalendarWeek.addCalendarHours(day);
                    }
                    if ((object = map3.get(row2.getInteger("EXCEPTIOP"))) == DayType.WORKING) {
                        projectCalendarHours.addRange(new DateRange(date, date2));
                        projectCalendarWeek.setWorkingDay(day, DayType.WORKING);
                    }
                    l = date2.getTime();
                }
            }
        }
    }

    private String getNotes(Row row) {
        String string = row.getString("NOTET");
        if (string != null) {
            if (string.isEmpty()) {
                string = null;
            } else if (string.indexOf(LINE_BREAK) != -1) {
                string = string.replace(LINE_BREAK, "\n");
            }
        }
        return string;
    }
}

