/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.task;

import com.projectlibre1.algorithm.ReverseQuery;
import com.projectlibre1.algorithm.TimeIteratorGenerator;
import com.projectlibre1.algorithm.buffer.CalculatedValues;
import com.projectlibre1.association.AssociationFormatParameters;
import com.projectlibre1.association.AssociationList;
import com.projectlibre1.association.AssociationListFormat;
import com.projectlibre1.configuration.Configuration;
import com.projectlibre1.configuration.Settings;
import com.projectlibre1.datatype.Duration;
import com.projectlibre1.datatype.ImageLink;
import com.projectlibre1.document.Document;
import com.projectlibre1.field.CustomFieldsImpl;
import com.projectlibre1.field.FieldContext;
import com.projectlibre1.field.FieldParseException;
import com.projectlibre1.functor.IntervalConsumer;
import com.projectlibre1.functor.NumberClosure;
import com.projectlibre1.functor.ObjectVisitor;
import com.projectlibre1.graphic.configuration.HasIndicators;
import com.projectlibre1.graphic.configuration.HasTaskIndicators;
import com.projectlibre1.grouping.core.Node;
import com.projectlibre1.grouping.core.model.NodeModel;
import com.projectlibre1.grouping.core.summaries.DeepChildWalker;
import com.projectlibre1.options.CalculationOption;
import com.projectlibre1.options.CalendarOption;
import com.projectlibre1.options.ScheduleOption;
import com.projectlibre1.pm.assignment.Allocation;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.assignment.AssignmentFormat;
import com.projectlibre1.pm.assignment.AssignmentService;
import com.projectlibre1.pm.assignment.HasAssignments;
import com.projectlibre1.pm.assignment.TimeDistributedFields;
import com.projectlibre1.pm.assignment.timesheet.TimesheetHelper;
import com.projectlibre1.pm.calendar.CalendarService;
import com.projectlibre1.pm.calendar.WorkCalendar;
import com.projectlibre1.pm.costing.EarnedValueCalculator;
import com.projectlibre1.pm.costing.EarnedValueFields;
import com.projectlibre1.pm.costing.EarnedValueValues;
import com.projectlibre1.pm.criticalpath.TaskSchedule;
import com.projectlibre1.pm.dependency.Dependency;
import com.projectlibre1.pm.key.HasKeyImpl;
import com.projectlibre1.pm.resource.Resource;
import com.projectlibre1.pm.resource.ResourceImpl;
import com.projectlibre1.pm.scheduling.BarClosure;
import com.projectlibre1.pm.scheduling.Schedule;
import com.projectlibre1.pm.scheduling.ScheduleEvent;
import com.projectlibre1.pm.scheduling.ScheduleInterval;
import com.projectlibre1.pm.scheduling.ScheduleUtil;
import com.projectlibre1.pm.scheduling.SchedulingFields;
import com.projectlibre1.pm.scheduling.SchedulingRule;
import com.projectlibre1.pm.scheduling.SchedulingType;
import com.projectlibre1.pm.snapshot.BaselineScheduleFields;
import com.projectlibre1.pm.snapshot.DataSnapshot;
import com.projectlibre1.pm.snapshot.SnapshottableImpl;
import com.projectlibre1.pm.task.Project;
import com.projectlibre1.pm.task.Task;
import com.projectlibre1.pm.task.TaskBackup;
import com.projectlibre1.pm.task.TaskSnapshot;
import com.projectlibre1.pm.task.TaskSnapshotBackup;
import com.projectlibre1.pm.task.TaskSpecificFields;
import com.projectlibre1.server.access.ErrorLogger;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.DateTime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.collections.Closure;

public class NormalTask
extends Task
implements Allocation,
TaskSpecificFields,
SchedulingFields,
HasAssignments,
EarnedValueValues,
EarnedValueFields,
TimeDistributedFields,
BaselineScheduleFields,
HasTaskIndicators {
    static final long serialVersionUID = 273898992929L;
    boolean estimated = true;
    int priority = 500;
    private static NormalTask UNASSIGNED = null;
    private WorkCalendar workCalendar = null;
    protected static transient BarClosure barClosureInstance = new BarClosure();
    private static short DEFAULT_VERSION = (short)2;
    private short version = DEFAULT_VERSION;

    public NormalTask(Project project) {
        this(project.isLocal(), project);
    }

    public NormalTask(boolean bl, Project project) {
        super(bl);
        this.project = project;
        this.initializeDates();
        this.addDefaultAssignment();
    }

    public NormalTask() {
    }

    void initializeDates() {
        this.setRawConstraintType(this.project == null ? 0 : this.project.getDefaultConstraintType());
        long l = CalendarOption.getInstance().getDefaultDuration();
        this.setRawDuration(l);
        this.setWorkCalendar(null);
        long l2 = this.project.getStart();
        this.currentSchedule.setStart(l2);
        this.currentSchedule.setFinish(l2);
        if (ScheduleOption.getInstance().isNewTasksStartToday()) {
            this.setWindowEarlyStart(CalendarOption.getInstance().makeValidStart(DateTime.midnightToday(), true));
        }
    }

    private NormalTask(boolean bl) {
        super(true);
    }

    public static NormalTask getUnassignedInstance() {
        if (UNASSIGNED == null) {
            UNASSIGNED = new NormalTask(true);
            UNASSIGNED.setName(Messages.getString("Text.Unassigned"));
        }
        return UNASSIGNED;
    }

    private Assignment newDefaultAssignment() {
        return Assignment.getInstance((Task)this, ResourceImpl.getUnassignedInstance(), 1.0, 0);
    }

    @Override
    public boolean isNormal() {
        return !this.isSummary() && !this.isMilestone() && !this.isExternal();
    }

    @Override
    public boolean isCritical() {
        if (this.currentSchedule.isForward()) {
            return this.getEarlyFinish() >= this.getLateFinish();
        }
        return this.getLateStart() <= this.getEarlyStart();
    }

    @Override
    public boolean isMilestone() {
        return Duration.millis(this.getRawDuration()) == 0L || this.isMarkTaskAsMilestone();
    }

    @Override
    public double getPercentComplete() {
        if (this.isZeroDuration()) {
            int n = 0;
            double d = 0.0;
            for (Assignment assignment : this.getAssignments()) {
                d += assignment.getPercentComplete();
                ++n;
            }
            if (n == 0) {
                return 0.0;
            }
            return d / (double)n;
        }
        return super.getPercentComplete();
    }

    @Override
    public long getDuration() {
        long l;
        if (this.isWbsParent() || this.isExternal() || this.isSubproject()) {
            long l2 = this.getRawDuration();
            if (l2 >= 0L) {
                l = Duration.millis(l2);
            } else {
                this.project.addRepaired(this);
                ErrorLogger.logOnce("raw parent", "repaired bad raw duration" + String.valueOf(this), null);
                l = 0L;
            }
        } else {
            AssociationList associationList = this.getAssignments();
            if (associationList.size() == 1) {
                l = ((Assignment)associationList.getFirst()).getDurationMillis();
            } else {
                Iterator iterator = associationList.iterator();
                long l3 = 0L;
                while (iterator.hasNext()) {
                    l3 = Math.max(l3, ((Assignment)iterator.next()).getEnd());
                }
                l = this.getEffectiveWorkCalendar().compare(l3, this.getStart(), false);
            }
        }
        l = Duration.setAsEstimated(l, this.estimated);
        return l;
    }

    @Override
    public boolean hasDuration() {
        if (this.isWbsParent()) {
            return this.getRawDuration() != 0L;
        }
        AssociationList associationList = this.getAssignments();
        if (associationList.size() == 1) {
            return ((Assignment)associationList.getFirst()).hasDuration();
        }
        Iterator iterator = associationList.iterator();
        while (iterator.hasNext()) {
            if (!((Assignment)iterator.next()).hasDuration()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDuration(long l) {
        this.setRawDuration(l);
        this.estimated = Duration.isEstimated(l);
        l = Duration.millis(l);
        long l2 = Duration.millis(this.getActualDuration());
        if (l < l2) {
            this.setPercentComplete(1.0);
        }
        if (!this.isWbsParent()) {
            long l3 = l - l2;
            this.getSchedulingRule().adjustRemainingDuration(this, l3, true);
        }
        this.updateCachedDuration();
    }

    @Override
    public WorkCalendar getWorkCalendar() {
        return this.workCalendar;
    }

    @Override
    public WorkCalendar getEffectiveWorkCalendar() {
        if (this.workCalendar == null) {
            if (this.getProject() == null) {
                System.out.println("------No project in getting calendar for task " + this.getUniqueId() + " " + this.getName());
                return CalendarService.getInstance().getDefaultInstance();
            }
            return this.getProject().getEffectiveWorkCalendar();
        }
        return this.workCalendar;
    }

    @Override
    public void setWorkCalendar(WorkCalendar workCalendar) {
        this.workCalendar = workCalendar;
    }

    @Override
    public DataSnapshot getCurrentSnapshot() {
        return this.snapshots.getCurrentSnapshot();
    }

    @Override
    public DataSnapshot getSnapshot(Object object) {
        return this.snapshots.getSnapshot(object);
    }

    @Override
    public void saveCurrentToSnapshot(Object object) {
        this.setSnapshot(object, this.cloneSnapshot(this.getSnapshot(CURRENT)));
        this.markTaskAsNeedingRecalculation();
        this.setDirty(true);
    }

    public void restoreSnapshot(Object object, Object object2) {
        TaskBackup taskBackup = (TaskBackup)object2;
        if (taskBackup.snapshot == null) {
            return;
        }
        TaskSnapshot taskSnapshot = (TaskSnapshot)((TaskSnapshot)this.getSnapshot(CURRENT)).clone();
        this.restoreDetail(this, taskBackup, true, taskSnapshot);
        this.setSnapshot(object, taskSnapshot);
        this.markTaskAsNeedingRecalculation();
        this.setDirty(true);
    }

    @Override
    public void setCurrentSnapshot(DataSnapshot dataSnapshot) {
        this.snapshots.setCurrentSnapshot(dataSnapshot);
    }

    @Override
    public void setSnapshot(Object object, DataSnapshot dataSnapshot) {
        this.snapshots.setSnapshot(object, dataSnapshot);
    }

    @Override
    public void clearSnapshot(Object object) {
        this.snapshots.clearSnapshot(object);
        this.markTaskAsNeedingRecalculation();
        this.setDirty(true);
    }

    public boolean hasRealAssignments() {
        return null == this.findAssignment(ResourceImpl.getUnassignedInstance());
    }

    @Override
    public AssociationList getAssignments() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getAssignments();
    }

    public AssociationList getRealAssignments() {
        if (this.hasRealAssignments()) {
            return this.getAssignments();
        }
        return new AssociationList();
    }

    public boolean isAssignedToMe() {
        for (Assignment assignment : this.getAssignments()) {
            if (!assignment.isMine()) continue;
            return true;
        }
        return false;
    }

    public Assignment addDefaultAssignment() {
        Assignment assignment = this.newDefaultAssignment();
        this.addAssignment(assignment);
        return assignment;
    }

    @Override
    public void addAssignment(Assignment assignment) {
        boolean bl = !assignment.isDefault() && assignment.isInitialized() && assignment.isLabor();
        Assignment assignment2 = this.findAssignment(ResourceImpl.getUnassignedInstance());
        if (!assignment.isDefault()) {
            if (assignment2 != null) {
                assignment.usePropertiesOf(assignment2);
                AssignmentService.getInstance().remove(assignment2, null, true);
            } else {
                if (this.getActualStart() != 0L) {
                    assignment.setDelay(Duration.millis(this.getActualDuration()));
                }
                assignment.adjustRemainingDuration(Duration.millis(this.getRemainingDuration()), false);
            }
        } else {
            if (assignment2 != null) {
                AssignmentService.getInstance().remove(assignment2, null, true);
            }
            assignment.setDuration(this.getRawDuration());
        }
        double d = this.getMostLoadedAssignmentUnits();
        double d2 = this.getRemainingUnits();
        ((TaskSnapshot)this.getCurrentSnapshot()).addAssignment(assignment);
        if (!assignment.isInitialized()) {
            return;
        }
        if (bl && this.isEffortDriven() && d2 != 0.0) {
            if (this.getSchedulingType() == 1) {
                assignment.adjustRemainingUnits(Math.min(1.0, d), 1.0, false, false);
            }
            double d3 = d2 + assignment.getRemainingLaborUnits();
            this.getSchedulingRule().adjustRemainingUnits(this, d3, d2, true, true);
        }
        this.setDirty(true);
    }

    @Override
    public void removeAssignment(Assignment assignment) {
        boolean bl = !assignment.isDefault() && assignment.isInitialized();
        double d = this.getRemainingUnits();
        ((TaskSnapshot)this.getCurrentSnapshot()).removeAssignment(assignment);
        if (!assignment.isDefault()) {
            double d2;
            if (bl && this.isEffortDriven() && (d2 = d - assignment.getLaborUnits()) != 0.0) {
                this.getSchedulingRule().adjustRemainingUnits(this, d2, d, true, true);
            }
            if (this.getAssignments().isEmpty()) {
                Assignment assignment2 = this.newDefaultAssignment();
                assignment2.usePropertiesOf(assignment);
                AssignmentService.getInstance().connect(assignment2, null);
            }
        }
        this.setDirty(true);
    }

    @Override
    public DataSnapshot cloneSnapshot(DataSnapshot dataSnapshot) {
        return (DataSnapshot)((TaskSnapshot)dataSnapshot).clone();
    }

    @Override
    public TaskSnapshot getBaselineSnapshot() {
        return (TaskSnapshot)this.getSnapshot(CalculationOption.getInstance().getEarnedValueBaselineId());
    }

    @Override
    public void buildReverseQuery(ReverseQuery reverseQuery) {
        ((TaskSnapshot)this.getCurrentSnapshot()).buildReverseQuery(reverseQuery);
        Collection collection = this.getWbsChildrenNodes();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object = ((Node)iterator.next()).getImpl();
                if (!(object instanceof NormalTask)) continue;
                Task task = (Task)object;
                task.buildReverseQuery(reverseQuery);
            }
        }
    }

    public long getBaselineStartOrZero() {
        TaskSnapshot taskSnapshot = this.getBaselineSnapshot();
        if (taskSnapshot == null) {
            return 0L;
        }
        return this.getBaselineStart();
    }

    public long getBaselineFinishOrZero() {
        TaskSnapshot taskSnapshot = this.getBaselineSnapshot();
        if (taskSnapshot == null) {
            return 0L;
        }
        return this.getBaselineFinish();
    }

    public long getBaselineStart() {
        TaskSnapshot taskSnapshot = this.getBaselineSnapshot();
        if (taskSnapshot == null) {
            return this.getStart();
        }
        return taskSnapshot.getCurrentSchedule().getStart();
    }

    public long getBaselineFinish() {
        TaskSnapshot taskSnapshot = this.getBaselineSnapshot();
        if (taskSnapshot == null) {
            return this.getEnd();
        }
        return taskSnapshot.getCurrentSchedule().getFinish();
    }

    @Override
    public int getSchedulingType() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getSchedulingType();
    }

    @Override
    public void setSchedulingType(int n) {
        ((TaskSnapshot)this.getCurrentSnapshot()).setSchedulingType(n);
    }

    @Override
    public boolean isEffortDriven() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).isEffortDriven();
    }

    @Override
    public void setEffortDriven(boolean bl) {
        ((TaskSnapshot)this.getCurrentSnapshot()).setEffortDriven(bl);
    }

    @Override
    public boolean isReadOnlyEffortDriven(FieldContext fieldContext) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).isReadOnlyEffortDriven(fieldContext);
    }

    public static Closure forAllAssignments(Closure closure) {
        return new ObjectVisitor(closure){

            @Override
            protected Object getObject(Object object) {
                return ((TaskSnapshot)((Task)object).getCurrentSnapshot()).getHasAssignments();
            }
        };
    }

    @Override
    public double getFixedCost() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getFixedCost();
    }

    @Override
    public void setFixedCost(double d) {
        ((TaskSnapshot)this.getCurrentSnapshot()).setFixedCost(d);
    }

    @Override
    public final int getFixedCostAccrual() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getFixedCostAccrual();
    }

    @Override
    public final void setFixedCostAccrual(int n) {
        ((TaskSnapshot)this.getCurrentSnapshot()).setFixedCostAccrual(n);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int n) {
        this.priority = n;
    }

    @Override
    public Assignment findAssignment(Resource resource) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).findAssignment(resource);
    }

    @Override
    public Assignment findAssignment(Task task) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).findAssignment(task);
    }

    @Override
    public void updateAssignment(Assignment assignment) {
        ((TaskSnapshot)this.getCurrentSnapshot()).updateAssignment(assignment);
    }

    @Override
    public void forEachWorkingInterval(Closure closure, boolean bl, WorkCalendar workCalendar) {
        ((TaskSnapshot)this.getCurrentSnapshot()).forEachWorkingInterval(closure, bl, workCalendar);
    }

    @Override
    public boolean isEstimated() {
        return this.estimated;
    }

    @Override
    public void setEstimated(boolean bl) {
        NormalTask normalTask;
        boolean bl2 = this.estimated != bl;
        this.estimated = bl;
        if (bl2 && this.isWbsParent() && (normalTask = (NormalTask)this.getWbsParentTask()) != null) {
            normalTask.updateEstimatedStatus();
        }
    }

    private void updateEstimatedStatus() {
        Collection collection = this.getWbsChildrenNodes();
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object object = ((Node)iterator.next()).getImpl();
            if (!(object instanceof NormalTask)) continue;
            NormalTask normalTask = (NormalTask)object;
            bl |= normalTask.isEstimated();
        }
        this.setEstimated(bl);
    }

    protected void assignParentActualDatesFromChildren() {
        NormalTask normalTask = this;
        while ((normalTask = (NormalTask)normalTask.getWbsParentTask()) != null) {
            normalTask.assignActualDatesFromChildren();
        }
    }

    public void assignActualDatesFromChildren() {
        long l = Long.MAX_VALUE;
        long l2 = 0L;
        Collection collection = this.getWbsChildrenNodes();
        Iterator iterator = collection.iterator();
        long l3 = Duration.millis(this.getActualDuration());
        while (iterator.hasNext()) {
            NormalTask normalTask;
            Object object = ((Node)iterator.next()).getImpl();
            if (!(object instanceof NormalTask) || !(normalTask = (NormalTask)object).inProgress()) continue;
            long l4 = normalTask.getActualStart();
            if (l4 != 0L) {
                l = Math.min(l, l4);
            }
            l2 = Math.max(l2, normalTask.getStop());
        }
        long l5 = 0L;
        if (l != Long.MAX_VALUE && l2 != 0L) {
            l5 = this.getEffectiveWorkCalendar().compare(l2, this.getStart(), false);
        }
        if (l != Long.MAX_VALUE) {
            this.setActualStartNoEvent(l);
        } else {
            this.setActualStartNoEvent(0L);
        }
        if (l5 != l3) {
            double d = (double)l5 / (double)this.getDurationMillis();
            this.currentSchedule.setPercentComplete(d);
            this.markTaskAsNeedingRecalculation();
        }
    }

    @Override
    public WorkCalendar getTaskCalendar() {
        return this.getWorkCalendar();
    }

    @Override
    public void setTaskCalendar(WorkCalendar workCalendar) {
        if (this.workCalendar == workCalendar) {
            return;
        }
        CalendarService.getInstance().reassignCalendar(this, this.workCalendar, workCalendar);
        this.setWorkCalendar(workCalendar);
        this.invalidateAssignmentCalendars();
    }

    @Override
    public long getBaselineStart(int n) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n));
        if (taskSnapshot == null) {
            return 0L;
        }
        return taskSnapshot.getCurrentSchedule().getStart();
    }

    @Override
    public long getBaselineFinish(int n) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n));
        if (taskSnapshot == null) {
            return 0L;
        }
        return taskSnapshot.getCurrentSchedule().getEnd();
    }

    @Override
    public long getBaselineDuration(int n) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n));
        if (taskSnapshot == null) {
            return 0L;
        }
        return taskSnapshot.getCurrentSchedule().getRawDuration();
    }

    public double getBaselineCost(int n, long l, long l2) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n));
        if (taskSnapshot == null) {
            return 0.0;
        }
        return taskSnapshot.cost(l, l2);
    }

    public double getBaselineWork(int n, long l, long l2) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n));
        if (taskSnapshot == null) {
            return 0.0;
        }
        return taskSnapshot.work(l, l2);
    }

    @Override
    public String getResourceInitials() {
        return AssociationListFormat.getInstance(AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.initials"), false, false))).format(this.getAssignments());
    }

    @Override
    public void setResourceInitials(String string) throws FieldParseException {
        this.getAssignments().setAssociations(string, AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.initials"), false, false)));
    }

    @Override
    public String getResourcePhonetics() {
        return AssociationListFormat.getInstance(AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.phonetics"), false, true))).format(this.getAssignments());
    }

    @Override
    public String getResourceGroup() {
        return AssociationListFormat.getInstance(AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.group"), false, false))).format(this.getAssignments());
    }

    @Override
    public String getResourceNames() {
        return AssociationListFormat.getInstance(AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.name"), true, true))).format(this.getAssignments());
    }

    @Override
    public void setResourceNames(String string) throws FieldParseException {
        this.getAssignments().setAssociations(string, AssignmentFormat.getInstance(AssociationFormatParameters.getInstance(this, true, Configuration.getFieldFromId("Field.name"), true, true)));
    }

    @Override
    public double getUnits() {
        if (this.getAssignments().isEmpty()) {
            return 0.0;
        }
        long l = this.getDurationMillis();
        if ((double)l == 0.0) {
            return 1.0;
        }
        if (!this.isInitialized()) {
            return 1.0;
        }
        long l2 = this.calcWork();
        if (l2 == 0L) {
            return 1.0;
        }
        return (double)l2 / (double)l;
    }

    @Override
    public double getRemainingUnits() {
        if (this.getAssignments().isEmpty()) {
            return 0.0;
        }
        long l = Duration.millis(this.getRemainingDuration());
        if ((double)l == 0.0) {
            return 1.0;
        }
        if (!this.isInitialized()) {
            return 1.0;
        }
        long l2 = this.getRemainingWork(null);
        return (double)l2 / (double)l;
    }

    @Override
    public void setWork(long l, FieldContext fieldContext) {
        if (FieldContext.hasInterval(fieldContext)) {
            for (Assignment assignment : this.getAssignments()) {
                assignment.setWork(l, fieldContext);
            }
        } else {
            this.setWork(l);
        }
    }

    public void setWork(long l) {
        l = Duration.millis(l);
        if (this.hasLaborAssignment() && l < 60000L) {
            l = (long)((double)l * Duration.timeUnitFactor(1));
        }
        long l2 = l - this.getActualWork(null);
        this.getSchedulingRule().adjustRemainingWork(this, l2, true);
    }

    public long calcWork() {
        if (!this.hasRealAssignments()) {
            return 0L;
        }
        return this.getWork(null);
    }

    @Override
    public double getMostLoadedAssignmentUnits() {
        double d = 0.0;
        Iterator iterator = this.getAssignments().iterator();
        while (iterator.hasNext()) {
            d = Math.max(d, ((Assignment)iterator.next()).getLaborUnits());
        }
        return d;
    }

    @Override
    public void adjustRemainingDuration(long l, boolean bl) {
        long l2 = Duration.millis(l);
        Iterator iterator = this.getAssignments().iterator();
        while (iterator.hasNext()) {
            ((Assignment)iterator.next()).adjustRemainingDurationIfWorkingAtTaskEnd(l2);
        }
    }

    public void adjustUnitsDelta(double d) {
        this.getSchedulingRule().adjustRemainingUnits(this, this.getRemainingUnits() + d, this.getRemainingUnits(), false, false);
    }

    @Override
    public void adjustRemainingUnits(double d, double d2, boolean bl, boolean bl2) {
        if (!bl) {
            return;
        }
        double d3 = 1.0;
        if (bl2) {
            d3 = d2 / d;
        }
        double d4 = d;
        double d5 = this.getRemainingUnits();
        double d6 = d4 / d5;
        for (Assignment assignment : this.getAssignments()) {
            double d7 = assignment.getLaborUnits();
            if (bl2) {
                this.getSchedulingRule().adjustRemainingUnits(assignment, assignment.getRemainingLaborUnits() * d3, assignment.getRemainingLaborUnits(), false, false);
                continue;
            }
            this.getSchedulingRule().adjustRemainingUnits(assignment, d6 * d7, d7, false, false);
        }
    }

    @Override
    public void adjustRemainingWork(double d, boolean bl) {
        for (Assignment assignment : this.getAssignments()) {
            if (!assignment.isLabor()) continue;
            this.getSchedulingRule().adjustRemainingWork(assignment, (long)((double)assignment.getRemainingWork() * d), false);
        }
    }

    public SchedulingRule getSchedulingRule() {
        return SchedulingType.getSchedulingRuleInstance(this.getSchedulingType());
    }

    @Override
    public boolean isReadOnlyUnits(FieldContext fieldContext) {
        return true;
    }

    @Override
    public long getCompletedThrough() {
        long l = this.getStart();
        if (l == 0L) {
            return 0L;
        }
        long l2 = DateTime.closestDate((double)this.getDurationMillis() * this.getPercentComplete());
        return this.getEffectiveWorkCalendar().add(l, l2, true);
    }

    @Override
    public long getStop() {
        return this.getEarliestStop();
    }

    public void adjustActualStartFromAssignments() {
        Iterator iterator = this.getAssignments().iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            if (!(assignment.getPercentComplete() > 0.0)) continue;
            l = this.getStart();
            break;
        }
        this.setActualStart(l);
        this.assignParentActualDatesFromChildren();
    }

    @Override
    public void setStop(long l) {
        if (l == this.getStop()) {
            return;
        }
        l = DateTime.closestDate(l);
        l = Math.min(l, this.getEnd());
        Iterator iterator = this.getAssignments().iterator();
        long l2 = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            assignment.setStop(l);
            long l3 = assignment.getActualStart();
            if (l3 == 0L || l3 >= l2) continue;
            l2 = l3;
        }
        if (l2 == Long.MAX_VALUE) {
            l2 = 0L;
        }
        this.setActualStart(l2);
        this.assignParentActualDatesFromChildren();
        if (l2 == 0L) {
            this.getDocument().getObjectEventManager().fireUpdateEvent((Object)this, (Object)this, Configuration.getFieldFromId("Field.start"));
        } else {
            this.getProject().fireScheduleChanged(this, ScheduleEvent.ACTUAL, this);
        }
    }

    @Override
    public long getResume() {
        long l = Long.MAX_VALUE;
        for (Assignment assignment : this.getAssignments()) {
            l = Math.min(l, assignment.getResume());
        }
        return l;
    }

    @Override
    public void setResume(long l) {
        for (Assignment assignment : this.getAssignments()) {
            assignment.setResume(l);
        }
    }

    private void setStopNoExtend(long l) {
        long l2 = this.getStart();
        if (l < l2) {
            this.setActualDuration(0L);
            l = l2;
        } else {
            long l3 = this.getEffectiveWorkCalendar().compare(l, l2, false);
            l3 = Math.min(l3, this.getDurationMillis());
            this.setActualDuration(l3);
        }
    }

    private boolean isParentWithoutAssignments() {
        return this.isWbsParent() && !this.hasRealAssignments();
    }

    @Override
    public double cost(long l, long l2) {
        if (this.isParentWithoutAssignments()) {
            return 0.0;
        }
        return ((TaskSnapshot)this.getCurrentSnapshot()).cost(l, l2);
    }

    @Override
    public long work(long l, long l2) {
        if (this.isParentWithoutAssignments()) {
            return 0L;
        }
        return ((TaskSnapshot)this.getCurrentSnapshot()).work(l, l2);
    }

    @Override
    public double actualCost(long l, long l2) {
        if (this.isParentWithoutAssignments()) {
            return 0.0;
        }
        return ((TaskSnapshot)this.getCurrentSnapshot()).actualCost(l, l2);
    }

    @Override
    public long actualWork(long l, long l2) {
        if (this.isParentWithoutAssignments()) {
            return 0L;
        }
        return ((TaskSnapshot)this.getCurrentSnapshot()).actualWork(l, l2);
    }

    @Override
    public long remainingWork(long l, long l2) {
        if (this.isParentWithoutAssignments()) {
            return 0L;
        }
        return ((TaskSnapshot)this.getCurrentSnapshot()).remainingWork(l, l2);
    }

    @Override
    public double baselineCost(long l, long l2) {
        if (this.getBaselineSnapshot() == null) {
            return 0.0;
        }
        return this.getBaselineSnapshot().cost(l, l2);
    }

    @Override
    public long baselineWork(long l, long l2) {
        if (this.getBaselineSnapshot() == null) {
            return 0L;
        }
        return this.getBaselineSnapshot().work(l, l2);
    }

    @Override
    public double acwp(long l, long l2) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).acwp(l, l2);
    }

    @Override
    public double bac(long l, long l2) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).bac(l, l2);
    }

    @Override
    public double bcwp(long l, long l2) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).bcwp(l, l2);
    }

    @Override
    public double bcws(long l, long l2) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).bcws(l, l2);
    }

    boolean isInRange(long l, long l2) {
        long l3 = this.getStart();
        return l2 > l3 && l < this.getEnd();
    }

    private boolean isFieldHidden(FieldContext fieldContext) {
        return fieldContext != null && !this.isInRange(fieldContext.getStart(), fieldContext.getEnd());
    }

    private boolean isBaselineFieldHidden(int n, FieldContext fieldContext) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n));
        if (taskSnapshot == null) {
            return true;
        }
        if (fieldContext == null) {
            return false;
        }
        return fieldContext.getStart() >= taskSnapshot.getCurrentSchedule().getFinish() || fieldContext.getEnd() <= taskSnapshot.getCurrentSchedule().getStart();
    }

    private boolean isEarnedValueFieldHidden(FieldContext fieldContext) {
        if (this.isFieldHidden(fieldContext)) {
            return true;
        }
        if (fieldContext == null) {
            return false;
        }
        return this.project.getStatusDate() < fieldContext.getStart();
    }

    @Override
    public boolean fieldHideCost(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideWork(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideActualCost(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideActualWork(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBaselineCost(int n, FieldContext fieldContext) {
        return this.isBaselineFieldHidden(n, fieldContext);
    }

    @Override
    public boolean fieldHideBaselineWork(int n, FieldContext fieldContext) {
        return this.isBaselineFieldHidden(n, fieldContext);
    }

    @Override
    public boolean fieldHideAcwp(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBcwp(FieldContext fieldContext) {
        return this.isEarnedValueFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideBcws(FieldContext fieldContext) {
        return this.isEarnedValueFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCv(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSv(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideEac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideVac(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideCvPercent(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideSvPercent(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public boolean fieldHideTcpi(FieldContext fieldContext) {
        return this.isFieldHidden(fieldContext);
    }

    @Override
    public double getCost(FieldContext fieldContext) {
        return this.getFixedCost(fieldContext) + this.cost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getWork(FieldContext fieldContext) {
        return this.work(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getActualFixedCost(FieldContext fieldContext) {
        return this.fixedCost(FieldContext.start(fieldContext), Math.min(this.getStop(), FieldContext.end(fieldContext)));
    }

    @Override
    public double getFixedCost(FieldContext fieldContext) {
        if (!FieldContext.hasInterval(fieldContext)) {
            return ((TaskSnapshot)this.getCurrentSnapshot()).getFixedCost();
        }
        return this.fixedCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double actualFixedCost(long l, long l2) {
        return this.fixedCost(l, Math.min(this.getStop(), l2));
    }

    @Override
    public double fixedCost(long l, long l2) {
        long l3 = this.getStart();
        long l4 = this.getEnd();
        double d = 0.0;
        double d2 = this.getFixedCost();
        if (this.getFixedCostAccrual() == 1) {
            if (l3 >= l && l3 <= l2) {
                d = d2;
            }
        } else if (this.getFixedCostAccrual() == 3) {
            if ((l = Math.max(l, l3)) < (l2 = Math.min(l2, l4))) {
                long l5 = this.getEffectiveWorkCalendar().compare(l2, l, false);
                double d3 = (double)l5 / (double)this.getDurationMillis();
                d = d2 * d3;
            }
        } else if (l4 >= l && l4 <= l2) {
            d = d2;
        }
        return d;
    }

    @Override
    public boolean fieldHideActualFixedCost(FieldContext fieldContext) {
        return false;
    }

    @Override
    public double getActualCost(FieldContext fieldContext) {
        return this.getActualFixedCost(fieldContext) + this.actualCost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getActualWork(FieldContext fieldContext) {
        return this.actualWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getRemainingWork(FieldContext fieldContext) {
        return this.remainingWork(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getRemainingWork() {
        return this.getRemainingWork(null);
    }

    @Override
    public double getRemainingCost(FieldContext fieldContext) {
        return this.getCost(fieldContext) - this.getActualCost(fieldContext);
    }

    @Override
    public double getBaselineCost(int n, FieldContext fieldContext) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n));
        if (taskSnapshot == null) {
            return 0.0;
        }
        return ((TaskSnapshot)this.getSnapshot(new Integer(n))).cost(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public long getBaselineWork(int n, FieldContext fieldContext) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n));
        if (taskSnapshot == null) {
            return 0L;
        }
        return ((TaskSnapshot)this.getSnapshot(new Integer(n))).work(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getAcwp(FieldContext fieldContext) {
        return this.acwp(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBac(FieldContext fieldContext) {
        return this.bac(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBcwp(FieldContext fieldContext) {
        return this.bcwp(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getBcws(FieldContext fieldContext) {
        return this.bcws(FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCv(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cv(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSv(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().sv(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getEac(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().eac(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getVac(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().vac(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cpi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().spi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCsi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().csi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getCvPercent(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().cvPercent(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getSvPercent(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().svPercent(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public double getTcpi(FieldContext fieldContext) {
        return EarnedValueCalculator.getInstance().tcpi(this, FieldContext.start(fieldContext), FieldContext.end(fieldContext));
    }

    @Override
    public void calcDataBetween(Object object, TimeIteratorGenerator timeIteratorGenerator, CalculatedValues calculatedValues) {
        ((TaskSnapshot)this.getCurrentSnapshot()).calcDataBetween(object, timeIteratorGenerator, calculatedValues);
    }

    @Override
    public void setPercentComplete(double d) {
        if (d > 1.0) {
            System.out.println("percent complete more than 100%");
            d = 1.0;
        } else if (d < 0.0) {
            System.out.println("percent complete less than 0%");
            d = 0.0;
        }
        if (this.isZeroDuration()) {
            double d2 = d;
            Iterator iterator = this.getAssignments().iterator();
            while (iterator.hasNext()) {
                ((Assignment)iterator.next()).setPercentComplete(d2);
            }
        } else {
            long l = DateTime.closestDate((double)this.getDurationMillis() * d);
            this.setActualDuration(l);
            long l2 = this.getEffectiveWorkCalendar().add(this.getStart(), l, false);
            DeepChildWalker.recursivelyTreatBranch(this.getProject().getTaskOutline(), this, (Closure)new NumberClosure(l2){

                @Override
                public void execute(Object object) {
                    if (object == null) {
                        return;
                    }
                    Object object2 = ((Node)object).getImpl();
                    if (object2 instanceof NormalTask) {
                        NormalTask normalTask = (NormalTask)object2;
                        normalTask.setStop(Math.min(this.longValue(), normalTask.getEnd()));
                    }
                }
            });
        }
    }

    @Override
    public double getPercentWorkComplete() {
        long l = this.calcSummedWork();
        if (l == 0L) {
            return 0.0;
        }
        return (double)this.calcSummedActualWork() / (double)l;
    }

    private long calcSummedWork() {
        NodeModel nodeModel = this.getProject().getTaskOutline();
        Node node = nodeModel.search(this);
        if (node == null) {
            return 0L;
        }
        Number number = (Number)Configuration.getFieldFromId("Field.work").getValue(node, nodeModel, null);
        return number.longValue();
    }

    private long calcSummedActualWork() {
        NodeModel nodeModel = this.getProject().getTaskOutline();
        Node node = nodeModel.search(this);
        Number number = (Number)Configuration.getFieldFromId("Field.actualWork").getValue(node, nodeModel, null);
        return number.longValue();
    }

    @Override
    public void setPercentWorkComplete(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        double d2 = d * (double)this.calcSummedWork();
        long l = ReverseQuery.getDateAtValue(WORK, this, d2, true);
        DeepChildWalker.recursivelyTreatBranch(this.getProject().getTaskOutline(), this, (Closure)new NumberClosure(l){

            @Override
            public void execute(Object object) {
                if (object == null) {
                    return;
                }
                Object object2 = ((Node)object).getImpl();
                if (object2 instanceof NormalTask) {
                    ((NormalTask)object2).setStopNoExtend(this.getLongValue());
                }
            }
        });
    }

    @Override
    void cleanUp(Object object, boolean bl, boolean bl2, boolean bl3) {
        super.cleanUp(object, bl, bl2, bl3);
        if (bl) {
            for (int i = 0; i < Settings.numBaselines(); ++i) {
                Integer n = new Integer(i);
                TaskSnapshot taskSnapshot = (TaskSnapshot)this.getSnapshot(n);
                if (taskSnapshot == null) continue;
                Object object2 = this.getCurrentSnapshot() == taskSnapshot ? object : null;
                LinkedList linkedList = new LinkedList();
                AssignmentService.getInstance().remove((Collection)taskSnapshot.getAssignments(), linkedList);
                AssignmentService.getInstance().remove(linkedList, object2, false);
                if (taskSnapshot == this.getCurrentSnapshot()) continue;
                this.getProject().fireBaselineChanged(object, this, n, false);
            }
        }
    }

    @Override
    public Collection childrenToRollup() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getHasAssignments().childrenToRollup();
    }

    public double getCost() {
        return this.getCost(null);
    }

    public double getBaselineCost() {
        return this.getBaselineCost(0, null);
    }

    public double getBaselineCost(int n) {
        return this.getBaselineCost(n, null);
    }

    public double getWork() {
        return this.getWork(null);
    }

    public double getBaselineWork() {
        return this.getBaselineWork(0, null);
    }

    public double getBaselineWork(int n) {
        return this.getBaselineWork(n, null);
    }

    @Override
    public long getTotalSlackStart() {
        return this.getConstraintType() == 1 ? this.getEarlyStart() : this.getEarlyFinish();
    }

    @Override
    public long getTotalSlackEnd() {
        return this.getConstraintType() == 1 ? this.getLateStart() : this.getLateFinish();
    }

    @Override
    public long calcOffsetFrom(long l, long l2, boolean bl, boolean bl2, boolean bl3) {
        long l3;
        if (this.isWbsParent()) {
            long l4;
            long l5 = l4 = bl2 ? Duration.millis(this.getRemainingDuration()) : this.getDurationMillis();
            if (!bl) {
                l4 = -l4;
            }
            return this.getEffectiveWorkCalendar().add(l, l4, bl3);
        }
        Iterator iterator = this.getAssignments().iterator();
        if (l < 0L) {
            l3 = bl ? Long.MIN_VALUE : 0L;
        } else {
            long l6 = l3 = bl ? 0L : Long.MAX_VALUE;
        }
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            long l7 = assignment.calcOffsetFrom(l, l2, bl, bl2, bl3);
            l3 = bl ? Math.max(l3, l7) : Math.min(l3, l7);
        }
        return l3;
    }

    @Override
    public long calcActiveAssignmentDuration(WorkCalendar workCalendar) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).calcActiveAssignmentDuration(workCalendar);
    }

    @Override
    public void moveRemainingToDate(long l) {
        l = this.getEffectiveWorkCalendar().adjustInsideCalendar(l, false);
        if (this.getActualStart() == 0L) {
            this.setStart(l);
        } else if (this.inProgress()) {
            for (Assignment assignment : this.getAssignments()) {
                assignment.moveRemainingToDate(l);
            }
        }
    }

    @Override
    public void moveInterval(Object object, long l, long l2, ScheduleInterval scheduleInterval, boolean bl) {
        WorkCalendar workCalendar = this.getEffectiveWorkCalendar();
        boolean bl2 = workCalendar.compare(l = workCalendar.adjustInsideCalendar(l, false), scheduleInterval.getStart(), false) != 0L;
        long l3 = this.getEarliestAssignmentStart();
        long l4 = workCalendar.compare(scheduleInterval.getStart(), l3, false);
        if (bl2 && l4 == 0L) {
            long l5 = workCalendar.compare(l, l3, false);
            long l6 = workCalendar.add(this.getStart(), l5, false);
            this.setStart(l6);
        } else {
            long l7 = workCalendar.compare(l2, scheduleInterval.getEnd(), false);
            if (l7 == 0L) {
                return;
            }
            for (Assignment assignment : this.getAssignments()) {
                assignment.moveInterval(object, l, l2, scheduleInterval, true);
            }
        }
        this.setRawDuration(this.getDurationMillis());
        this.recalculate(object);
        this.assignParentActualDatesFromChildren();
    }

    @Override
    public void split(Object object, long l, long l2) {
        l = this.getEffectiveWorkCalendar().adjustInsideCalendar(l, false);
        if (l == (l2 = this.getEffectiveWorkCalendar().adjustInsideCalendar(l2, false))) {
            l2 = this.getEffectiveWorkCalendar().add(l, CalendarOption.getInstance().getMillisPerDay(), false);
        }
        for (Assignment assignment : this.getAssignments()) {
            assignment.split(object, l, l2);
        }
        this.recalculate(object);
        this.assignParentActualDatesFromChildren();
    }

    @Override
    public void consumeIntervals(IntervalConsumer intervalConsumer) {
        if (this.isWbsParent() || this.isSubproject()) {
            intervalConsumer.consumeInterval(new ScheduleInterval(this.getStart(), this.getEnd()));
            return;
        }
        barClosureInstance.initialize(intervalConsumer, this);
        this.forEachWorkingInterval(barClosureInstance, true, this.getEffectiveWorkCalendar());
        if (barClosureInstance.getCount() == 0L) {
            intervalConsumer.consumeInterval(new ScheduleInterval(this.getStart(), this.getEnd()));
        }
    }

    @Override
    public void setEnd(long l) {
        long l2;
        long l3 = this.getStart();
        if (l3 == 0L) {
            l3 = CalendarOption.getInstance().makeValidStart(DateTime.midnightToday(), true);
            this.getCurrentSchedule().setStart(l3);
        }
        if ((l = CalendarOption.getInstance().makeValidEnd(l, true)) < l3) {
            l = l3;
        }
        if (l != (l2 = this.getEnd())) {
            super.setEnd(l);
            for (Assignment assignment : this.getAssignments()) {
                assignment.setEnd(l);
            }
            this.setRawDuration(this.getDurationMillis());
        }
        this.assignParentActualDatesFromChildren();
    }

    @Override
    public void setActualStart(long l) {
        l = this.getEffectiveWorkCalendar().adjustInsideCalendar(l, false);
        this.setActualStartNoEvent(l);
        this.markTaskAsNeedingRecalculation();
        this.getProject().fireScheduleChanged(this, ScheduleEvent.ACTUAL, this);
    }

    public void setActualStartNoEvent(long l) {
        long l2 = this.getActualStart();
        if (l == l2) {
            return;
        }
        this.actualStart = l;
        this.assignParentActualDatesFromChildren();
    }

    @Override
    public boolean isIgnoreResourceCalendar() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).isIgnoreResourceCalendar();
    }

    @Override
    public void setIgnoreResourceCalendar(boolean bl) {
        ((TaskSnapshot)this.getCurrentSnapshot()).setIgnoreResourceCalendar(bl);
    }

    public boolean isDefault() {
        return this == UNASSIGNED;
    }

    public short getVersion() {
        return this.version;
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.hasKey.serialize(objectOutputStream);
        this.customFields.serialize(objectOutputStream);
        if (this.version < 1) {
            this.currentSchedule.serialize(objectOutputStream);
        } else {
            TaskSnapshot taskSnapshot;
            int n;
            int n2 = 0;
            for (n = 0; n < Settings.numBaselines(); ++n) {
                taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n));
                if (taskSnapshot == null) continue;
                ++n2;
            }
            objectOutputStream.writeInt(n2);
            for (n = 0; n < Settings.numBaselines(); ++n) {
                taskSnapshot = (TaskSnapshot)this.getSnapshot(new Integer(n));
                if (taskSnapshot == null) continue;
                objectOutputStream.writeInt(n);
                taskSnapshot.serialize(objectOutputStream);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.doWriteObject(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hasKey = HasKeyImpl.deserialize(objectInputStream, this);
        this.customFields = CustomFieldsImpl.deserialize(objectInputStream);
        if (this.version < 1) {
            this.currentSchedule = TaskSchedule.deserialize(objectInputStream);
        } else {
            this.snapshots = new SnapshottableImpl(Settings.numBaselines());
            int n = objectInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                int n2 = objectInputStream.readInt();
                TaskSnapshot taskSnapshot = TaskSnapshot.deserialize(objectInputStream, this);
                this.setSnapshot(new Integer(n2), taskSnapshot);
            }
        }
        if (this.version < 1) {
            super.initializeTransientTaskObjects();
        } else {
            super.initializeTransientTaskObjectsAfterDeserialization();
        }
        this.version = DEFAULT_VERSION;
    }

    @Override
    public Object clone() {
        Task task = (Task)super.clone();
        return task;
    }

    @Override
    public void cloneTo(Task task) {
        if (task instanceof NormalTask) {
            NormalTask normalTask = (NormalTask)task;
            normalTask.estimated = this.estimated;
            normalTask.priority = this.priority;
            normalTask.version = this.version;
            normalTask.workCalendar = this.workCalendar;
        }
        super.cloneTo(task);
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
    }

    @Override
    public boolean isReadOnlyWork(FieldContext fieldContext) {
        if (!this.hasLaborAssignment()) {
            return true;
        }
        if (fieldContext == null) {
            return false;
        }
        return !this.hasActiveAssignment(fieldContext.getStart(), fieldContext.getEnd());
    }

    @Override
    public void setActualWork(long l, FieldContext fieldContext) {
        if (FieldContext.hasInterval(fieldContext)) {
            for (Assignment assignment : this.getAssignments()) {
                assignment.setActualWork(l, fieldContext);
            }
        } else {
            long l2 = Duration.millis(l);
            if (l2 == 0L) {
                this.setPercentComplete(0.0);
            } else {
                long l3 = ReverseQuery.getDateAtValue(WORK, this, l2, false);
                this.setStop(l3);
            }
        }
    }

    @Override
    public boolean isReadOnlyActualWork(FieldContext fieldContext) {
        return false;
    }

    @Override
    public void setRemainingWork(long l, FieldContext fieldContext) {
        this.setActualWork(this.getWork(fieldContext) - Duration.millis(l), fieldContext);
    }

    @Override
    public boolean isReadOnlyRemainingWork(FieldContext fieldContext) {
        return this.isReadOnlyWork(fieldContext);
    }

    @Override
    public void setFixedCost(double d, FieldContext fieldContext) {
        if (!FieldContext.hasInterval(fieldContext)) {
            this.setFixedCost(d);
        }
    }

    @Override
    public boolean isReadOnlyFixedCost(FieldContext fieldContext) {
        return FieldContext.hasInterval(fieldContext);
    }

    @Override
    public boolean isLabor() {
        return true;
    }

    @Override
    public boolean hasLaborAssignment() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).hasLaborAssignment();
    }

    @Override
    public void setRawDuration(long l) {
        this.currentSchedule.setRawDuration(l);
    }

    public void setParentDuration() {
        if (!this.isWbsParent()) {
            return;
        }
        this.currentSchedule.assignDatesFromChildren(null);
        long l = this.getDurationMillis();
        this.getSchedulingRule().adjustRemainingDuration(this, l - Duration.millis(this.getActualDuration()), true);
    }

    @Override
    public void invalidateAssignmentCalendars() {
        ((TaskSnapshot)this.getCurrentSnapshot()).invalidateAssignmentCalendars();
    }

    @Override
    public Document invalidateCalendar() {
        this.invalidateAssignmentCalendars();
        this.markTaskAsNeedingRecalculation();
        return this.getProject();
    }

    @Override
    public boolean hasActiveAssignment(long l, long l2) {
        return ((TaskSnapshot)this.getCurrentSnapshot()).hasActiveAssignment(l, l2);
    }

    @Override
    public boolean isInvalidIntersectionCalendar() {
        Iterator iterator = this.getAssignments().iterator();
        while (iterator.hasNext()) {
            if (!((Assignment)iterator.next()).isInvalidIntersectionCalendar()) continue;
            return true;
        }
        return false;
    }

    @Override
    public HasIndicators getIndicators() {
        return this;
    }

    @Override
    public long getEarliestAssignmentStart() {
        return ((TaskSnapshot)this.getCurrentSnapshot()).getEarliestAssignmentStart();
    }

    @Override
    public boolean isParentWithAssignments() {
        return this.isWbsParent() && this.hasRealAssignments();
    }

    @Override
    public void setComplete(boolean bl) {
        ScheduleUtil.setComplete(this, bl);
    }

    @Override
    public boolean applyTimesheet(Collection collection, long l) {
        return TimesheetHelper.applyTimesheet(this.getAssignments(), collection, l);
    }

    @Override
    public long getLastTimesheetUpdate() {
        return TimesheetHelper.getLastTimesheetUpdate(this.getAssignments());
    }

    @Override
    public boolean isPendingTimesheetUpdate() {
        return TimesheetHelper.isPendingTimesheetUpdate(this.getAssignments());
    }

    @Override
    public int getTimesheetStatus() {
        return TimesheetHelper.getTimesheetStatus(this.getAssignments());
    }

    @Override
    public String getTimesheetStatusName() {
        return TimesheetHelper.getTimesheetStatusName(this.getTimesheetStatus());
    }

    @Override
    public final long getEarliestStop() {
        long l = Long.MAX_VALUE;
        if (this.isWbsParent()) {
            Collection collection = this.getWbsChildrenNodes();
            for (Object e : collection) {
                Object object;
                if (!(e instanceof Node) || !((object = ((Node)e).getImpl()) instanceof Schedule)) continue;
                Schedule schedule = (Schedule)object;
                l = Math.min(l, schedule.getEarliestStop());
            }
        } else {
            for (Assignment assignment : this.getAssignments()) {
                l = Math.min(l, assignment.getEarliestStop());
            }
        }
        return l;
    }

    @Override
    public void setCompletedThrough(long l) {
        l = DateTime.closestDate(l);
        if ((l = Math.min(l, this.getEnd())) == this.getCompletedThrough()) {
            return;
        }
        Iterator iterator = this.getAssignments().iterator();
        long l2 = Long.MAX_VALUE;
        while (iterator.hasNext()) {
            Assignment assignment = (Assignment)iterator.next();
            assignment.setCompletedThrough(l);
            long l3 = assignment.getActualStart();
            if (l3 == 0L || l3 >= l2) continue;
            l2 = l3;
        }
        if (l2 == Long.MAX_VALUE) {
            l2 = 0L;
        }
        this.setActualStart(l2);
        this.assignParentActualDatesFromChildren();
        if (l2 == 0L) {
            this.getDocument().getObjectEventManager().fireUpdateEvent((Object)this, (Object)this, Configuration.getFieldFromId("Field.start"));
        } else {
            this.getProject().fireScheduleChanged(this, ScheduleEvent.ACTUAL, this);
        }
    }

    @Override
    public long getFinishOffset() {
        return EarnedValueCalculator.getInstance().getFinishOffset(this);
    }

    @Override
    public long getStartOffset() {
        return EarnedValueCalculator.getInstance().getStartOffset(this);
    }

    public ImageLink getBudgetStatusIndicator() {
        return EarnedValueCalculator.getInstance().getBudgetStatusIndicator(this.getCpi(null));
    }

    public ImageLink getScheduleStatusIndicator() {
        return EarnedValueCalculator.getInstance().getBudgetStatusIndicator(this.getSpi(null));
    }

    @Override
    public Object backupDetail() {
        return this.backupDetail(null);
    }

    public Object backupDetail(Object object) {
        TaskSnapshot taskSnapshot = (TaskSnapshot)(object == null ? this.getCurrentSnapshot() : this.getSnapshot(object));
        TaskSnapshotBackup taskSnapshotBackup = TaskSnapshotBackup.backup(taskSnapshot, true);
        TaskBackup taskBackup = new TaskBackup();
        taskBackup.snapshot = taskSnapshotBackup;
        taskBackup.windowEarlyFinish = this.windowEarlyFinish;
        taskBackup.windowEarlyStart = this.windowEarlyStart;
        taskBackup.windowLateFinish = this.windowLateFinish;
        taskBackup.windowLateStart = this.windowLateStart;
        taskBackup.actualStart = this.actualStart;
        return taskBackup;
    }

    @Override
    public void restoreDetail(Object object, Object object2, boolean bl) {
        this.restoreDetail(object, object2, bl, (TaskSnapshot)this.getCurrentSnapshot());
    }

    public void restoreDetail(Object object, Object object2, boolean bl, TaskSnapshot taskSnapshot) {
        TaskBackup taskBackup = (TaskBackup)object2;
        this.windowEarlyFinish = taskBackup.windowEarlyFinish;
        this.windowEarlyStart = taskBackup.windowEarlyStart;
        this.windowLateFinish = taskBackup.windowLateFinish;
        this.windowLateStart = taskBackup.windowLateStart;
        this.actualStart = taskBackup.actualStart;
        TaskSnapshotBackup.restore(taskSnapshot, taskBackup.snapshot);
        if (!bl) {
            this.recalculate(object);
        }
    }

    @Override
    public boolean renumber(final boolean bl) {
        ResultClosure resultClosure = new ResultClosure(this){

            @Override
            public void execute(Object object) {
                this.result |= ((Assignment)object).renumber(bl);
            }
        };
        boolean bl2 = resultClosure.result;
        this.forSnapshotsAssignments((Closure)resultClosure, true);
        return bl2 | this.hasKey.renumber(bl);
    }

    @Override
    public boolean isLocal() {
        return this.hasKey.isLocal();
    }

    @Override
    public void setLocal(boolean bl) {
        this.hasKey.setLocal(bl);
    }

    public boolean isSlipped() {
        long l = this.getBaselineFinish();
        return l != 0L && this.getEnd() > l;
    }

    public void setTaskAssignementAndPredsDirty() {
        this.setDirty(true);
        Iterator iterator = this.getAssignments().iterator();
        while (iterator.hasNext()) {
            ((Assignment)iterator.next()).setDirty(true);
        }
        Iterator iterator2 = this.getDependencyList(true).iterator();
        while (iterator2.hasNext()) {
            ((Dependency)iterator2.next()).setDirty(false);
        }
    }

    public void setCurrentScheduleStart(long l) {
        this.getCurrentSchedule().setStart(l);
    }

    public void setCurrentScheduleFinish(long l) {
        this.getCurrentSchedule().setFinish(l);
    }

    private static abstract class ResultClosure
    implements Closure {
        boolean result = false;

        private ResultClosure() {
        }
    }
}

