/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.exchange;

import com.projectlibre.core.hierarchy.Hierarchy;
import com.projectlibre.core.hierarchy.HierarchyNode;
import com.projectlibre.core.nodes.Node;
import com.projectlibre.core.pm.exchange.MspImporter;
import com.projectlibre.core.pm.exchange.ProjectConverter;
import com.projectlibre.core.pm.exchange.converters.op.OpAssignmentConverter;
import com.projectlibre.core.pm.exchange.converters.op.OpDependencyConverter;
import com.projectlibre.core.pm.exchange.converters.op.OpImportState;
import com.projectlibre.core.pm.exchange.converters.op.OpProjectConverter;
import com.projectlibre.core.pm.exchange.converters.op.OpResourceConverter;
import com.projectlibre.core.pm.exchange.converters.op.OpTaskConverter;
import com.projectlibre.pm.calendar.CalendarOptions;
import com.projectlibre.pm.calendar.WorkCalendar;
import com.projectlibre.pm.scheduling.ScheduleFrom;
import com.projectlibre.pm.tasks.Dependency;
import com.projectlibre.pm.tasks.Project;
import com.projectlibre.pm.tasks.SnapshotList;
import com.projectlibre.pm.tasks.Task;
import com.projectlibre.pm.tasks.TaskSnapshot;
import com.projectlibre1.configuration.CircularDependencyException;
import com.projectlibre1.contrib.util.Log;
import com.projectlibre1.contrib.util.LogFactory;
import com.projectlibre1.exchange.Context;
import com.projectlibre1.exchange.ResourceMappingForm;
import com.projectlibre1.exchange.ServerFileImporter;
import com.projectlibre1.grouping.core.NodeFactory;
import com.projectlibre1.job.Job;
import com.projectlibre1.job.JobRunnable;
import com.projectlibre1.options.CalendarOption;
import com.projectlibre1.pm.assignment.Assignment;
import com.projectlibre1.pm.assignment.AssignmentService;
import com.projectlibre1.pm.calendar.CalendarService;
import com.projectlibre1.pm.calendar.WorkingCalendar;
import com.projectlibre1.pm.criticalpath.TaskSchedule;
import com.projectlibre1.pm.resource.Resource;
import com.projectlibre1.pm.resource.ResourceImpl;
import com.projectlibre1.pm.resource.ResourcePool;
import com.projectlibre1.pm.task.NormalTask;
import com.projectlibre1.server.data.EnterpriseResourceData;
import com.projectlibre1.server.data.MSPDISerializer;
import com.projectlibre1.server.data.Serializer;
import com.projectlibre1.session.LocalSession;
import com.projectlibre1.session.Session;
import com.projectlibre1.session.SessionFactory;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.Alert;
import com.projectlibre1.util.DateTime;
import com.projectlibre1.util.Environment;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Closure;

public class MicrosoftImporter
extends ServerFileImporter {
    static Log log = LogFactory.getLog(MicrosoftImporter.class);
    protected Project plProject = null;
    protected OpImportState state = new OpImportState();
    List allTasks = null;
    ArrayList subprojects;
    private Date earliestStart = DateTime.getMaxDate();
    protected HashMap taskMap = new HashMap();
    private HashMap resourceMap = new HashMap();
    List allResources = null;
    public static boolean ADD_SUMMARY_TASK = false;
    private static final String ABORT = "Job aborted";
    private String errorDescription = null;
    private Exception lastException = null;
    private JobRunnable jobRunnable = null;
    protected Context context = new Context();

    public MicrosoftImporter() {
        System.out.println("-------MicrosoftImporter ctor");
    }

    @Override
    public void importFile() throws Exception {
        log.info("BEGIN: MicrosoftImporter.PrepareResources");
        this.parse();
        log.info("END: MicrosoftImporter.PrepareResources");
        Environment.setImporting(false);
        log.info("BEGIN: Finish import");
        this.convertToProjectLibre1();
        log.info("END: Finish import");
    }

    @Override
    public com.projectlibre1.pm.task.Project loadProject(InputStream inputStream) throws Exception {
        log.info("BEGIN: MicrosoftImporter.PrepareResources");
        this.parse(inputStream, "xml");
        log.info("END: MicrosoftImporter.PrepareResources");
        Environment.setImporting(false);
        log.info("BEGIN: Finish import");
        this.convertToProjectLibre1();
        log.info("END: Finish import");
        return this.project;
    }

    @Override
    public boolean saveProject(com.projectlibre1.pm.task.Project project, OutputStream outputStream) throws Exception {
        MSPDISerializer mSPDISerializer = new MSPDISerializer();
        return mSPDISerializer.saveProject(project, outputStream);
    }

    @Override
    public void exportFile() throws Exception {
        MSPDISerializer mSPDISerializer = new MSPDISerializer();
        mSPDISerializer.saveProject(this.project, this.fileName);
    }

    private void setProgress(float f) {
        if (this.jobRunnable == null) {
            log.info("Progress " + 100.0f * f + "%");
        } else {
            this.jobRunnable.setProgress(f);
        }
    }

    public void importProject(com.projectlibre1.pm.task.Project project) throws Exception {
        System.out.println("MicrosoftImporter.importProject()");
        this.project = project;
        this.parse();
        this.convertToProjectLibre1();
    }

    public void parse(InputStream inputStream, String string) throws Exception {
        System.out.println("MicrosoftImporter.parse()");
        Environment.setImporting(true);
        this.setProgress(0.1f);
        MspImporter mspImporter = new MspImporter();
        this.plProject = mspImporter.importProject(inputStream, string, new MspImporter.ProgressClosure(){

            @Override
            public void updateProgress(float f, String string) {
                MicrosoftImporter.this.setProgress(f * 0.1f);
            }
        });
        log.info(this.plProject.toString());
        if (this.plProject == null) {
            String string2;
            String string3 = string2 = this.errorDescription == null ? Messages.getString("Message.ImportError") : this.errorDescription;
            if (this.jobRunnable != null) {
                this.jobRunnable.getJob().error(string2, false);
                this.jobRunnable.getJob().cancel();
            }
            Environment.setImporting(false);
            throw this.lastException == null ? new Exception("Failed to import file") : this.lastException;
        }
        this.setProgress(0.2f);
        this.setProgress(1.0f);
    }

    public void parse() throws Exception {
        System.out.println("MicrosoftImporter.parse()");
        Environment.setImporting(true);
        this.setProgress(0.1f);
        MspImporter mspImporter = new MspImporter();
        this.plProject = this.fileInputStream == null ? mspImporter.importProject(this.fileName, new MspImporter.ProgressClosure(){

            @Override
            public void updateProgress(float f, String string) {
                MicrosoftImporter.this.setProgress(f * 0.1f);
            }
        }) : mspImporter.importProject(this.fileInputStream, "xml", new MspImporter.ProgressClosure(){

            @Override
            public void updateProgress(float f, String string) {
                MicrosoftImporter.this.setProgress(f * 0.1f);
            }
        });
        log.info(this.plProject.toString());
        if (this.plProject == null) {
            String string;
            String string2 = string = this.errorDescription == null ? Messages.getString("Message.ImportError") : this.errorDescription;
            if (this.jobRunnable != null) {
                this.jobRunnable.getJob().error(string, false);
                this.jobRunnable.getJob().cancel();
            }
            Environment.setImporting(false);
            throw this.lastException == null ? new Exception("Failed to import file") : this.lastException;
        }
        this.setProgress(0.2f);
        this.setProgress(1.0f);
    }

    @Override
    public Job getImportFileJob() {
        System.out.println("MicrosoftImporter.getImportFileJob()");
        this.subprojects = new ArrayList();
        this.errorDescription = null;
        this.lastException = null;
        Session session = SessionFactory.getInstance().getSession(this.resourceMapping == null);
        Job job = new Job(session.getJobQueue(), "importFile", Messages.getString("MicrosoftImporter.Importing"), true);
        job.addRunnable(new JobRunnable(Messages.getString("MicrosoftImporter.PrepareResources"), 1.0f){

            @Override
            public Object run() throws Exception {
                log.info("BEGIN: MicrosoftImporter.PrepareResources");
                MicrosoftImporter.this.jobRunnable = this;
                MicrosoftImporter.this.parse();
                log.info("END: MicrosoftImporter.PrepareResources");
                return null;
            }
        });
        job.addSwingRunnable(new JobRunnable("Import resources", 1.0f){

            @Override
            public Object run() throws Exception {
                log.info("BEGIN: Import resources");
                ResourceMappingForm resourceMappingForm = MicrosoftImporter.this.getResourceMapping();
                if (resourceMappingForm != null && resourceMappingForm.isLocal() && !this.job.okCancel(Messages.getString("Message.ServerUnreacheableReadOnlyProject"), true)) {
                    this.setProgress(1.0f);
                    MicrosoftImporter.this.errorDescription = MicrosoftImporter.ABORT;
                    Environment.setImporting(false);
                    throw new Exception(MicrosoftImporter.ABORT);
                }
                this.setProgress(1.0f);
                log.info("END: Import resources");
                return null;
            }
        });
        job.addRunnable(new JobRunnable("Finish import", 1.0f){

            @Override
            public Object run() throws Exception {
                log.info("BEGIN: Finish import");
                com.projectlibre1.pm.task.Project project = MicrosoftImporter.this.convertToProjectLibre1();
                log.info("END: Finish import");
                return project;
            }
        });
        return job;
    }

    private com.projectlibre1.pm.task.Project convertToProjectLibre1() throws Exception {
        block5: {
            log.info("import options");
            this.importOptions();
            this.setProgress(0.3f);
            log.info("import calendars");
            this.importCalendars();
            this.setProgress(0.4f);
            log.info("import resources");
            this.importLocalResources();
            this.setProgress(0.5f);
            log.info("import tasks");
            this.importTasks();
            this.setProgress(0.6f);
            log.info("import project fields");
            this.importProjectFields();
            this.setProgress(0.7f);
            log.info("import dependencies");
            this.importDependencies();
            this.setProgress(0.8f);
            log.info("import assignments");
            this.importAssignments();
            this.setProgress(0.9f);
            log.info("about to initialize");
            if (this.project.getName() == null) {
                this.project.setName("error - name not set on import");
            }
            try {
                this.project.initialize(false, false);
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getMessage() != CircularDependencyException.RUNTIME_EXCEPTION_TEXT) break block5;
                Environment.setImporting(false);
                Alert.error(runtimeException.getMessage());
                this.plProject = null;
                this.project = null;
                throw new Exception(runtimeException.getMessage());
            }
        }
        if (!Environment.getStandAlone()) {
            this.project.setAllDirty();
        }
        this.project.setBoundsAfterReadProject();
        if (this.plProject.getPropertyValue("scheduleFrom") == ScheduleFrom.FINISH) {
            this.project.setForward(false);
        }
        Environment.setImporting(false);
        this.setProgress(1.0f);
        this.plProject = null;
        return this.project;
    }

    protected void importCalendars() throws Exception {
        this.state.setCalendarManager(this.plProject.getCalendarManager());
        for (WorkCalendar workCalendar : this.plProject.getCalendarManager()) {
            WorkingCalendar workingCalendar = WorkingCalendar.getStandardBasedInstance();
            ProjectConverter.getInstance().convert("op", ProjectConverter.Type.CALENDAR, false, workingCalendar, workCalendar, this.state);
            if (CalendarService.findBaseCalendar(workingCalendar.getName()) != null) {
                workingCalendar.setName(workingCalendar.getName() + "[Imported]");
            }
            CalendarService.getInstance().add(workingCalendar);
            this.state.mapBaseCalendar(workCalendar, workingCalendar);
        }
    }

    protected void importLocalResources() {
        ResourcePool resourcePool = this.project.getResourcePool();
        this.project.setLocal(true);
        resourcePool.setLocal(true);
        resourcePool.setMaster(false);
        resourcePool.updateOutlineTypes();
        OpResourceConverter opResourceConverter = new OpResourceConverter();
        for (com.projectlibre.pm.resources.Resource resource : this.plProject.getResourcePool().getResources()) {
            ResourceImpl resourceImpl = resourcePool.newResourceInstance();
            opResourceConverter.to(resourceImpl, resource, this.state);
            this.state.mapOpResource(resource, resourceImpl);
            com.projectlibre1.grouping.core.Node node = NodeFactory.getInstance().createNode(resourceImpl);
            resourcePool.addToDefaultOutline(null, node);
            this.state.mapOpResourceNode(resourceImpl, node);
        }
    }

    protected boolean importResources() throws Exception {
        return this.importResources(this.resourceMap, new Closure(){

            @Override
            public void execute(Object object) {
                MicrosoftImporter.this.importLocalResources();
            }
        });
    }

    protected boolean importResources(HashMap hashMap, Closure closure) throws Exception {
        ResourceMappingForm resourceMappingForm = this.getResourceMapping();
        if (resourceMappingForm == null || resourceMappingForm.isLocal()) {
            closure.execute(null);
        } else {
            Object object;
            if (!resourceMappingForm.execute()) {
                return false;
            }
            if (resourceMappingForm.isLocal()) {
                closure.execute(null);
                return true;
            }
            Resource resource = null;
            int n = 0;
            ResourcePool resourcePool = this.project.getResourcePool();
            this.project.setTemporaryLocal(true);
            HashMap<EnterpriseResourceData, Resource> hashMap2 = new HashMap<EnterpriseResourceData, Resource>();
            for (EnterpriseResourceData enterpriseResourceData : resourceMappingForm.getResources()) {
                if (enterpriseResourceData.isLocal()) {
                    resource = ResourceImpl.getUnassignedInstance();
                } else {
                    resource = Serializer.deserializeResourceAndAddToPool(enterpriseResourceData, resourcePool, null);
                    object = NodeFactory.getInstance().createNode(resource);
                    resourcePool.addToDefaultOutline(null, (com.projectlibre1.grouping.core.Node)object, n++, false);
                    ((ResourceImpl)resource).getGlobalResource().setResourcePool(resourcePool);
                }
                hashMap2.put(enterpriseResourceData, resource);
            }
            Iterator iterator = resourceMappingForm.getImportedResources().iterator();
            object = resourceMappingForm.getSelectedResources().iterator();
            while (iterator.hasNext()) {
                EnterpriseResourceData enterpriseResourceData;
                Object e = iterator.next();
                enterpriseResourceData = (EnterpriseResourceData)object.next();
                resource = (Resource)hashMap2.get(enterpriseResourceData);
                this.mapResource(resource.getUniqueId(), resource);
            }
            resourcePool.setMaster(false);
            resourcePool.updateOutlineTypes();
            this.project.setAccessControlPolicy(resourceMappingForm.getAccessControlType());
            this.project.resetRoles(resourceMappingForm.getAccessControlType() == 0);
        }
        return true;
    }

    protected void retrieveResourcesForMerge(List list) throws Exception {
    }

    protected void importOptions() throws Exception {
        ProjectConverter projectConverter = ProjectConverter.getInstance();
        CalendarOption calendarOption = CalendarOption.getInstance();
        CalendarOptions calendarOptions = this.plProject.getCalendarOptions();
        projectConverter.convert("op", ProjectConverter.Type.OPTIONS, false, calendarOption, calendarOptions, this.state);
    }

    private void importProjectFields() {
        OpProjectConverter opProjectConverter = new OpProjectConverter();
        opProjectConverter.to(this.project, this.plProject, this.state);
    }

    private void importTasks() {
        final OpTaskConverter opTaskConverter = new OpTaskConverter();
        this.plProject.getHierarchy().visit(new Hierarchy.Visitor(){
            final /* synthetic */ MicrosoftImporter this$0;
            {
                this.this$0 = microsoftImporter;
            }

            @Override
            public void visit(HierarchyNode hierarchyNode) {
                Node node = hierarchyNode.getNode();
                if (!(node instanceof Task)) {
                    return;
                }
                Task task = (Task)node;
                HierarchyNode hierarchyNode2 = hierarchyNode.getParent();
                Task task2 = null;
                if (!hierarchyNode2.isRoot()) {
                    task2 = (Task)hierarchyNode2.getNode();
                }
                NormalTask normalTask = this.this$0.project.newNormalTaskInstance(false);
                normalTask.setOwningProject(this.this$0.project);
                normalTask.setProjectId(this.this$0.project.getUniqueId());
                opTaskConverter.to(normalTask, task, this.this$0.state);
                com.projectlibre1.grouping.core.Node node2 = NodeFactory.getInstance().createNode(normalTask);
                NormalTask normalTask2 = task2 == null ? null : this.this$0.state.getOpTask(task2);
                com.projectlibre1.grouping.core.Node node3 = normalTask2 == null ? null : this.this$0.state.getOpTaskNode(normalTask2);
                this.this$0.project.addToDefaultOutline(node3, node2);
                SnapshotList snapshotList = task.getSnapshotList();
                for (int i = 0; i < 11; ++i) {
                    TaskSnapshot taskSnapshot = snapshotList.getSnapshot(i);
                    if (taskSnapshot == null || taskSnapshot.getStart() == null || taskSnapshot.getFinish() == null) continue;
                    com.projectlibre1.pm.task.TaskSnapshot taskSnapshot2 = new com.projectlibre1.pm.task.TaskSnapshot();
                    taskSnapshot2.getHasAssignments();
                    TaskSchedule taskSchedule = new TaskSchedule();
                    taskSchedule.setStart(taskSnapshot.getStart().getTime());
                    taskSchedule.setFinish(taskSnapshot.getFinish().getTime());
                    taskSnapshot2.setCurrentSchedule(taskSchedule);
                    normalTask.setSnapshot(i, taskSnapshot2);
                }
                this.this$0.state.mapOpTask(task, normalTask);
                this.this$0.state.mapOpTaskNode(normalTask, node2);
            }
        });
    }

    public void importDependencies() throws Exception {
        CalendarOption calendarOption = CalendarOption.getInstance();
        CalendarOption.setInstance(CalendarOption.getDefaultInstance());
        OpDependencyConverter opDependencyConverter = new OpDependencyConverter();
        for (Dependency dependency : this.plProject.getDependencies()) {
            opDependencyConverter.to(dependency, this.state);
        }
        CalendarOption.setInstance(calendarOption);
    }

    protected void importAssignments() {
        OpAssignmentConverter opAssignmentConverter = new OpAssignmentConverter();
        for (Task task : this.plProject.getTasks()) {
            Object object;
            NormalTask normalTask = this.state.getOpTask(task);
            for (com.projectlibre.pm.tasks.Assignment assignment : task.getAssignments()) {
                object = opAssignmentConverter.to(assignment, this.state);
                AssignmentService.getInstance().connect((Assignment)object, null);
            }
            SnapshotList snapshotList = task.getSnapshotList();
            for (int i = 0; i < 11; ++i) {
                object = snapshotList.getSnapshot(i);
                com.projectlibre1.pm.task.TaskSnapshot taskSnapshot = (com.projectlibre1.pm.task.TaskSnapshot)normalTask.getSnapshot(i);
                if (object == null || taskSnapshot == null) continue;
                for (com.projectlibre.pm.tasks.Assignment assignment : ((TaskSnapshot)object).getAssignments()) {
                    Assignment assignment2 = opAssignmentConverter.to(assignment, this.state);
                    taskSnapshot.addAssignment(assignment2);
                }
            }
        }
    }

    protected double assignmentPercentFactor() {
        return 100.0;
    }

    @Override
    public Job getExportFileJob() {
        LocalSession localSession = SessionFactory.getInstance().getLocalSession();
        Job job = new Job(localSession.getJobQueue(), "exportFile", "Exporting...", true);
        job.addRunnable(new JobRunnable("Local: export", 1.0f){

            @Override
            public Object run() throws Exception {
                MSPDISerializer mSPDISerializer = new MSPDISerializer();
                mSPDISerializer.setJob(this);
                mSPDISerializer.saveProject(MicrosoftImporter.this.project, MicrosoftImporter.this.fileName);
                return null;
            }
        });
        return job;
    }

    protected void makeValidResourceId(Resource resource) {
    }

    protected void mapResource(Number number, Object object) {
        this.resourceMap.put(number, object);
    }

    public HashMap getResourceMap() {
        return this.resourceMap;
    }
}

