/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0l * i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(0l, 0l, 0l)
 * (0l * i64vec3(167l, 66l, 187l)) => i64vec3(0l, 0l, 0l)
 * (3l * i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(-3999999999999999777l, 255l, 282l)
 * (3l * i64vec3(167l, 66l, 187l)) => i64vec3(501l, 198l, 561l)
 * (-1192l * i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(2913342994311805752l, -101320l, -112048l)
 * (-1192l * i64vec3(167l, 66l, 187l)) => i64vec3(-199064l, -78672l, -222904l)
 * (1048576l * i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(-4153242812628860928l, 89128960l, 98566144l)
 * (1048576l * i64vec3(167l, 66l, 187l)) => i64vec3(175112192l, 69206016l, 196083712l)
 * (4251475l * i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(-4219714608934365073l, 361375375l, 399638650l)
 * (4251475l * i64vec3(167l, 66l, 187l)) => i64vec3(709996325l, 280597350l, 795025825l)
 * (29852643761l * i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(6011132269922621541l, 2537474719685l, 2806148513534l)
 * (29852643761l * i64vec3(167l, 66l, 187l)) => i64vec3(4985391508087l, 1970274488226l, 5582444383307l)
 * (-4398046511104l * i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(1536901751351803904l, -373833953443840l, -413416372043776l)
 * (-4398046511104l * i64vec3(167l, 66l, 187l)) => i64vec3(-734473767354368l, -290271069732864l, -822434697576448l)
 * (-3948976685146l * i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(-124467746145524258l, -335663018237410l, -371203808403724l)
 * (-3948976685146l * i64vec3(167l, 66l, 187l)) => i64vec3(-659479106419382l, -260632461219636l, -738458640122302l)
 * (-135763469567146206l * i64vec3(-1333333333333333259l, 85l, 94l)) => i64vec3(-6601818128962017398l, 6906849160502124106l, 5684977934397808252l)
 * (-135763469567146206l * i64vec3(167l, 66l, 187l)) => i64vec3(-4225755344003864786l, -8960388991431649596l, -6941024735346788906l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((0l * i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(0l, 0l, 0l))) ? 1 : -1] array0;
  float[all(equal((0l * i64vec3(167l, 66l, 187l)), i64vec3(0l, 0l, 0l))) ? 1 : -1] array1;
  float[all(equal((3l * i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(-3999999999999999777l, 255l, 282l))) ? 1 : -1] array2;
  float[all(equal((3l * i64vec3(167l, 66l, 187l)), i64vec3(501l, 198l, 561l))) ? 1 : -1] array3;
  float[all(equal((-1192l * i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(2913342994311805752l, -101320l, -112048l))) ? 1 : -1] array4;
  float[all(equal((-1192l * i64vec3(167l, 66l, 187l)), i64vec3(-199064l, -78672l, -222904l))) ? 1 : -1] array5;
  float[all(equal((1048576l * i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(-4153242812628860928l, 89128960l, 98566144l))) ? 1 : -1] array6;
  float[all(equal((1048576l * i64vec3(167l, 66l, 187l)), i64vec3(175112192l, 69206016l, 196083712l))) ? 1 : -1] array7;
  float[all(equal((4251475l * i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(-4219714608934365073l, 361375375l, 399638650l))) ? 1 : -1] array8;
  float[all(equal((4251475l * i64vec3(167l, 66l, 187l)), i64vec3(709996325l, 280597350l, 795025825l))) ? 1 : -1] array9;
  float[all(equal((29852643761l * i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(6011132269922621541l, 2537474719685l, 2806148513534l))) ? 1 : -1] array10;
  float[all(equal((29852643761l * i64vec3(167l, 66l, 187l)), i64vec3(4985391508087l, 1970274488226l, 5582444383307l))) ? 1 : -1] array11;
  float[all(equal((-4398046511104l * i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(1536901751351803904l, -373833953443840l, -413416372043776l))) ? 1 : -1] array12;
  float[all(equal((-4398046511104l * i64vec3(167l, 66l, 187l)), i64vec3(-734473767354368l, -290271069732864l, -822434697576448l))) ? 1 : -1] array13;
  float[all(equal((-3948976685146l * i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(-124467746145524258l, -335663018237410l, -371203808403724l))) ? 1 : -1] array14;
  float[all(equal((-3948976685146l * i64vec3(167l, 66l, 187l)), i64vec3(-659479106419382l, -260632461219636l, -738458640122302l))) ? 1 : -1] array15;
  float[all(equal((-135763469567146206l * i64vec3(-1333333333333333259l, 85l, 94l)), i64vec3(-6601818128962017398l, 6906849160502124106l, 5684977934397808252l))) ? 1 : -1] array16;
  float[all(equal((-135763469567146206l * i64vec3(167l, 66l, 187l)), i64vec3(-4225755344003864786l, -8960388991431649596l, -6941024735346788906l))) ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
