/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * reflect(dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf), dvec4(-0.5564077658364623lf, 0.44849838094696665lf, 0.6508284776147711lf, 0.25628478911255237lf)) => dvec4(1.65lf, -1.33lf, -1.93lf, -0.76lf)
 * reflect(dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf), dvec4(0.8328815886623452lf, -0.1561652978741897lf, -0.530962012772245lf, 0.0lf)) => dvec4(2.6921634511164094lf, 0.5158443529156734lf, -0.8381292000867109lf, 0.76lf)
 * reflect(dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf), dvec4(-0.5564077658364623lf, 0.44849838094696665lf, 0.6508284776147711lf, 0.25628478911255237lf)) => dvec4(-0.13957629720601772lf, 0.6073554395660627lf, 0.5890195476409783lf, 0.43277453689489304lf)
 * reflect(dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf), dvec4(0.8328815886623452lf, -0.1561652978741897lf, -0.530962012772245lf, 0.0lf)) => dvec4(-0.8lf, 0.15lf, 0.51lf, 0.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(reflect(dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf), dvec4(-0.5564077658364623lf, 0.44849838094696665lf, 0.6508284776147711lf, 0.25628478911255237lf)), dvec4(1.65lf, -1.33lf, -1.93lf, -0.76lf)) <= 2.9654510618116767e-05lf ? 1 : -1] array0;
  double[distance(reflect(dvec4(-1.65lf, 1.33lf, 1.93lf, 0.76lf), dvec4(0.8328815886623452lf, -0.1561652978741897lf, -0.530962012772245lf, 0.0lf)), dvec4(2.6921634511164094lf, 0.5158443529156734lf, -0.8381292000867109lf, 0.76lf)) <= 2.965451061811676e-05lf ? 1 : -1] array1;
  double[distance(reflect(dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf), dvec4(-0.5564077658364623lf, 0.44849838094696665lf, 0.6508284776147711lf, 0.25628478911255237lf)), dvec4(-0.13957629720601772lf, 0.6073554395660627lf, 0.5890195476409783lf, 0.43277453689489304lf)) <= 9.605206921248494e-06lf ? 1 : -1] array2;
  double[distance(reflect(dvec4(0.8lf, -0.15lf, -0.51lf, 0.0lf), dvec4(0.8328815886623452lf, -0.1561652978741897lf, -0.530962012772245lf, 0.0lf)), dvec4(-0.8lf, 0.15lf, 0.51lf, 0.0lf)) <= 9.605206921248497e-06lf ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
