/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.binding.xml.DeviceDescriptorBinder;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.binding.xml.UDA10DeviceDescriptorBinderImpl;
import org.jupnp.binding.xml.UDA10ServiceDescriptorBinderImpl;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.Namespace;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.types.ServiceType;
import org.jupnp.transport.TransportConfiguration;
import org.jupnp.transport.TransportConfigurationProvider;
import org.jupnp.transport.impl.DatagramIOConfigurationImpl;
import org.jupnp.transport.impl.DatagramIOImpl;
import org.jupnp.transport.impl.DatagramProcessorImpl;
import org.jupnp.transport.impl.GENAEventProcessorImpl;
import org.jupnp.transport.impl.MulticastReceiverConfigurationImpl;
import org.jupnp.transport.impl.MulticastReceiverImpl;
import org.jupnp.transport.impl.NetworkAddressFactoryImpl;
import org.jupnp.transport.impl.SOAPActionProcessorImpl;
import org.jupnp.transport.impl.jetty.StreamClientConfigurationImpl;
import org.jupnp.transport.spi.DatagramIO;
import org.jupnp.transport.spi.DatagramProcessor;
import org.jupnp.transport.spi.GENAEventProcessor;
import org.jupnp.transport.spi.MulticastReceiver;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.SOAPActionProcessor;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamClientConfiguration;
import org.jupnp.transport.spi.StreamServer;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpnpServiceConfiguration
implements UpnpServiceConfiguration {
    private final Logger logger = LoggerFactory.getLogger(DefaultUpnpServiceConfiguration.class);
    private static final int CORE_THREAD_POOL_SIZE = 16;
    private static final int THREAD_POOL_SIZE = 200;
    private static final int THREAD_QUEUE_SIZE = 1000;
    private static final boolean THREAD_POOL_CORE_TIMEOUT = true;
    private final int streamListenPort;
    private final int multicastResponsePort;
    private final ExecutorService defaultExecutorService;
    private final DatagramProcessor datagramProcessor;
    private final SOAPActionProcessor soapActionProcessor;
    private final GENAEventProcessor genaEventProcessor;
    private final DeviceDescriptorBinder deviceDescriptorBinderUDA10;
    private final ServiceDescriptorBinder serviceDescriptorBinderUDA10;
    private final Namespace namespace;
    private StreamClientConfiguration configuration;
    private final TransportConfiguration transportConfiguration;

    public DefaultUpnpServiceConfiguration() {
        this(0);
    }

    public DefaultUpnpServiceConfiguration(int streamListenPort) {
        this(streamListenPort, 0, true);
    }

    public DefaultUpnpServiceConfiguration(int streamListenPort, int multicastResponsePort) {
        this(streamListenPort, multicastResponsePort, true);
    }

    protected DefaultUpnpServiceConfiguration(boolean checkRuntime) {
        this(0, 0, checkRuntime);
    }

    protected DefaultUpnpServiceConfiguration(int streamListenPort, int multicastResponsePort, boolean checkRuntime) {
        if (checkRuntime && ModelUtil.ANDROID_RUNTIME) {
            throw new Error("Unsupported runtime environment, use org.jupnp.android.AndroidUpnpServiceConfiguration");
        }
        this.streamListenPort = streamListenPort;
        this.multicastResponsePort = multicastResponsePort;
        this.defaultExecutorService = this.createDefaultExecutorService();
        this.datagramProcessor = this.createDatagramProcessor();
        this.soapActionProcessor = this.createSOAPActionProcessor();
        this.genaEventProcessor = this.createGENAEventProcessor();
        this.deviceDescriptorBinderUDA10 = this.createDeviceDescriptorBinderUDA10();
        this.serviceDescriptorBinderUDA10 = this.createServiceDescriptorBinderUDA10();
        this.namespace = this.createNamespace();
        this.configuration = new StreamClientConfigurationImpl(this.defaultExecutorService);
        this.transportConfiguration = TransportConfigurationProvider.getDefaultTransportConfiguration();
    }

    @Override
    public DatagramProcessor getDatagramProcessor() {
        return this.datagramProcessor;
    }

    @Override
    public SOAPActionProcessor getSoapActionProcessor() {
        return this.soapActionProcessor;
    }

    @Override
    public GENAEventProcessor getGenaEventProcessor() {
        return this.genaEventProcessor;
    }

    @Override
    public StreamClient createStreamClient() {
        return this.transportConfiguration.createStreamClient(this.getSyncProtocolExecutorService(), this.configuration);
    }

    @Override
    public StreamServer createStreamServer(NetworkAddressFactory networkAddressFactory) {
        return this.transportConfiguration.createStreamServer(networkAddressFactory.getStreamListenPort());
    }

    @Override
    public MulticastReceiver createMulticastReceiver(NetworkAddressFactory networkAddressFactory) {
        return new MulticastReceiverImpl(new MulticastReceiverConfigurationImpl(networkAddressFactory.getMulticastGroup(), networkAddressFactory.getMulticastPort()));
    }

    @Override
    public DatagramIO createDatagramIO(NetworkAddressFactory networkAddressFactory) {
        return new DatagramIOImpl(new DatagramIOConfigurationImpl());
    }

    @Override
    public ExecutorService getMulticastReceiverExecutor() {
        return this.getDefaultExecutorService();
    }

    @Override
    public ExecutorService getDatagramIOExecutor() {
        return this.getDefaultExecutorService();
    }

    @Override
    public ExecutorService getStreamServerExecutorService() {
        return this.getDefaultExecutorService();
    }

    @Override
    public DeviceDescriptorBinder getDeviceDescriptorBinderUDA10() {
        return this.deviceDescriptorBinderUDA10;
    }

    @Override
    public ServiceDescriptorBinder getServiceDescriptorBinderUDA10() {
        return this.serviceDescriptorBinderUDA10;
    }

    @Override
    public ServiceType[] getExclusiveServiceTypes() {
        return new ServiceType[0];
    }

    @Override
    public boolean isReceivedSubscriptionTimeoutIgnored() {
        return false;
    }

    @Override
    public UpnpHeaders getDescriptorRetrievalHeaders(RemoteDeviceIdentity identity) {
        return null;
    }

    @Override
    public UpnpHeaders getEventSubscriptionHeaders(RemoteService service) {
        return null;
    }

    @Override
    public int getRegistryMaintenanceIntervalMillis() {
        return 1000;
    }

    @Override
    public int getAliveIntervalMillis() {
        return 0;
    }

    @Override
    public Integer getRemoteDeviceMaxAgeSeconds() {
        return null;
    }

    @Override
    public ExecutorService getAsyncProtocolExecutor() {
        return this.getDefaultExecutorService();
    }

    @Override
    public ExecutorService getSyncProtocolExecutorService() {
        return this.getDefaultExecutorService();
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Executor getRegistryMaintainerExecutor() {
        return this.getDefaultExecutorService();
    }

    @Override
    public Executor getRegistryListenerExecutor() {
        return this.getDefaultExecutorService();
    }

    @Override
    public Executor getRemoteListenerExecutor() {
        return this.getDefaultExecutorService();
    }

    @Override
    public NetworkAddressFactory createNetworkAddressFactory() {
        return this.createNetworkAddressFactory(this.streamListenPort, this.multicastResponsePort);
    }

    @Override
    public void shutdown() {
        this.logger.trace("Shutting down default executor service");
        this.getDefaultExecutorService().shutdownNow();
    }

    protected NetworkAddressFactory createNetworkAddressFactory(int streamListenPort, int multicastResponsePort) {
        return new NetworkAddressFactoryImpl(streamListenPort, multicastResponsePort);
    }

    protected DatagramProcessor createDatagramProcessor() {
        return new DatagramProcessorImpl();
    }

    protected SOAPActionProcessor createSOAPActionProcessor() {
        return new SOAPActionProcessorImpl();
    }

    protected GENAEventProcessor createGENAEventProcessor() {
        return new GENAEventProcessorImpl();
    }

    protected DeviceDescriptorBinder createDeviceDescriptorBinderUDA10() {
        return new UDA10DeviceDescriptorBinderImpl();
    }

    protected ServiceDescriptorBinder createServiceDescriptorBinderUDA10() {
        return new UDA10ServiceDescriptorBinderImpl();
    }

    protected Namespace createNamespace() {
        return new Namespace();
    }

    protected ExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }

    protected ExecutorService createDefaultExecutorService() {
        return new JUPnPExecutor();
    }

    public static class JUPnPExecutor
    extends ThreadPoolExecutor {
        public JUPnPExecutor() {
            this(new JUPnPThreadFactory(), new ThreadPoolExecutor.DiscardPolicy(){

                @Override
                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                    LoggerFactory.getLogger(DefaultUpnpServiceConfiguration.class).warn("Thread pool rejected execution of {}", runnable.getClass());
                    super.rejectedExecution(runnable, threadPoolExecutor);
                }
            });
        }

        public JUPnPExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedHandler) {
            super(16, 200, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), threadFactory, rejectedHandler);
            this.allowCoreThreadTimeOut(true);
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            super.afterExecute(runnable, throwable);
            if (throwable != null) {
                Throwable cause = Exceptions.unwrap(throwable);
                if (cause instanceof InterruptedException) {
                    return;
                }
                LoggerFactory.getLogger(DefaultUpnpServiceConfiguration.class).warn("Thread terminated {} abruptly", (Object)runnable, (Object)throwable);
            }
        }
    }

    public static class JUPnPThreadFactory
    implements ThreadFactory {
        protected final ThreadGroup group;
        protected final AtomicInteger threadNumber = new AtomicInteger(1);
        protected final String namePrefix = "jupnp-";

        public JUPnPThreadFactory() {
            this.group = Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "jupnp-" + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

