/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.refactoring;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.providers.spi.HintMetadata;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchSearch;
import org.netbeans.modules.java.hints.spiimpl.batch.Scopes;
import org.netbeans.modules.java.hints.spiimpl.options.HintsPanel;
import org.netbeans.modules.java.hints.spiimpl.options.HintsPanelLogic;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Configuration;
import org.netbeans.modules.java.hints.spiimpl.refactoring.ConfigurationRenderer;
import org.netbeans.modules.java.hints.spiimpl.refactoring.ConfigurationsComboModel;
import org.netbeans.modules.java.hints.spiimpl.refactoring.InspectAndRefactorUI;
import org.netbeans.modules.java.hints.spiimpl.refactoring.InspectionComboModel;
import org.netbeans.modules.java.hints.spiimpl.refactoring.InspectionRenderer;
import org.netbeans.modules.java.hints.spiimpl.refactoring.Utilities;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.java.api.ui.JavaScopeBuilder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Union2;

public class InspectAndRefactorPanel
extends JPanel
implements PopupMenuListener {
    private static final String PACKAGE = "org/netbeans/spi/java/project/support/ui/package.gif";
    private FileObject fileObject;
    private final Lookup context;
    private final InspectAndRefactorUI.HintWrap hintWrap;
    private final HintMetadata preselect;
    private final Utilities.ClassPathBasedHintWrapper cpBased;
    Scope customScope;
    private JLabel customScopeLab = null;
    private JLabel currentFile = null;
    private JLabel currentPackage = null;
    private JLabel currentProject = null;
    private JLabel allProjects = null;
    private Project project;
    private String PREF_SCOPE = "InspectAndTransform-Scope";
    private Map<? extends HintMetadata, ? extends Iterable<? extends HintDescription>> allHints;
    private boolean initialized;
    private ButtonGroup buttonGroup;
    private JComboBox configurationCombo;
    private JRadioButton configurationRadio;
    private JButton customScopeButton;
    private JLabel inspectLabel;
    private JButton manageConfigurations;
    private JButton manageSingleRefactoring;
    private JLabel refactorUsingLabel;
    private JComboBox scopeCombo;
    private JRadioButton singleRefactorRadio;
    private JComboBox singleRefactoringCombo;
    private boolean prefsLoading = false;
    private Popup popup = null;
    private PropertyChangeListener listener;

    public InspectAndRefactorPanel(Lookup context, ChangeListener parent, boolean query, Utilities.ClassPathBasedHintWrapper cpBased) {
        this.context = context;
        this.hintWrap = (InspectAndRefactorUI.HintWrap)context.lookup(InspectAndRefactorUI.HintWrap.class);
        this.preselect = (HintMetadata)context.lookup(HintMetadata.class);
        this.cpBased = cpBased;
    }

    public synchronized void initialize() {
        FileObject file;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initComponents();
        this.configurationCombo.setModel(new ConfigurationsComboModel(false));
        this.allHints = this.hintWrap != null ? Collections.singletonMap(this.hintWrap.hm, this.hintWrap.hints) : Utilities.getBatchSupportedHints(this.cpBased);
        this.singleRefactoringCombo.setModel(new InspectionComboModel(this.allHints.keySet()));
        this.singleRefactoringCombo.addActionListener(new ActionListener(){
            Object currentItem;
            {
                this.currentItem = InspectAndRefactorPanel.this.singleRefactoringCombo.getSelectedItem();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object tempItem = InspectAndRefactorPanel.this.singleRefactoringCombo.getSelectedItem();
                if (!(tempItem instanceof HintMetadata)) {
                    InspectAndRefactorPanel.this.singleRefactoringCombo.setSelectedItem(this.currentItem);
                } else {
                    this.currentItem = tempItem;
                }
            }
        });
        this.configurationCombo.setRenderer(new ConfigurationRenderer());
        this.singleRefactoringCombo.setRenderer(new InspectionRenderer());
        DataObject dob = (DataObject)this.context.lookup(DataObject.class);
        Icon prj = null;
        ProjectInformation pi = null;
        if (dob != null && (file = (FileObject)this.context.lookup(FileObject.class)) != null) {
            this.project = FileOwnerQuery.getOwner((FileObject)file);
            if (this.project != null) {
                this.fileObject = file;
                pi = ProjectUtils.getInformation((Project)this.project);
                prj = pi.getIcon();
            }
        }
        this.customScopeLab = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_CustomScope"), prj, 2);
        if (this.fileObject != null) {
            String packageName;
            if (!this.fileObject.isFolder()) {
                this.currentFile = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_CurrentFile", (Object)this.fileObject.getNameExt()), ImageUtilities.image2Icon((Image)dob.getNodeDelegate().getIcon(1)), 2);
            }
            if ((packageName = this.getPackageName(this.fileObject)) != null) {
                this.currentPackage = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_CurrentPackage", (Object)packageName), ImageUtilities.loadImageIcon((String)PACKAGE, (boolean)false), 2);
            }
            this.currentProject = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_CurrentProject", (Object)pi.getDisplayName()), pi.getIcon(), 2);
        } else {
            this.project = (Project)this.context.lookup(Project.class);
            if (this.project == null && dob != null) {
                this.project = FileOwnerQuery.getOwner((FileObject)dob.getPrimaryFile());
            }
            if (this.project != null) {
                pi = ProjectUtils.getInformation((Project)this.project);
                prj = pi.getIcon();
                this.currentProject = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_CurrentProject", (Object)pi.getDisplayName()), pi.getIcon(), 2);
            }
        }
        this.allProjects = new JLabel(NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"LBL_AllProjects"), prj, 2);
        this.scopeCombo.setModel(new DefaultComboBoxModel<Object>(InspectAndRefactorPanel.createArray(this.allProjects, this.currentProject, this.currentPackage, this.currentFile, this.customScopeLab)));
        this.scopeCombo.setRenderer(new JLabelRenderer());
        this.loadPrefs();
        if (this.scopeCombo.getItemCount() > 2) {
            this.scopeCombo.setSelectedIndex(this.scopeCombo.getItemCount() - 2);
        }
        if (this.hintWrap != null) {
            this.singleRefactoringCombo.setSelectedItem(this.hintWrap.hm);
            this.setConfig(false);
            this.singleRefactorRadio.setSelected(true);
            this.singleRefactorRadio.setEnabled(false);
            this.singleRefactoringCombo.setEnabled(false);
            this.manageSingleRefactoring.setEnabled(false);
            this.configurationRadio.setEnabled(false);
        } else if (this.preselect != null) {
            HintMetadata toSelect = null;
            String id = this.preselect.id;
            for (HintMetadata hintMetadata : this.allHints.keySet()) {
                if (!Objects.equals(hintMetadata.id, id)) continue;
                toSelect = hintMetadata;
                break;
            }
            if (toSelect != null) {
                this.singleRefactoringCombo.setSelectedItem(toSelect);
                this.singleRefactorRadio.setSelected(true);
            }
        }
    }

    private static Object[] createArray(Object ... items) {
        ArrayList<Object> a = new ArrayList<Object>();
        for (Object o : items) {
            if (o == null) continue;
            a.add(o);
        }
        return a.toArray(new Object[0]);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.inspectLabel = new JLabel();
        this.scopeCombo = new JComboBox();
        this.refactorUsingLabel = new JLabel();
        this.configurationRadio = new JRadioButton();
        this.singleRefactorRadio = new JRadioButton();
        this.configurationCombo = new JComboBox();
        this.singleRefactoringCombo = new JComboBox();
        this.manageConfigurations = new JButton();
        this.manageSingleRefactoring = new JButton();
        this.customScopeButton = new JButton();
        this.inspectLabel.setLabelFor(this.scopeCombo);
        Mnemonics.setLocalizedText((JLabel)this.inspectLabel, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.inspectLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.refactorUsingLabel, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.refactorUsingLabel.text"));
        this.buttonGroup.add(this.configurationRadio);
        this.configurationRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.configurationRadio, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.configurationRadio.text"));
        this.configurationRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                InspectAndRefactorPanel.this.configurationRadioItemStateChanged(evt);
            }
        });
        this.buttonGroup.add(this.singleRefactorRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.singleRefactorRadio, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.singleRefactorRadio.text"));
        this.singleRefactorRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                InspectAndRefactorPanel.this.singleRefactorRadioItemStateChanged(evt);
            }
        });
        this.configurationCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                InspectAndRefactorPanel.this.configurationComboItemStateChanged(evt);
            }
        });
        this.singleRefactoringCombo.setEnabled(false);
        this.singleRefactoringCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                InspectAndRefactorPanel.this.singleRefactoringComboItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.manageConfigurations, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.manageConfigurations.text"));
        this.manageConfigurations.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                InspectAndRefactorPanel.this.manageConfigurationsItemStateChanged(evt);
            }
        });
        this.manageConfigurations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InspectAndRefactorPanel.this.manageConfigurationsActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.manageSingleRefactoring, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.manageSingleRefactoring.text"));
        this.manageSingleRefactoring.setEnabled(false);
        this.manageSingleRefactoring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InspectAndRefactorPanel.this.manageSingleRefactoringActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.customScopeButton, (String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"InspectAndRefactorPanel.customScopeButton.text"));
        this.customScopeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InspectAndRefactorPanel.this.customScopeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.refactorUsingLabel).addComponent(this.inspectLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.singleRefactorRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.singleRefactoringCombo, 0, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.configurationRadio).addGap(25, 25, 25).addComponent(this.configurationCombo, 0, 242, Short.MAX_VALUE)).addComponent(this.scopeCombo, GroupLayout.Alignment.TRAILING, 0, 377, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.manageConfigurations, -1, -1, Short.MAX_VALUE).addComponent(this.customScopeButton).addComponent(this.manageSingleRefactoring, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inspectLabel).addComponent(this.scopeCombo, -2, -1, -2).addComponent(this.customScopeButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configurationRadio).addComponent(this.configurationCombo, -2, -1, -2).addComponent(this.manageConfigurations).addComponent(this.refactorUsingLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.singleRefactorRadio).addComponent(this.singleRefactoringCombo, -2, -1, -2).addComponent(this.manageSingleRefactoring)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void setConfig(boolean yes) {
        this.singleRefactoringCombo.setEnabled(!yes);
        this.manageSingleRefactoring.setEnabled(!yes);
        this.configurationCombo.setEnabled(yes);
        this.manageConfigurations.setEnabled(yes);
        this.storePrefs();
    }

    private void manageConfigurationsActionPerformed(ActionEvent evt) {
        this.manageRefactorings(false);
    }

    private void manageSingleRefactoringActionPerformed(ActionEvent evt) {
        this.manageRefactorings(true);
    }

    private void manageConfigurationsItemStateChanged(ItemEvent evt) {
        this.storePrefs();
    }

    private void singleRefactoringComboItemStateChanged(ItemEvent evt) {
        this.storePrefs();
    }

    private void configurationComboItemStateChanged(ItemEvent evt) {
        this.storePrefs();
    }

    private void customScopeButtonActionPerformed(ActionEvent evt) {
        Object selectedItem = this.scopeCombo.getSelectedItem();
        if (selectedItem == this.allProjects) {
            HashSet<FileObject> todo = new HashSet<FileObject>();
            for (ClassPath source : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                todo.addAll(Arrays.asList(source.getRoots()));
            }
            this.customScope = Scope.create(todo, Collections.emptyList(), Collections.emptyList());
        } else if (selectedItem == this.currentProject) {
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            for (SourceGroup gr : ProjectUtils.getSources((Project)this.project).getSourceGroups("java")) {
                roots.add(gr.getRootFolder());
            }
            this.customScope = Scope.create(roots, Collections.emptyList(), Collections.emptyList());
        } else if (selectedItem == this.currentPackage) {
            if (this.fileObject != null) {
                Set<10> col = Collections.singleton(new NonRecursiveFolder(){

                    public FileObject getFolder() {
                        return InspectAndRefactorPanel.this.fileObject.isFolder() ? InspectAndRefactorPanel.this.fileObject : InspectAndRefactorPanel.this.fileObject.getParent();
                    }
                });
                this.customScope = Scope.create(Collections.emptyList(), col, Collections.emptyList());
            }
        } else if (selectedItem == this.currentFile) {
            this.customScope = Scope.create(Collections.emptyList(), Collections.emptyList(), Collections.singleton(this.fileObject));
        } else {
            this.customScope = this.readScope();
            if (this.customScope == null) {
                this.customScope = Scope.create(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
            }
        }
        Scope s = JavaScopeBuilder.open((String)NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"CTL_CustomScope"), (Scope)this.customScope);
        if (s != null) {
            this.customScope = s;
            this.scopeCombo.setSelectedIndex(this.scopeCombo.getItemCount() - 1);
            this.storeScope(this.customScope);
        }
    }

    private void configurationRadioItemStateChanged(ItemEvent evt) {
        this.setConfig(true);
    }

    private void singleRefactorRadioItemStateChanged(ItemEvent evt) {
        this.setConfig(false);
    }

    public synchronized Union2<String, Iterable<? extends HintDescription>> getPattern() {
        if (this.singleRefactorRadio.isSelected()) {
            if (this.hintWrap != null) {
                return Union2.createSecond(this.hintWrap.hints);
            }
            HintMetadata hint = (HintMetadata)this.singleRefactoringCombo.getSelectedItem();
            Iterable<? extends HintDescription> hintDesc = this.allHints.get(hint);
            return Union2.createSecond(hintDesc);
        }
        Configuration config = (Configuration)this.configurationCombo.getSelectedItem();
        LinkedList<HintDescription> hintsToApply = new LinkedList<HintDescription>();
        HintsSettings settings = config.getSettings();
        for (Map.Entry<? extends HintMetadata, ? extends Iterable<? extends HintDescription>> e : this.allHints.entrySet()) {
            if (!settings.isEnabled(e.getKey())) continue;
            for (HintDescription hintDescription : this.allHints.get(e.getKey())) {
                hintsToApply.add(hintDescription);
            }
        }
        return Union2.createSecond(hintsToApply);
    }

    public BatchSearch.Scope getScope() {
        switch (this.scopeCombo.getSelectedIndex()) {
            case 0: {
                return Scopes.allOpenedProjectsScope();
            }
            case 1: {
                if (this.project != null) {
                    return this.getThisProjectScope();
                }
                return this.getCustomScope();
            }
            case 2: {
                if (this.fileObject != null) {
                    return this.getThisPackageScope();
                }
                return this.getCustomScope();
            }
            case 3: {
                return this.getThisFileScope();
            }
            case 4: {
                return this.getCustomScope();
            }
        }
        return Scopes.allOpenedProjectsScope();
    }

    private BatchSearch.Scope getCustomScope() {
        if (this.customScope == null) {
            return Scopes.specifiedFoldersScope((BatchSearch.Folder[])new BatchSearch.Folder[0]);
        }
        LinkedList list = new LinkedList();
        list.addAll(this.customScope.getFiles());
        list.addAll(this.customScope.getFolders());
        list.addAll(this.customScope.getSourceRoots());
        return Scopes.specifiedFoldersScope((BatchSearch.Folder[])BatchSearch.Folder.convert(list));
    }

    private void storeScope(Scope customScope) {
        try {
            this.storeFileList(customScope.getSourceRoots(), "sourceRoot");
            this.storeFileList(customScope.getFolders(), "folder");
            this.storeFileList(customScope.getFiles(), "file");
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Scope readScope() {
        try {
            if (NbPreferences.forModule(JavaScopeBuilder.class).nodeExists(this.PREF_SCOPE)) {
                return Scope.create(this.loadFileList("sourceRoot", FileObject.class), this.loadFileList("folder", NonRecursiveFolder.class), this.loadFileList("file", FileObject.class));
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private <T> List<T> loadFileList(String basekey, Class<T> type) throws BackingStoreException {
        Preferences pref = NbPreferences.forModule(JavaScopeBuilder.class).node(this.PREF_SCOPE).node(basekey);
        LinkedList<Object> toRet = new LinkedList<Object>();
        for (String key : pref.keys()) {
            String url = pref.get(key, null);
            if (url == null || url.isEmpty()) continue;
            try {
                final FileObject f = URLMapper.findFileObject((URL)new URL(url));
                if (f == null || !f.isValid()) continue;
                if (type.isAssignableFrom(FileObject.class)) {
                    toRet.add(f);
                    continue;
                }
                toRet.add(new NonRecursiveFolder(){

                    public FileObject getFolder() {
                        return f;
                    }
                });
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return toRet;
    }

    private void storeFileList(Set<?> files, String basekey) throws BackingStoreException {
        Preferences pref = NbPreferences.forModule(JavaScopeBuilder.class).node(this.PREF_SCOPE).node(basekey);
        assert (files != null);
        pref.clear();
        int count = 0;
        for (Object next : files) {
            if (next instanceof FileObject) {
                pref.put(basekey + count++, ((FileObject)next).toURL().toExternalForm());
                continue;
            }
            pref.put(basekey + count++, ((NonRecursiveFolder)next).getFolder().toURL().toExternalForm());
        }
        pref.flush();
    }

    private BatchSearch.Scope getThisProjectScope() {
        ArrayList<FileObject> roots = new ArrayList<FileObject>();
        for (SourceGroup sg : ProjectUtils.getSources((Project)this.project).getSourceGroups("java")) {
            roots.add(sg.getRootFolder());
        }
        return Scopes.specifiedFoldersScope((BatchSearch.Folder[])BatchSearch.Folder.convert(roots));
    }

    private BatchSearch.Scope getThisPackageScope() {
        final FileObject packageFolder = this.fileObject.isFolder() ? this.fileObject : this.fileObject.getParent();
        NonRecursiveFolder pkg = new NonRecursiveFolder(){

            public FileObject getFolder() {
                return packageFolder;
            }
        };
        return Scopes.specifiedFoldersScope((BatchSearch.Folder[])BatchSearch.Folder.convert(Collections.singleton(pkg)));
    }

    private BatchSearch.Scope getThisFileScope() {
        return Scopes.specifiedFoldersScope((BatchSearch.Folder[])BatchSearch.Folder.convert(Collections.singleton(this.fileObject)));
    }

    private synchronized void manageRefactorings(boolean single) {
        HintsPanel panel = single ? new HintsPanel((HintMetadata)this.singleRefactoringCombo.getSelectedItem(), null, this.cpBased) : new HintsPanel((Configuration)this.configurationCombo.getSelectedItem(), this.cpBased);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(InspectAndRefactorPanel.class, (String)"CTL_ManageRefactorings"), true, new Object[0], null, 0, null, null);
        JDialog dialog = (JDialog)DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.validate();
        dialog.pack();
        dialog.setVisible(true);
        if (panel.isConfirmed()) {
            if (this.configurationRadio.isSelected()) {
                Configuration selectedConfiguration = panel.getSelectedConfiguration();
                if (selectedConfiguration != null) {
                    this.configurationCombo.setSelectedItem(selectedConfiguration);
                }
            } else {
                HintMetadata selectedHint = panel.getSelectedHint();
                if (selectedHint != null) {
                    if (panel.hasNewHints()) {
                        this.allHints = Utilities.getBatchSupportedHints(this.cpBased);
                        this.singleRefactoringCombo.setModel(new InspectionComboModel(this.allHints.keySet()));
                    }
                    this.singleRefactoringCombo.setSelectedItem(selectedHint);
                }
            }
        }
    }

    private void storePrefs() {
        if (this.prefsLoading) {
            return;
        }
        Preferences prefs = NbPreferences.forModule(InspectAndRefactorPanel.class);
        if (this.hintWrap == null) {
            prefs.putBoolean("InspectAndRefactorPanel.singleRefactorRadio", this.singleRefactorRadio.isSelected());
            prefs.putInt("InspectAndRefactorPanel.configurationCombo", this.configurationCombo.getSelectedIndex());
            prefs.putInt("InspectAndRefactorPanel.singleRefactoringCombo", this.singleRefactoringCombo.getSelectedIndex());
        }
        prefs.putInt("InspectAndRefactorPanel.scopeCombo", this.scopeCombo.getSelectedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrefs() {
        this.prefsLoading = true;
        try {
            Preferences prefs = NbPreferences.forModule(InspectAndRefactorPanel.class);
            boolean sel = prefs.getBoolean("InspectAndRefactorPanel.singleRefactorRadio", true);
            this.setConfig(!sel);
            this.singleRefactorRadio.setSelected(sel);
            try {
                this.configurationCombo.setSelectedIndex(prefs.getInt("InspectAndRefactorPanel.configurationCombo", 0));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                this.singleRefactoringCombo.setSelectedIndex(prefs.getInt("InspectAndRefactorPanel.singleRefactoringCombo", 0));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                this.scopeCombo.setSelectedIndex(prefs.getInt("InspectAndRefactorPanel.scopeCombo", 0));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        finally {
            this.prefsLoading = false;
        }
    }

    private String getPackageName(FileObject file) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        return classPath.getResourceName(file.isFolder() ? file : file.getParent(), '.', false);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        final Accessible comp = this.singleRefactoringCombo.getUI().getAccessibleChild(this.singleRefactoringCombo, 0);
        if (!(comp instanceof JPopupMenu)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){
            private static final String HTML_DESC_FOOTER = "</body></html>";
            private final String HTML_DESC_HEADER = "<html><body><b>" + NbBundle.getMessage(HintsPanel.class, (String)"CTL_Description_Border") + "</b><br>";

            @Override
            public void run() {
                JPopupMenu menu = (JPopupMenu)comp;
                HintMetadata item = (HintMetadata)InspectAndRefactorPanel.this.singleRefactoringCombo.getSelectedItem();
                final JEditorPane pane = new JEditorPane();
                pane.setContentType("text/html");
                pane.setEditable(false);
                final JScrollPane scrollPane = new JScrollPane(pane);
                pane.setText(this.HTML_DESC_HEADER + item.description + HintsPanelLogic.getQueryWarning(item) + HTML_DESC_FOOTER);
                scrollPane.setPreferredSize(menu.getSize());
                Dimension size = menu.getSize();
                Point location = menu.getLocationOnScreen();
                InspectAndRefactorPanel.this.listener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("AccessibleActiveDescendant")) {
                            AccessibleContext context = (AccessibleContext)evt.getNewValue();
                            Object elementAt = InspectAndRefactorPanel.this.singleRefactoringCombo.getModel().getElementAt(context.getAccessibleIndexInParent());
                            if (elementAt instanceof HintMetadata) {
                                HintMetadata item = (HintMetadata)elementAt;
                                pane.setText(HTML_DESC_HEADER + item.description + HintsPanelLogic.getQueryWarning(item) + 13.HTML_DESC_FOOTER);
                                pane.setCaretPosition(0);
                                scrollPane.getVerticalScrollBar().setValue(0);
                            }
                        }
                    }
                };
                InspectAndRefactorPanel.this.singleRefactoringCombo.getAccessibleContext().addPropertyChangeListener(InspectAndRefactorPanel.this.listener);
                InspectAndRefactorPanel.this.popup = PopupFactory.getSharedInstance().getPopup(menu, scrollPane, (int)location.getX(), (int)(location.getY() - size.getHeight() - (double)InspectAndRefactorPanel.this.singleRefactoringCombo.getHeight()) + 5);
                InspectAndRefactorPanel.this.popup.show();
            }
        });
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        this.singleRefactoringCombo.getAccessibleContext().removePropertyChangeListener(this.listener);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    private static class JLabelRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public JLabelRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null) {
                this.setText(((JLabel)value).getText());
                this.setIcon(((JLabel)value).getIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

