/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.modules.search.project.AbstractProjectSearchScope;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SearchScopeCurrentProject
extends SearchScopeDefinition {
    private static final int NAME_LENGTH_LIMIT = 30;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("activated".equals(evt.getPropertyName())) {
                SearchScopeCurrentProject.this.update();
            }
        }
    };
    private boolean applicable = true;
    private String name = null;
    private Icon icon;
    private Project project = null;

    public SearchScopeCurrentProject() {
        TopComponent.getRegistry().addPropertyChangeListener(this.pcl);
        this.update();
    }

    private void update() {
        this.project = null;
        TopComponent tc = TopComponent.getRegistry().getActivated();
        if (tc != null) {
            Project p;
            DataObject dob;
            FileObject fo = (FileObject)tc.getLookup().lookup(FileObject.class);
            if (fo == null && (dob = (DataObject)tc.getLookup().lookup(DataObject.class)) != null) {
                fo = dob.getPrimaryFile();
            }
            if (fo != null && (p = FileOwnerQuery.getOwner((FileObject)fo)) != null) {
                this.project = p;
            }
        }
        if (this.project != null) {
            this.applicable = true;
            this.name = NbBundle.getMessage(SearchScopeCurrentProject.class, (String)"SearchScopeCurrentProject", (Object)this.shortName(this.project));
            this.icon = ProjectUtils.getInformation((Project)this.project).getIcon();
        } else {
            this.applicable = false;
            this.name = "";
            this.icon = null;
        }
        this.notifyListeners();
    }

    private String shortName(Project p) {
        assert (p != null);
        ProjectInformation pi = ProjectUtils.getInformation((Project)p);
        if (pi == null) {
            return "";
        }
        String name = pi.getDisplayName();
        if (name == null) {
            return "";
        }
        if (name.length() > 30) {
            return name.substring(0, 27) + "...";
        }
        return name;
    }

    public String getTypeId() {
        return "current project";
    }

    public String getDisplayName() {
        return this.name;
    }

    public boolean isApplicable() {
        assert (!this.applicable || this.applicable && this.project != null && this.name != null);
        return this.applicable;
    }

    public SearchInfo getSearchInfo() {
        return AbstractProjectSearchScope.createSingleProjectSearchInfo(this.project);
    }

    public int getPriority() {
        return 99;
    }

    public void clean() {
        TopComponent.getRegistry().removePropertyChangeListener(this.pcl);
        this.pcl = null;
        this.applicable = false;
        this.name = null;
        this.project = null;
    }

    public Icon getIcon() {
        return this.icon;
    }
}

