/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.method;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.AbstractTypedAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.analysis.analyzer.MethodElementAnalyzer;
import org.openide.util.NbBundle;

public class TypedMethodAnalyzer
extends AbstractTypedAnalyzer
implements MethodElementAnalyzer.MethodAnalyzer {
    @Override
    public void analyze(ExecutableElement element, TypeMirror returnType, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        this.analyze(element, returnType, cancel, result);
    }

    @Override
    protected void addError(Element element, CdiAnalysisResult result) {
        result.addError(element, NbBundle.getMessage(TypedMethodAnalyzer.class, (String)"ERR_BadRestritedMethodType"));
    }

    @Override
    protected boolean hasBeanType(Element subject, TypeMirror returnType, TypeMirror requiredBeanType, CompilationInfo compInfo) {
        return compInfo.getTypes().isSubtype(returnType, requiredBeanType);
    }

    @Override
    protected void checkSpecializes(Element element, TypeMirror elementType, List<TypeMirror> restrictedTypes, AtomicBoolean cancel, CdiAnalysisResult result) {
        CompilationInfo compInfo = result.getInfo();
        if (!AnnotationUtil.hasAnnotation(element, compInfo, "jakarta.enterprise.inject.Produces", "javax.enterprise.inject.Produces")) {
            return;
        }
        ExecutableElement method = (ExecutableElement)element;
        ExecutableElement overriddenMethod = compInfo.getElementUtilities().getOverriddenMethod(method);
        if (overriddenMethod == null) {
            return;
        }
        TypeElement clazz = compInfo.getElementUtilities().enclosingTypeElement((Element)method);
        TypeMirror superType = clazz.getSuperclass();
        TypeElement superClass = compInfo.getElementUtilities().enclosingTypeElement((Element)overriddenMethod);
        if (!superClass.equals(compInfo.getTypes().asElement(superType))) {
            return;
        }
        if (cancel.get()) {
            return;
        }
        List<TypeMirror> restrictedSuper = this.getRestrictedTypes(overriddenMethod, compInfo, cancel);
        if (cancel.get()) {
            return;
        }
        if (restrictedSuper == null) {
            if (!this.hasUnrestrictedOverridenType(elementType, restrictedTypes, compInfo, overriddenMethod, superClass)) {
                result.addError(element, NbBundle.getMessage(TypedMethodAnalyzer.class, (String)"ERR_BadSpecializesMethod"));
            }
        } else if (!this.hasRestrictedType(elementType, restrictedTypes, compInfo, restrictedSuper)) {
            result.addError(element, NbBundle.getMessage(TypedMethodAnalyzer.class, (String)"ERR_BadSpecializesMethod"));
        }
    }

    private boolean hasRestrictedType(TypeMirror elementType, List<TypeMirror> restrictedTypes, CompilationInfo compInfo, List<TypeMirror> restrictedSuper) {
        if (elementType.getKind() == TypeKind.ARRAY) {
            for (TypeMirror mirror : restrictedSuper) {
                boolean found = false;
                for (TypeMirror restrictedType : restrictedTypes) {
                    if (!compInfo.getTypes().isSameType(restrictedType, mirror)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        Set<TypeElement> specializedBeanTypes = this.getElements(restrictedSuper, compInfo);
        Set<TypeElement> restrictedElements = this.getElements(restrictedTypes, compInfo);
        restrictedElements.add(compInfo.getElements().getTypeElement(Object.class.getCanonicalName()));
        return restrictedElements.containsAll(specializedBeanTypes);
    }

    private boolean hasUnrestrictedOverridenType(TypeMirror elementType, List<TypeMirror> restrictedTypes, CompilationInfo compInfo, ExecutableElement overriddenMethod, TypeElement superClass) {
        Element returnElement;
        TypeMirror methodType = compInfo.getTypes().asMemberOf((DeclaredType)superClass.asType(), overriddenMethod);
        TypeMirror returnOverriden = ((ExecutableType)methodType).getReturnType();
        if (elementType.getKind() == TypeKind.ARRAY) {
            for (TypeMirror mirror : restrictedTypes) {
                if (!compInfo.getTypes().isSameType(mirror, returnOverriden)) continue;
                return true;
            }
            return false;
        }
        if (returnOverriden.getKind().isPrimitive()) {
            TypeElement boxed = compInfo.getTypes().boxedClass((PrimitiveType)returnOverriden);
            return this.hasUnrestrictedType(boxed, restrictedTypes, compInfo);
        }
        if (returnOverriden instanceof DeclaredType && (returnElement = compInfo.getTypes().asElement(returnOverriden)) instanceof TypeElement) {
            return this.hasUnrestrictedType((TypeElement)returnElement, restrictedTypes, compInfo);
        }
        return true;
    }

    private boolean hasUnrestrictedType(TypeElement overriden, List<TypeMirror> restrictedTypes, CompilationInfo compInfo) {
        Set<TypeElement> specializedBeanTypes = this.getUnrestrictedBeanTypes(overriden, compInfo);
        Set<TypeElement> restrictedElements = this.getElements(restrictedTypes, compInfo);
        restrictedElements.add(compInfo.getElements().getTypeElement(Object.class.getCanonicalName()));
        return restrictedElements.containsAll(specializedBeanTypes);
    }
}

