/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.gradle.api.GradleException;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.javax.annotation.Nullable;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.StreamedValueListener;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.CancellationTokenInternal;
import org.gradle.tooling.internal.consumer.ConnectionConfigurationUtil;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.parameters.BuildProgressListenerAdapter;
import org.gradle.tooling.internal.consumer.parameters.FailsafeBuildProgressListenerAdapter;
import org.gradle.tooling.internal.consumer.parameters.FailsafeStreamedValueListener;
import org.gradle.tooling.internal.consumer.parameters.ProgressListenerAdapter;
import org.gradle.tooling.internal.gradle.TaskListingLaunchable;
import org.gradle.tooling.internal.protocol.BuildParameters;
import org.gradle.tooling.internal.protocol.InternalLaunchable;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;
import org.gradle.tooling.model.Launchable;
import org.gradle.tooling.model.Task;

public class ConsumerOperationParameters
implements BuildParameters {
    private final String entryPointName;
    private final ProgressListenerAdapter progressListener;
    private final FailsafeBuildProgressListenerAdapter buildProgressListener;
    private final CancellationToken cancellationToken;
    private final ConnectionParameters parameters;
    private final long startTime = System.currentTimeMillis();
    private final OutputStream stdout;
    private final OutputStream stderr;
    private final Boolean colorOutput;
    private final InputStream stdin;
    private final File javaHome;
    private final List<String> baseJvmArguments;
    private final List<String> additionalJvmArguments;
    private final Map<String, String> envVariables;
    private final List<String> arguments;
    private final List<String> tasks;
    private final List<InternalLaunchable> launchables;
    private final ClassPath injectedPluginClasspath;
    private final List<ProgressListener> legacyProgressListeners;
    private final Map<OperationType, List<org.gradle.tooling.events.ProgressListener>> progressListeners;
    private final Map<String, String> systemProperties;
    private final FailsafeStreamedValueListener streamedValueListener;

    public static Builder builder() {
        return new Builder();
    }

    private ConsumerOperationParameters(String entryPointName, ConnectionParameters parameters, OutputStream stdout, OutputStream stderr, Boolean colorOutput, InputStream stdin, File javaHome, @Nullable List<String> baseJvmArguments, @Nullable List<String> additionalJvmArguments, Map<String, String> envVariables, List<String> arguments, List<String> tasks, List<InternalLaunchable> launchables, ClassPath injectedPluginClasspath, List<ProgressListener> legacyProgressListeners, Map<OperationType, List<org.gradle.tooling.events.ProgressListener>> progressListeners, CancellationToken cancellationToken, Map<String, String> systemProperties, FailsafeStreamedValueListener streamedValueListener) {
        this.entryPointName = entryPointName;
        this.parameters = parameters;
        this.stdout = stdout;
        this.stderr = stderr;
        this.colorOutput = colorOutput;
        this.stdin = stdin;
        this.javaHome = javaHome;
        this.baseJvmArguments = baseJvmArguments;
        this.additionalJvmArguments = additionalJvmArguments;
        this.envVariables = envVariables;
        this.arguments = arguments;
        this.tasks = tasks;
        this.launchables = launchables;
        this.injectedPluginClasspath = injectedPluginClasspath;
        this.cancellationToken = cancellationToken;
        this.legacyProgressListeners = legacyProgressListeners;
        this.progressListeners = progressListeners;
        this.systemProperties = systemProperties;
        this.streamedValueListener = streamedValueListener;
        this.progressListener = new ProgressListenerAdapter(this.legacyProgressListeners);
        this.buildProgressListener = new FailsafeBuildProgressListenerAdapter(new BuildProgressListenerAdapter(this.progressListeners));
    }

    private static void validateJavaHome(File javaHome) {
        if (javaHome == null) {
            return;
        }
        if (!javaHome.isDirectory()) {
            throw new IllegalArgumentException("Supplied javaHome is not a valid folder. You supplied: " + javaHome);
        }
    }

    public String getEntryPointName() {
        return this.entryPointName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean getVerboseLogging() {
        return this.parameters.getVerboseLogging();
    }

    public File getGradleUserHomeDir() {
        return this.parameters.getGradleUserHomeDir();
    }

    public File getProjectDir() {
        return this.parameters.getProjectDir();
    }

    public Boolean isSearchUpwards() {
        return this.parameters.isSearchUpwards();
    }

    public Boolean isEmbedded() {
        return this.parameters.isEmbedded();
    }

    public TimeUnit getDaemonMaxIdleTimeUnits() {
        return this.parameters.getDaemonMaxIdleTimeUnits();
    }

    public Integer getDaemonMaxIdleTimeValue() {
        return this.parameters.getDaemonMaxIdleTimeValue();
    }

    public File getDaemonBaseDir() {
        return this.parameters.getDaemonBaseDir();
    }

    public OutputStream getStandardOutput() {
        return this.stdout;
    }

    public OutputStream getStandardError() {
        return this.stderr;
    }

    public Boolean isColorOutput() {
        return this.colorOutput;
    }

    public InputStream getStandardInput() {
        return this.stdin;
    }

    public File getJavaHome() {
        return this.javaHome;
    }

    @Nullable
    public List<String> getJvmArguments() {
        if (this.baseJvmArguments == null && this.additionalJvmArguments == null) {
            return null;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.baseJvmArguments != null) {
            arguments.addAll(this.baseJvmArguments);
        } else {
            arguments.addAll(ConnectionConfigurationUtil.determineJvmArguments(this.parameters));
        }
        if (this.additionalJvmArguments != null) {
            arguments.addAll(this.additionalJvmArguments);
        }
        return arguments;
    }

    @Nullable
    public List<String> getBaseJvmArguments() {
        return this.baseJvmArguments;
    }

    @Nullable
    public List<String> getAdditionalJvmArguments() {
        return this.additionalJvmArguments;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.envVariables;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public List<String> getTasks() {
        return this.tasks;
    }

    public List<InternalLaunchable> getLaunchables() {
        return this.launchables;
    }

    public List<File> getInjectedPluginClasspath() {
        return this.injectedPluginClasspath.getAsFiles();
    }

    public ProgressListenerVersion1 getProgressListener() {
        return this.progressListener;
    }

    public FailsafeBuildProgressListenerAdapter getBuildProgressListener() {
        return this.buildProgressListener;
    }

    public BuildCancellationToken getCancellationToken() {
        return ((CancellationTokenInternal)((Object)this.cancellationToken)).getToken();
    }

    public Map<String, ?> getSystemProperties() {
        return this.systemProperties;
    }

    public FailsafeStreamedValueListener getStreamedValueListener() {
        return this.streamedValueListener;
    }

    public void onStreamedValue(Object model) {
        this.streamedValueListener.onValue(model);
    }

    public static class Builder {
        private final List<ProgressListener> legacyProgressListeners = new ArrayList<ProgressListener>();
        private final Map<OperationType, List<org.gradle.tooling.events.ProgressListener>> progressListeners = new EnumMap<OperationType, List<org.gradle.tooling.events.ProgressListener>>(OperationType.class);
        private String entryPoint;
        private CancellationToken cancellationToken;
        private ConnectionParameters parameters;
        private OutputStream stdout;
        private OutputStream stderr;
        private Boolean colorOutput;
        private InputStream stdin;
        private File javaHome;
        private List<String> baseJvmArguments = null;
        private List<String> additionalJvmArguments = null;
        private Map<String, String> envVariables;
        private List<String> arguments;
        private List<String> tasks;
        private List<InternalLaunchable> launchables;
        private ClassPath injectedPluginClasspath = ClassPath.EMPTY;
        private Map<String, String> systemProperties;
        @Nullable
        private StreamedValueListener streamedValueListener;

        private Builder() {
        }

        public Builder setEntryPoint(String entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public Builder setParameters(ConnectionParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setStdout(OutputStream stdout) {
            this.stdout = stdout;
            return this;
        }

        public Builder setStderr(OutputStream stderr) {
            this.stderr = stderr;
            return this;
        }

        public Builder setColorOutput(Boolean colorOutput) {
            this.colorOutput = colorOutput;
            return this;
        }

        public Builder setStdin(InputStream stdin) {
            this.stdin = stdin;
            return this;
        }

        public Builder setJavaHome(File javaHome) {
            ConsumerOperationParameters.validateJavaHome(javaHome);
            this.javaHome = javaHome;
            return this;
        }

        public Builder setBaseJvmArguments(@Nullable List<String> baseJvmArguments) {
            if (baseJvmArguments != null) {
                this.baseJvmArguments = new ArrayList<String>(baseJvmArguments);
            }
            return this;
        }

        public Builder addJvmArguments(@Nullable List<String> jvmArguments) {
            this.additionalJvmArguments = Builder.concat(this.additionalJvmArguments, jvmArguments);
            return this;
        }

        public Builder setArguments(List<String> arguments) {
            this.arguments = arguments;
            return this;
        }

        public Builder addArguments(List<String> arguments) {
            this.arguments = Builder.concat(this.arguments, arguments);
            return this;
        }

        private static List<String> concat(@Nullable List<String> first, @Nullable List<String> second) {
            ArrayList<String> result = new ArrayList<String>();
            if (first != null) {
                result.addAll(first);
            }
            if (second != null) {
                result.addAll(second);
            }
            return result;
        }

        public Builder setEnvironmentVariables(Map<String, String> envVariables) {
            this.envVariables = envVariables;
            return this;
        }

        public Builder setTasks(List<String> tasks) {
            this.tasks = tasks;
            return this;
        }

        public Builder setLaunchables(Iterable<? extends Launchable> launchables) {
            LinkedHashSet<String> taskPaths = new LinkedHashSet<String>();
            ArrayList<InternalLaunchable> launchablesParams = new ArrayList<InternalLaunchable>();
            for (Launchable launchable : launchables) {
                Object original = new ProtocolToModelAdapter().unpack(launchable);
                if (original instanceof InternalLaunchable) {
                    launchablesParams.add((InternalLaunchable)original);
                    continue;
                }
                if (original instanceof TaskListingLaunchable) {
                    taskPaths.addAll(((TaskListingLaunchable)original).getTaskNames());
                    continue;
                }
                if (launchable instanceof Task) {
                    taskPaths.add(((Task)launchable).getPath());
                    continue;
                }
                throw new GradleException("Only Task or TaskSelector instances are supported: " + (launchable != null ? launchable.getClass() : "null"));
            }
            this.launchables = launchablesParams.isEmpty() ? null : launchablesParams;
            this.tasks = Lists.newArrayList(taskPaths);
            return this;
        }

        public Builder setInjectedPluginClasspath(ClassPath classPath) {
            this.injectedPluginClasspath = classPath;
            return this;
        }

        public Builder setSystemProperties(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties;
            return this;
        }

        public void addProgressListener(ProgressListener listener) {
            this.legacyProgressListeners.add(listener);
        }

        public void addProgressListener(org.gradle.tooling.events.ProgressListener listener, Set<OperationType> eventTypes) {
            for (OperationType type : eventTypes) {
                List<org.gradle.tooling.events.ProgressListener> listeners = this.progressListeners.computeIfAbsent(type, new Function<OperationType, List<org.gradle.tooling.events.ProgressListener>>(){

                    @Override
                    public List<org.gradle.tooling.events.ProgressListener> apply(OperationType operationType) {
                        return new ArrayList<org.gradle.tooling.events.ProgressListener>();
                    }
                });
                listeners.add(listener);
            }
        }

        public void setCancellationToken(CancellationToken cancellationToken) {
            this.cancellationToken = cancellationToken;
        }

        public void setStreamedValueListener(StreamedValueListener streamedValueListener) {
            this.streamedValueListener = streamedValueListener;
        }

        public ConsumerOperationParameters build() {
            if (this.entryPoint == null) {
                throw new IllegalStateException("No entry point specified.");
            }
            return new ConsumerOperationParameters(this.entryPoint, this.parameters, this.stdout, this.stderr, this.colorOutput, this.stdin, this.javaHome, this.baseJvmArguments, this.additionalJvmArguments, this.envVariables, this.arguments, this.tasks, this.launchables, this.injectedPluginClasspath, this.legacyProgressListeners, this.progressListeners, this.cancellationToken, this.systemProperties, new FailsafeStreamedValueListener(this.streamedValueListener));
        }

        public void copyFrom(ConsumerOperationParameters operationParameters) {
            this.tasks = operationParameters.tasks;
            this.launchables = operationParameters.launchables;
            this.cancellationToken = operationParameters.cancellationToken;
            this.legacyProgressListeners.addAll(operationParameters.legacyProgressListeners);
            this.progressListeners.putAll(operationParameters.progressListeners);
            this.arguments = operationParameters.arguments;
            this.baseJvmArguments = operationParameters.baseJvmArguments;
            this.additionalJvmArguments = operationParameters.additionalJvmArguments;
            this.envVariables = operationParameters.envVariables;
            this.stdout = operationParameters.stdout;
            this.stderr = operationParameters.stderr;
            this.stdin = operationParameters.stdin;
            this.colorOutput = operationParameters.colorOutput;
            this.javaHome = operationParameters.javaHome;
            this.injectedPluginClasspath = operationParameters.injectedPluginClasspath;
            this.systemProperties = operationParameters.systemProperties;
        }
    }
}

