/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.refactoring.JavaElementRefFinder;
import org.netbeans.modules.spring.beans.refactoring.PropertyRefFinder;
import org.netbeans.modules.spring.beans.refactoring.SpringRefactorings;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;

public class Occurrences {
    public static List<Occurrence> getPropertyOccurrences(final SpringRefactorings.RenamedProperty renamedProperty, JavaSource js, final SpringScope scope) throws IOException {
        final ArrayList<Occurrence> result = new ArrayList<Occurrence>();
        final HashSet processed = new HashSet();
        js.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(final CompilationController cc) throws Exception {
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                for (SpringConfigModel model : scope.getAllConfigModels()) {
                    model.runDocumentAction(new Action<SpringConfigModel.DocumentAccess>(){

                        @Override
                        public void run(SpringConfigModel.DocumentAccess docAccess) {
                            File file = docAccess.getFile();
                            if (processed.contains(file)) {
                                return;
                            }
                            processed.add(file);
                            try {
                                new PropertyRefFinder(docAccess, cc, renamedProperty).addOccurrences(result);
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
            }
        }, true);
        return result;
    }

    public static List<Occurrence> getJavaClassOccurrences(final String className, SpringScope scope) throws IOException {
        final ArrayList<Occurrence> result = new ArrayList<Occurrence>();
        final HashSet processed = new HashSet();
        for (SpringConfigModel model : scope.getAllConfigModels()) {
            model.runDocumentAction(new Action<SpringConfigModel.DocumentAccess>(){

                @Override
                public void run(SpringConfigModel.DocumentAccess docAccess) {
                    File file = docAccess.getFile();
                    if (processed.contains(file)) {
                        return;
                    }
                    processed.add(file);
                    try {
                        new JavaElementRefFinder(docAccess).addOccurrences(new JavaClassRefMatcher(className), result);
                    }
                    catch (BadLocationException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            });
        }
        return result;
    }

    public static List<Occurrence> getJavaPackageOccurrences(final String packageName, final boolean subpackages, SpringScope scope) throws IOException {
        final ArrayList<Occurrence> result = new ArrayList<Occurrence>();
        final HashSet processed = new HashSet();
        for (SpringConfigModel model : scope.getAllConfigModels()) {
            model.runDocumentAction(new Action<SpringConfigModel.DocumentAccess>(){

                @Override
                public void run(SpringConfigModel.DocumentAccess docAccess) {
                    File file = docAccess.getFile();
                    if (processed.contains(file)) {
                        return;
                    }
                    processed.add(file);
                    try {
                        new JavaElementRefFinder(docAccess).addOccurrences(new JavaPackageRefMatcher(packageName, subpackages), result);
                    }
                    catch (BadLocationException e) {
                        Exceptions.printStackTrace((Throwable)e);
                    }
                }
            });
        }
        return result;
    }

    public static abstract class Occurrence {
        private final FileObject fo;
        private final PositionBounds position;

        Occurrence(FileObject fo, PositionBounds position) {
            this.fo = fo;
            this.position = position;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public PositionBounds getPosition() {
            return this.position;
        }

        public abstract String getDisplayText();
    }

    static final class JavaPackageRefMatcher
    implements JavaElementRefFinder.Matcher {
        private final String packageName;
        private final boolean subpackages;

        public JavaPackageRefMatcher(String packageName, boolean subpackages) {
            this.packageName = packageName;
            this.subpackages = subpackages;
        }

        @Override
        public String accept(String beanClassName) {
            if (!beanClassName.startsWith(this.packageName) || beanClassName.length() == this.packageName.length()) {
                return null;
            }
            if (this.subpackages) {
                return this.packageName;
            }
            int afterDot = this.packageName.length() + 1;
            if (afterDot < beanClassName.length() && beanClassName.indexOf(46, afterDot) == -1) {
                return this.packageName;
            }
            return null;
        }
    }

    static final class JavaClassRefMatcher
    implements JavaElementRefFinder.Matcher {
        private final String className;

        public JavaClassRefMatcher(String className) {
            this.className = className;
        }

        @Override
        public String accept(String beanClassName) {
            if (!beanClassName.startsWith(this.className)) {
                return null;
            }
            if (beanClassName.length() == this.className.length()) {
                return this.className;
            }
            if (beanClassName.charAt(this.className.length()) == '$') {
                return this.className;
            }
            return null;
        }
    }
}

