/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RepositoryCommit
extends ExplicitlySetBmcModel {
    @JsonProperty(value="commitId")
    private final String commitId;
    @JsonProperty(value="commitMessage")
    private final String commitMessage;
    @JsonProperty(value="authorName")
    private final String authorName;
    @JsonProperty(value="authorEmail")
    private final String authorEmail;
    @JsonProperty(value="committerName")
    private final String committerName;
    @JsonProperty(value="committerEmail")
    private final String committerEmail;
    @JsonProperty(value="parentCommitIds")
    private final List<String> parentCommitIds;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="treeId")
    private final String treeId;

    @Deprecated
    @ConstructorProperties(value={"commitId", "commitMessage", "authorName", "authorEmail", "committerName", "committerEmail", "parentCommitIds", "timeCreated", "treeId"})
    public RepositoryCommit(String commitId, String commitMessage, String authorName, String authorEmail, String committerName, String committerEmail, List<String> parentCommitIds, Date timeCreated, String treeId) {
        this.commitId = commitId;
        this.commitMessage = commitMessage;
        this.authorName = authorName;
        this.authorEmail = authorEmail;
        this.committerName = committerName;
        this.committerEmail = committerEmail;
        this.parentCommitIds = parentCommitIds;
        this.timeCreated = timeCreated;
        this.treeId = treeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public String getCommitterName() {
        return this.committerName;
    }

    public String getCommitterEmail() {
        return this.committerEmail;
    }

    public List<String> getParentCommitIds() {
        return this.parentCommitIds;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getTreeId() {
        return this.treeId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RepositoryCommit(");
        sb.append("super=").append(super.toString());
        sb.append("commitId=").append(String.valueOf(this.commitId));
        sb.append(", commitMessage=").append(String.valueOf(this.commitMessage));
        sb.append(", authorName=").append(String.valueOf(this.authorName));
        sb.append(", authorEmail=").append(String.valueOf(this.authorEmail));
        sb.append(", committerName=").append(String.valueOf(this.committerName));
        sb.append(", committerEmail=").append(String.valueOf(this.committerEmail));
        sb.append(", parentCommitIds=").append(String.valueOf(this.parentCommitIds));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", treeId=").append(String.valueOf(this.treeId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepositoryCommit)) {
            return false;
        }
        RepositoryCommit other = (RepositoryCommit)((Object)o);
        return Objects.equals(this.commitId, other.commitId) && Objects.equals(this.commitMessage, other.commitMessage) && Objects.equals(this.authorName, other.authorName) && Objects.equals(this.authorEmail, other.authorEmail) && Objects.equals(this.committerName, other.committerName) && Objects.equals(this.committerEmail, other.committerEmail) && Objects.equals(this.parentCommitIds, other.parentCommitIds) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.treeId, other.treeId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.commitId == null ? 43 : this.commitId.hashCode());
        result = result * 59 + (this.commitMessage == null ? 43 : this.commitMessage.hashCode());
        result = result * 59 + (this.authorName == null ? 43 : this.authorName.hashCode());
        result = result * 59 + (this.authorEmail == null ? 43 : this.authorEmail.hashCode());
        result = result * 59 + (this.committerName == null ? 43 : this.committerName.hashCode());
        result = result * 59 + (this.committerEmail == null ? 43 : this.committerEmail.hashCode());
        result = result * 59 + (this.parentCommitIds == null ? 43 : this.parentCommitIds.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.treeId == null ? 43 : this.treeId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="commitId")
        private String commitId;
        @JsonProperty(value="commitMessage")
        private String commitMessage;
        @JsonProperty(value="authorName")
        private String authorName;
        @JsonProperty(value="authorEmail")
        private String authorEmail;
        @JsonProperty(value="committerName")
        private String committerName;
        @JsonProperty(value="committerEmail")
        private String committerEmail;
        @JsonProperty(value="parentCommitIds")
        private List<String> parentCommitIds;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="treeId")
        private String treeId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder commitId(String commitId) {
            this.commitId = commitId;
            this.__explicitlySet__.add("commitId");
            return this;
        }

        public Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            this.__explicitlySet__.add("commitMessage");
            return this;
        }

        public Builder authorName(String authorName) {
            this.authorName = authorName;
            this.__explicitlySet__.add("authorName");
            return this;
        }

        public Builder authorEmail(String authorEmail) {
            this.authorEmail = authorEmail;
            this.__explicitlySet__.add("authorEmail");
            return this;
        }

        public Builder committerName(String committerName) {
            this.committerName = committerName;
            this.__explicitlySet__.add("committerName");
            return this;
        }

        public Builder committerEmail(String committerEmail) {
            this.committerEmail = committerEmail;
            this.__explicitlySet__.add("committerEmail");
            return this;
        }

        public Builder parentCommitIds(List<String> parentCommitIds) {
            this.parentCommitIds = parentCommitIds;
            this.__explicitlySet__.add("parentCommitIds");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder treeId(String treeId) {
            this.treeId = treeId;
            this.__explicitlySet__.add("treeId");
            return this;
        }

        public RepositoryCommit build() {
            RepositoryCommit model = new RepositoryCommit(this.commitId, this.commitMessage, this.authorName, this.authorEmail, this.committerName, this.committerEmail, this.parentCommitIds, this.timeCreated, this.treeId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RepositoryCommit model) {
            if (model.wasPropertyExplicitlySet("commitId")) {
                this.commitId(model.getCommitId());
            }
            if (model.wasPropertyExplicitlySet("commitMessage")) {
                this.commitMessage(model.getCommitMessage());
            }
            if (model.wasPropertyExplicitlySet("authorName")) {
                this.authorName(model.getAuthorName());
            }
            if (model.wasPropertyExplicitlySet("authorEmail")) {
                this.authorEmail(model.getAuthorEmail());
            }
            if (model.wasPropertyExplicitlySet("committerName")) {
                this.committerName(model.getCommitterName());
            }
            if (model.wasPropertyExplicitlySet("committerEmail")) {
                this.committerEmail(model.getCommitterEmail());
            }
            if (model.wasPropertyExplicitlySet("parentCommitIds")) {
                this.parentCommitIds(model.getParentCommitIds());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("treeId")) {
                this.treeId(model.getTreeId());
            }
            return this;
        }
    }
}

