/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.parsing;

import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.jshell.model.ConsoleEvent;
import org.netbeans.modules.jshell.model.ConsoleListener;
import org.netbeans.modules.jshell.model.ConsoleModel;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.JShellToken;
import org.netbeans.modules.jshell.model.Rng;

public class LexerEmbeddingAdapter
implements ConsoleListener {
    @Override
    public void sectionCreated(ConsoleEvent e) {
        this.process(e.getSource(), e.getAffectedSections());
    }

    @Override
    public void sectionUpdated(ConsoleEvent e) {
        this.process(e.getSource(), e.getAffectedSections());
    }

    private void process(ConsoleModel model, List<ConsoleSection> sections) {
        Document d = model.getDocument();
        AtomicLockDocument ald = (AtomicLockDocument)LineDocumentUtils.as((Document)d, AtomicLockDocument.class);
        Runnable r = () -> {
            TokenHierarchy h = TokenHierarchy.get((Document)d);
            if (h == null) {
                return;
            }
            TokenSequence seq = h.tokenSequence();
            for (ConsoleSection s : sections) {
                if (!s.getType().java) continue;
                this.defineEmbeddings(seq, model, s);
            }
        };
        if (ald != null) {
            ald.runAtomicAsUser(r);
        } else {
            d.render(r);
        }
    }

    private void defineEmbeddings(TokenSequence seq, ConsoleModel model, ConsoleSection s) {
        block4: for (Rng r : s.getPartRanges()) {
            seq.move(r.start);
            block5: while (seq.moveNext() && seq.offset() < r.end) {
                Token tukac = seq.token();
                switch ((JShellToken)tukac.id()) {
                    case JAVA: {
                        seq.createEmbedding(JavaTokenId.language(), 0, 0);
                    }
                    case WHITESPACE: {
                        continue block5;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
        }
    }

    @Override
    public void executing(ConsoleEvent e) {
    }

    @Override
    public void closed(ConsoleEvent e) {
    }
}

