/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.AbstractResourceAccessor;

public class FileSystemResourceAccessor
extends AbstractResourceAccessor {
    private File baseDirectory;

    public FileSystemResourceAccessor() {
        this.baseDirectory = null;
    }

    public FileSystemResourceAccessor(String base) {
        this.baseDirectory = new File(base);
        if (!this.baseDirectory.isDirectory()) {
            throw new IllegalArgumentException(base + " must be a directory");
        }
    }

    @Override
    public Set<InputStream> getResourcesAsStream(String path) throws IOException {
        File absoluteFile = new File(path);
        File relativeFile = this.baseDirectory == null ? new File(path) : new File(this.baseDirectory, path);
        InputStream fileStream = null;
        if (absoluteFile.isAbsolute()) {
            try {
                fileStream = this.openStream(absoluteFile);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (fileStream == null) {
            try {
                fileStream = this.openStream(relativeFile);
            }
            catch (FileNotFoundException e2) {
                return null;
            }
        }
        HashSet<InputStream> returnSet = new HashSet<InputStream>();
        returnSet.add(fileStream);
        return returnSet;
    }

    private InputStream openStream(File file) throws IOException, FileNotFoundException {
        if (file.getName().toLowerCase().endsWith(".gz")) {
            return new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)));
        }
        return new BufferedInputStream(new FileInputStream(file));
    }

    @Override
    public Set<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        File finalDir;
        if (relativeTo == null) {
            finalDir = new File(this.baseDirectory, path);
        } else {
            finalDir = new File(this.baseDirectory, relativeTo);
            finalDir = new File(finalDir.getParentFile(), path);
        }
        if (finalDir.exists() && finalDir.isDirectory()) {
            HashSet<String> returnSet = new HashSet<String>();
            this.getContents(finalDir, recursive, includeFiles, includeDirectories, path, returnSet);
            return returnSet;
        }
        return null;
    }

    @Override
    protected String convertToPath(String string) {
        if (this.baseDirectory != null) {
            return string;
        }
        try {
            return "file:" + new File(string).getCanonicalPath().substring(this.baseDirectory.getCanonicalPath().length());
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    @Override
    public ClassLoader toClassLoader() {
        try {
            URL url = this.baseDirectory == null ? new File("/").toURI().toURL() : this.baseDirectory.toURI().toURL();
            return new URLClassLoader(new URL[]{url});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        File dir = this.baseDirectory;
        if (dir == null) {
            dir = new File(".");
        }
        return this.getClass().getName() + "(" + dir.getAbsolutePath() + ")";
    }
}

