/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.util.Objects;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.internal.EntityDiscriminatorSqmPathSource;
import org.hibernate.query.sqm.DiscriminatorSqmPath;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmEntityDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.spi.NavigablePath;

public class EntityDiscriminatorSqmPath<T>
extends AbstractSqmPath<T>
implements DiscriminatorSqmPath<T> {
    private final SqmEntityDomainType entityDomainType;
    private final EntityMappingType entityDescriptor;

    protected EntityDiscriminatorSqmPath(NavigablePath navigablePath, SqmPathSource referencedPathSource, SqmPath<?> lhs, SqmEntityDomainType entityDomainType, EntityMappingType entityDescriptor, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedPathSource, lhs, nodeBuilder);
        this.entityDomainType = entityDomainType;
        this.entityDescriptor = entityDescriptor;
    }

    public EntityDomainType getEntityDomainType() {
        return this.entityDomainType;
    }

    public EntityMappingType getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public EntityDiscriminatorSqmPathSource getExpressible() {
        return (EntityDiscriminatorSqmPathSource)this.getReferencedPathSource();
    }

    @Override
    public EntityDiscriminatorSqmPath copy(SqmCopyContext context) {
        EntityDiscriminatorSqmPath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        return context.registerCopy(this, (EntityDiscriminatorSqmPath)this.getLhs().copy(context).type());
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return this.entityDescriptor.hasSubclasses() ? walker.visitDiscriminatorPath(this) : walker.visitEntityTypeLiteralExpression(new SqmLiteralEntityType(this.entityDomainType, (NodeBuilder)this.nodeBuilder()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof EntityDiscriminatorSqmPath)) return false;
        EntityDiscriminatorSqmPath that = (EntityDiscriminatorSqmPath)object;
        if (!Objects.equals(this.getLhs(), that.getLhs())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.getLhs().hashCode();
    }
}

