/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.netty.util.AsciiString;
import io.vertx.core.MultiMap;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class Utils {
    public static void writeMetadata(Metadata metadata, MultiMap mmap) {
        byte[][] array = InternalMetadata.serialize((Metadata)metadata);
        for (int i = 0; i < array.length; i += 2) {
            AsciiString key = new AsciiString(array[i], false);
            AsciiString value = key.endsWith((CharSequence)"-bin") ? new AsciiString(Base64.getEncoder().encode(array[i + 1]), false) : new AsciiString(array[i + 1], false);
            mmap.add((CharSequence)key, (CharSequence)value);
        }
    }

    public static Metadata readMetadata(MultiMap headers) {
        List entries = headers.entries();
        byte[][] array = new byte[entries.size() * 2][];
        int idx = 0;
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            array[idx++] = key.getBytes(StandardCharsets.UTF_8);
            String value = (String)entry.getValue();
            byte[] data = key.endsWith("-bin") ? Base64.getDecoder().decode(value) : value.getBytes(StandardCharsets.UTF_8);
            array[idx++] = data;
        }
        return InternalMetadata.newMetadata((byte[][])array);
    }

    public static String utf8PercentEncode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name()).replace("+", "%20").replace("*", "%2A").replace("~", "%7E");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

