/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.jdbc.internal;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.hibernate.JDBCException;
import org.hibernate.resource.jdbc.ResourceRegistry;
import org.hibernate.resource.jdbc.internal.ResourceRegistryLogger;
import org.hibernate.resource.jdbc.internal.ResultSetsSet;
import org.hibernate.resource.jdbc.internal.ResultsetsTrackingContainer;
import org.hibernate.resource.jdbc.spi.JdbcEventHandler;

public final class ResourceRegistryStandardImpl
implements ResourceRegistry {
    private static final boolean IS_TRACE_ENABLED = ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.isTraceEnabled();
    private final JdbcEventHandler jdbcEventHandler;
    private final ResultsetsTrackingContainer xref = new ResultsetsTrackingContainer();
    private ExtendedState ext;
    private Statement lastQuery;

    public ResourceRegistryStandardImpl() {
        this(null);
    }

    public ResourceRegistryStandardImpl(JdbcEventHandler jdbcEventHandler) {
        this.jdbcEventHandler = jdbcEventHandler;
    }

    @Override
    public boolean hasRegisteredResources() {
        return this.xref.hasRegisteredResources() || this.ext != null && this.ext.hasRegisteredResources();
    }

    @Override
    public void register(Statement statement, boolean cancelable) {
        if (IS_TRACE_ENABLED) {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.registeringStatement(statement);
        }
        this.xref.registerExpectingNew(statement);
        if (cancelable) {
            this.lastQuery = statement;
        }
    }

    @Override
    public void release(Statement statement) {
        ResultSetsSet resultSets;
        if (IS_TRACE_ENABLED) {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.releasingStatement(statement);
        }
        if ((resultSets = this.xref.remove(statement)) != null) {
            ResourceRegistryStandardImpl.closeAll(resultSets);
        } else {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.unregisteredStatement();
        }
        ResourceRegistryStandardImpl.close(statement);
        if (this.lastQuery == statement) {
            this.lastQuery = null;
        }
    }

    @Override
    public void release(ResultSet resultSet, Statement statement) {
        if (IS_TRACE_ENABLED) {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.releasingResultSet(resultSet);
        }
        if (statement == null) {
            try {
                statement = resultSet.getStatement();
            }
            catch (SQLException e) {
                throw this.convert(e, "Unable to access Statement from ResultSet");
            }
        }
        if (statement != null) {
            ResultSetsSet resultSets = this.xref.getForResultSetRemoval(statement);
            if (resultSets == null) {
                ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.unregisteredStatement();
            } else {
                resultSets.removeResultSet(resultSet);
                if (resultSets.isEmpty()) {
                    try {
                        if (statement.isClosed()) {
                            this.xref.remove(statement);
                        }
                    }
                    catch (SQLException e) {
                        ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.unableToReleaseStatement(e.getMessage());
                    }
                }
            }
        } else if (this.ext != null) {
            this.ext.releaseUnassociatedResult(resultSet);
        }
        ResourceRegistryStandardImpl.close(resultSet);
    }

    private static void closeAll(ResultSetsSet resultSets) {
        if (resultSets != null) {
            resultSets.forEachResultSet(ResourceRegistryStandardImpl::close);
        }
    }

    private static void releaseXref(Statement statement, ResultSetsSet resultSetsSet) {
        ResourceRegistryStandardImpl.closeAll(resultSetsSet);
        ResourceRegistryStandardImpl.close(statement);
    }

    private static void close(ResultSet resultSet) {
        if (IS_TRACE_ENABLED) {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.closingResultSet(resultSet);
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.unableToReleaseResultSet(e.getMessage());
        }
        catch (Exception e) {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.unableToReleaseResultSet(e.getMessage());
        }
    }

    private static void close(Statement statement) {
        if (IS_TRACE_ENABLED) {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.closingPreparedStatement(statement);
        }
        try {
            try {
                if (statement.getMaxRows() != 0) {
                    statement.setMaxRows(0);
                }
                if (statement.getQueryTimeout() != 0) {
                    statement.setQueryTimeout(0);
                }
            }
            catch (SQLException sqle) {
                if (ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.isDebugEnabled()) {
                    ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.exceptionClearingMaxRowsOrQueryTimeout(sqle.getMessage());
                }
                return;
            }
            statement.close();
        }
        catch (SQLException e) {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.unableToReleaseStatement(e.getMessage());
        }
        catch (Exception e) {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.unableToReleaseStatement(e.getMessage());
        }
    }

    @Override
    public void register(ResultSet resultSet, Statement statement) {
        if (IS_TRACE_ENABLED) {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.registeringResultSet(resultSet);
        }
        if (statement == null) {
            try {
                statement = resultSet.getStatement();
            }
            catch (SQLException e) {
                throw this.convert(e, "Unable to access Statement from ResultSet");
            }
        }
        if (statement != null) {
            this.xref.storeAssociatedResultset(statement, resultSet);
        } else {
            this.getExtendedStateForWrite().storeUnassociatedResultset(resultSet);
        }
    }

    private ExtendedState getExtendedStateForWrite() {
        if (this.ext == null) {
            this.ext = new ExtendedState();
        }
        return this.ext;
    }

    private JDBCException convert(SQLException e, String s) {
        return new JDBCException(s, e);
    }

    @Override
    public void register(Blob blob) {
        this.getExtendedStateForWrite().registerBlob(blob);
    }

    @Override
    public void release(Blob blob) {
        if (this.ext != null && this.ext.blobs != null) {
            this.ext.blobs.remove(blob);
        } else {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.noRegisteredLobs(Blob.class.getSimpleName());
        }
    }

    @Override
    public void register(Clob clob) {
        this.getExtendedStateForWrite().registerClob(clob);
    }

    @Override
    public void release(Clob clob) {
        if (this.ext != null && this.ext.clobs != null) {
            this.ext.clobs.remove(clob);
        } else {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.noRegisteredLobs(Clob.class.getSimpleName());
        }
    }

    @Override
    public void register(NClob nclob) {
        this.getExtendedStateForWrite().registerNClob(nclob);
    }

    @Override
    public void release(NClob nclob) {
        if (this.ext != null && this.ext.nclobs != null) {
            this.ext.nclobs.remove(nclob);
        } else {
            ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.noRegisteredLobs(NClob.class.getSimpleName());
        }
    }

    @Override
    public void cancelLastQuery() {
        try {
            if (this.lastQuery != null) {
                this.lastQuery.cancel();
            }
        }
        catch (SQLException e) {
            throw this.convert(e, "Could not cancel query");
        }
        finally {
            this.lastQuery = null;
        }
    }

    @Override
    public void releaseResources() {
        ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.releasingResources();
        if (this.jdbcEventHandler != null) {
            this.jdbcEventHandler.jdbcReleaseRegistryResourcesStart();
        }
        this.xref.forEach(ResourceRegistryStandardImpl::releaseXref);
        this.xref.clear();
        if (this.ext != null) {
            this.ext.releaseResources();
        }
        if (this.jdbcEventHandler != null) {
            this.jdbcEventHandler.jdbcReleaseRegistryResourcesEnd();
        }
    }

    private static boolean hasRegistered(ResultSetsSet resource) {
        return resource != null && !resource.isEmpty();
    }

    private static boolean hasRegistered(ArrayList<?> resource) {
        return resource != null && !resource.isEmpty();
    }

    private static class ExtendedState {
        private ResultSetsSet unassociatedResultSets;
        private ArrayList<Blob> blobs;
        private ArrayList<Clob> clobs;
        private ArrayList<NClob> nclobs;

        private ExtendedState() {
        }

        public boolean hasRegisteredResources() {
            return ResourceRegistryStandardImpl.hasRegistered(this.unassociatedResultSets) || ResourceRegistryStandardImpl.hasRegistered(this.blobs) || ResourceRegistryStandardImpl.hasRegistered(this.clobs) || ResourceRegistryStandardImpl.hasRegistered(this.nclobs);
        }

        public void releaseUnassociatedResult(ResultSet resultSet) {
            ResultSet removed;
            ResultSet resultSet2 = removed = this.unassociatedResultSets == null ? null : this.unassociatedResultSets.removeResultSet(resultSet);
            if (removed == null) {
                ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.unregisteredResultSetWithoutStatement();
            }
        }

        public void storeUnassociatedResultset(ResultSet resultSet) {
            if (this.unassociatedResultSets == null) {
                this.unassociatedResultSets = new ResultSetsSet();
            }
            this.unassociatedResultSets.storeResultSet(resultSet);
        }

        public void registerBlob(Blob blob) {
            if (this.blobs == null) {
                this.blobs = new ArrayList();
            }
            this.blobs.add(blob);
        }

        public void registerClob(Clob clob) {
            if (this.clobs == null) {
                this.clobs = new ArrayList();
            }
            this.clobs.add(clob);
        }

        public void registerNClob(NClob nclob) {
            if (this.nclobs == null) {
                this.nclobs = new ArrayList();
            }
            this.nclobs.add(nclob);
        }

        public void releaseResources() {
            ResourceRegistryStandardImpl.closeAll(this.unassociatedResultSets);
            this.unassociatedResultSets.clear();
            if (this.blobs != null) {
                this.blobs.forEach(blob -> {
                    try {
                        blob.free();
                    }
                    catch (SQLException e) {
                        ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.unableToFreeLob(Blob.class.getSimpleName(), e.getMessage());
                    }
                });
                this.blobs = null;
            }
            if (this.clobs != null) {
                this.clobs.forEach(clob -> {
                    try {
                        clob.free();
                    }
                    catch (SQLException e) {
                        ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.unableToFreeLob(Clob.class.getSimpleName(), e.getMessage());
                    }
                });
                this.clobs = null;
            }
            if (this.nclobs != null) {
                this.nclobs.forEach(nclob -> {
                    try {
                        nclob.free();
                    }
                    catch (SQLException e) {
                        ResourceRegistryLogger.RESOURCE_REGISTRY_LOGGER.unableToFreeLob(NClob.class.getSimpleName(), e.getMessage());
                    }
                });
                this.nclobs = null;
            }
        }
    }
}

