/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;

public enum NumericTypeCategory {
    INTEGER,
    LONG,
    BIG_INTEGER,
    DOUBLE,
    FLOAT,
    BIG_DECIMAL;


    public <N extends Number> N parseLiteralValue(String value) {
        switch (this.ordinal()) {
            case 0: {
                return (N)Integer.valueOf(value);
            }
            case 1: {
                return (N)Long.valueOf(value);
            }
            case 2: {
                return (N)new BigInteger(value);
            }
            case 3: {
                return (N)Double.valueOf(value);
            }
            case 4: {
                return (N)Float.valueOf(value);
            }
            case 5: {
                return (N)new BigDecimal(value);
            }
        }
        throw new IllegalStateException(String.format(Locale.ROOT, "Unable to parse numeric literal value `%s` - %s", value, this.name()));
    }
}

