/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import icons.DvcsImplIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgDisposable;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.branch.HgBranchAbstractAction;
import org.zmlx.hg4idea.branch.HgBranchType;
import org.zmlx.hg4idea.branch.HgCommonBranchActions;
import org.zmlx.hg4idea.command.HgBookmarkCommand;
import org.zmlx.hg4idea.command.HgBranchCreateCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.commit.HgCloseBranchExecutor;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.ui.HgBookmarkDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public final class HgBranchPopupActions {
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgRepository myRepository;

    HgBranchPopupActions(@NotNull Project project, @NotNull HgRepository repository) {
        if (project == null) {
            HgBranchPopupActions.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            HgBranchPopupActions.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions() {
        return this.createActions(null, null, false);
    }

    ActionGroup createActions(@Nullable LightActionGroup toInsert, @Nullable HgRepository specificRepository, boolean firstLevelGroup) {
        LightActionGroup popupGroup = new LightActionGroup(false);
        popupGroup.addAction((AnAction)new HgNewBranchAction(this.myProject, Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgNewBookmarkAction(Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgCloseBranchAction(Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgShowUnnamedHeadsForCurrentBranchAction(this.myRepository));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator(specificRepository == null ? HgBundle.message("hg4idea.branch.bookmarks", new Object[0]) : HgBundle.message("hg4idea.branch.bookmarks.in.repo", DvcsUtil.getShortRepositoryName((Repository)specificRepository)));
        String currentBookmark = this.myRepository.getCurrentBookmark();
        List bookmarkActions = ((StreamEx)((StreamEx)StreamEx.of(HgUtil.getSortedNamesWithoutHashes(this.myRepository.getBookmarks())).filter(bm -> !bm.equals(currentBookmark))).map(bm -> new BookmarkActions(this.myProject, Collections.singletonList(this.myRepository), (String)bm)).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR)).toList();
        int topShownBookmarks = BranchActionUtil.getNumOfTopShownBranches((List)bookmarkActions);
        if (currentBookmark != null) {
            bookmarkActions = ContainerUtil.prepend((List)bookmarkActions, (Object[])new BookmarkActions[]{new CurrentActiveBookmark(this.myProject, Collections.singletonList(this.myRepository), currentBookmark)});
            ++topShownBookmarks;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)bookmarkActions, (int)topShownBookmarks, (String)(firstLevelGroup ? "Hg.Branch.Popup.ShowAllBookmarks" : null), (boolean)firstLevelGroup);
        popupGroup.addSeparator(specificRepository == null ? HgBundle.message("hg4idea.branch.branches.separator", new Object[0]) : HgBundle.message("hg4idea.branch.branches.in.repo.separator", DvcsUtil.getShortRepositoryName((Repository)specificRepository)));
        List branchActions = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(this.myRepository.getOpenedBranches()).sorted(StringUtil::naturalCompare)).filter(b -> !b.equals(this.myRepository.getCurrentBranch()))).map(b -> new BranchActions(this.myProject, Collections.singletonList(this.myRepository), (String)b)).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR)).prepend((Object)new CurrentBranch(this.myProject, Collections.singletonList(this.myRepository), this.myRepository.getCurrentBranch())).toList();
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)branchActions, (int)(BranchActionUtil.getNumOfTopShownBranches((List)branchActions) + 1), (String)(firstLevelGroup ? "Hg.Branch.Popup.ShowAllBranches" : null), (boolean)firstLevelGroup);
        return popupGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "repository";
                break;
            }
        }
        objectArray[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class HgNewBranchAction
    extends NewBranchAction<HgRepository> {
        @NotNull
        final HgRepository myPreselectedRepo;

        public HgNewBranchAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            if (project == null) {
                HgNewBranchAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                HgNewBranchAction.$$$reportNull$$$0(1);
            }
            if (preselectedRepo == null) {
                HgNewBranchAction.$$$reportNull$$$0(2);
            }
            super(project, repositories);
            this.myPreselectedRepo = preselectedRepo;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String name;
            if (e == null) {
                HgNewBranchAction.$$$reportNull$$$0(3);
            }
            if ((name = HgUtil.getNewBranchNameFromUser(this.myPreselectedRepo, HgBundle.message("hg4idea.branch.create", new Object[0]))) == null) {
                return;
            }
            new Task.Backgroundable(this.myProject, HgBundle.message("hg4idea.branch.creating.progress", this.myRepositories.size())){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.createNewBranchInCurrentThread(name);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction$1", "run"));
                }
            }.queue();
        }

        public void createNewBranchInCurrentThread(@NotNull String name) {
            if (name == null) {
                HgNewBranchAction.$$$reportNull$$$0(4);
            }
            for (HgRepository repository : this.myRepositories) {
                try {
                    HgCommandResult result = new HgBranchCreateCommand(this.myProject, repository.getRoot(), name).executeInCurrentThread();
                    repository.update();
                    if (!HgErrorUtil.hasErrorsInCommandExecution(result)) continue;
                    new HgCommandResultNotifier(this.myProject).notifyError("hg.branch.creation.error", result, HgBundle.message("hg4idea.branch.creation.error", new Object[0]), HgBundle.message("hg4idea.branch.creation.error.msg", name));
                }
                catch (HgCommandException exception) {
                    HgErrorUtil.handleException(this.myProject, "hg.branch.creation.error", HgBundle.message("hg4idea.branch.cannot.create", new Object[0]), exception);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preselectedRepo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNewBranchInCurrentThread";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class HgNewBookmarkAction
    extends DumbAwareAction {
        @NotNull
        final List<HgRepository> myRepositories;
        @NotNull
        final HgRepository myPreselectedRepo;

        HgNewBookmarkAction(@NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            if (repositories == null) {
                HgNewBookmarkAction.$$$reportNull$$$0(0);
            }
            if (preselectedRepo == null) {
                HgNewBookmarkAction.$$$reportNull$$$0(1);
            }
            super(HgBundle.messagePointer("action.hg4idea.bookmark.new", new Object[0]), HgBundle.messagePointer("action.hg4idea.bookmark.new.description", new Object[0]), AllIcons.General.Add);
            this.myRepositories = repositories;
            this.myPreselectedRepo = preselectedRepo;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                HgNewBookmarkAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HgNewBookmarkAction.$$$reportNull$$$0(3);
            }
            DvcsUtil.disableActionIfAnyRepositoryIsFresh((AnActionEvent)e, this.myRepositories, (String)HgBundle.message("action.not.possible.in.fresh.repo.new.bookmark", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String name;
            HgBookmarkDialog bookmarkDialog;
            if (e == null) {
                HgNewBookmarkAction.$$$reportNull$$$0(4);
            }
            if ((bookmarkDialog = new HgBookmarkDialog(this.myPreselectedRepo)).showAndGet() && !StringUtil.isEmptyOrSpaces((String)(name = bookmarkDialog.getName()))) {
                HgBookmarkCommand.createBookmarkAsynchronously(this.myRepositories, name, bookmarkDialog.isActive());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preselectedRepo";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBookmarkAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBookmarkAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    static final class HgCloseBranchAction
    extends DumbAwareAction {
        @NotNull
        private final List<HgRepository> myRepositories;
        @NotNull
        final HgRepository myPreselectedRepo;

        HgCloseBranchAction(@NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            if (repositories == null) {
                HgCloseBranchAction.$$$reportNull$$$0(0);
            }
            if (preselectedRepo == null) {
                HgCloseBranchAction.$$$reportNull$$$0(1);
            }
            super(HgBundle.messagePointer("action.hg4idea.branch.close", repositories.size()), HgBundle.messagePointer("action.hg4idea.branch.close.description", repositories.size()), AllIcons.Actions.Cancel);
            this.myRepositories = repositories;
            this.myPreselectedRepo = preselectedRepo;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                HgCloseBranchAction.$$$reportNull$$$0(2);
            }
            Project project = this.myPreselectedRepo.getProject();
            StoreUtil.saveDocumentsAndProjectSettings((Project)project);
            ChangeListManager.getInstance((Project)project).invokeAfterUpdateWithModal(true, VcsBundle.message((String)"waiting.changelists.update.for.show.commit.dialog.message", (Object[])new Object[0]), () -> this.commitAndCloseBranch(project));
        }

        private void commitAndCloseBranch(@NotNull Project project) {
            if (project == null) {
                HgCloseBranchAction.$$$reportNull$$$0(3);
            }
            LocalChangeList activeChangeList = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
            HgVcs vcs = HgVcs.getInstance(project);
            assert (vcs != null);
            HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
            List changesForRepositories = ContainerUtil.filter((Collection)activeChangeList.getChanges(), change -> this.myRepositories.contains(repositoryManager.getRepositoryForFile(ChangesUtil.getFilePath((Change)change))));
            Set<HgVcs> affectedVcses = Collections.singleton(vcs);
            List<HgCloseBranchExecutor> executors = Collections.singletonList(new HgCloseBranchExecutor(this.myRepositories));
            String commitMessage = "Close Branch";
            CommitChangeListDialog.showCommitDialog((Project)project, affectedVcses, (Collection)changesForRepositories, (LocalChangeList)activeChangeList, executors, (boolean)false, (String)commitMessage, null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                HgCloseBranchAction.$$$reportNull$$$0(4);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HgCloseBranchAction.$$$reportNull$$$0(5);
            }
            e.getPresentation().setEnabledAndVisible(ContainerUtil.and(this.myRepositories, repository -> repository.getOpenedBranches().contains(repository.getCurrentBranch())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preselectedRepo";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgCloseBranchAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgCloseBranchAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "commitAndCloseBranch";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class HgShowUnnamedHeadsForCurrentBranchAction
    extends ActionGroup
    implements DumbAware {
        @NotNull
        final HgRepository myRepository;
        @NotNull
        final String myCurrentBranchName;
        @NotNull
        final Collection<Hash> myHeads;

        public HgShowUnnamedHeadsForCurrentBranchAction(@NotNull HgRepository repository) {
            if (repository == null) {
                HgShowUnnamedHeadsForCurrentBranchAction.$$$reportNull$$$0(0);
            }
            super(Presentation.NULL_STRING, true);
            this.myRepository = repository;
            this.myCurrentBranchName = repository.getCurrentBranch();
            this.getTemplatePresentation().setText(HgBundle.message("action.hg4idea.show.unnamed.heads", this.myCurrentBranchName));
            this.myHeads = this.filterUnnamedHeads();
        }

        @NotNull
        private Collection<Hash> filterUnnamedHeads() {
            Collection branchWithHashes = this.myRepository.getBranches().get(this.myCurrentBranchName);
            String currentHead = this.myRepository.getCurrentRevision();
            if (branchWithHashes == null || currentHead == null || this.myRepository.getState() != Repository.State.NORMAL) {
                Set<Hash> set = Collections.emptySet();
                if (set == null) {
                    HgShowUnnamedHeadsForCurrentBranchAction.$$$reportNull$$$0(1);
                }
                return set;
            }
            List bookmarkHashes = ContainerUtil.map(this.myRepository.getBookmarks(), info -> info.getHash());
            branchWithHashes.removeAll(bookmarkHashes);
            branchWithHashes.remove(HashImpl.build((String)currentHead));
            Collection collection = branchWithHashes;
            if (collection == null) {
                HgShowUnnamedHeadsForCurrentBranchAction.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            ArrayList<HgCommonBranchActions> branchHeadActions = new ArrayList<HgCommonBranchActions>();
            for (Hash hash : this.myHeads) {
                branchHeadActions.add(new HgCommonBranchActions(this.myRepository.getProject(), Collections.singletonList(this.myRepository), hash.toShortString()));
            }
            AnAction[] anActionArray = branchHeadActions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                HgShowUnnamedHeadsForCurrentBranchAction.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                HgShowUnnamedHeadsForCurrentBranchAction.$$$reportNull$$$0(4);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HgShowUnnamedHeadsForCurrentBranchAction.$$$reportNull$$$0(5);
            }
            if (this.myRepository.isFresh() || this.myHeads.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else if (this.myRepository.getState() != Repository.State.NORMAL) {
                e.getPresentation().setEnabled(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterUnnamedHeads";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    static class BookmarkActions
    extends HgCommonBranchActions {
        BookmarkActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                BookmarkActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                BookmarkActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                BookmarkActions.$$$reportNull$$$0(2);
            }
            super(project, repositories, branchName, HgBranchType.BOOKMARK);
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = (AnAction[])ArrayUtil.append((Object[])super.getChildren(e), (Object)((Object)new DeleteBookmarkAction(this.myProject, this.myRepositories, this.myBranchName)));
            if (anActionArray == null) {
                BookmarkActions.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }

        private static final class DeleteBookmarkAction
        extends HgBranchAbstractAction {
            DeleteBookmarkAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    DeleteBookmarkAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    DeleteBookmarkAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    DeleteBookmarkAction.$$$reportNull$$$0(2);
                }
                super(project, CommonBundle.messagePointer((String)"button.delete", (Object[])new Object[0]), repositories, branchName);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    DeleteBookmarkAction.$$$reportNull$$$0(3);
                }
                BackgroundTaskUtil.executeOnPooledThread((Disposable)HgDisposable.getInstance(this.myProject), () -> {
                    for (HgRepository repository : this.myRepositories) {
                        HgBookmarkCommand.deleteBookmarkSynchronously(this.myProject, repository.getRoot(), this.myBranchName);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "branchName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions$DeleteBookmarkAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    static final class CurrentActiveBookmark
    extends BookmarkActions
    implements PopupElementWithAdditionalInfo {
        CurrentActiveBookmark(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                CurrentActiveBookmark.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CurrentActiveBookmark.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CurrentActiveBookmark.$$$reportNull$$$0(2);
            }
            super(project, repositories, branchName);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new BookmarkActions.DeleteBookmarkAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                CurrentActiveBookmark.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$CurrentActiveBookmark";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$CurrentActiveBookmark";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class CurrentBranch
    extends BranchActions
    implements PopupElementWithAdditionalInfo {
        CurrentBranch(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                CurrentBranch.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CurrentBranch.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CurrentBranch.$$$reportNull$$$0(2);
            }
            super(project, repositories, branchName);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        }

        @Override
        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (AnAction.EMPTY_ARRAY == null) {
                CurrentBranch.$$$reportNull$$$0(3);
            }
            return AnAction.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$CurrentBranch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$CurrentBranch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static class BranchActions
    extends HgCommonBranchActions {
        BranchActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                BranchActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                BranchActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                BranchActions.$$$reportNull$$$0(2);
            }
            super(project, repositories, branchName, HgBranchType.BRANCH);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "branchName";
                    break;
                }
            }
            objectArray[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$BranchActions";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

