/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.tasks;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.nativeplatform.toolchain.internal.xcode.SwiftStdlibToolLocator;
import org.gradle.process.ExecOperations;
import org.gradle.util.internal.GFileUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class InstallXCTestBundle
extends DefaultTask {
    private final DirectoryProperty installDirectory;
    private final RegularFileProperty bundleBinaryFile;

    public InstallXCTestBundle() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.installDirectory = objectFactory.directoryProperty();
        this.bundleBinaryFile = objectFactory.fileProperty();
        this.dependsOn(new Object[]{this.bundleBinaryFile});
    }

    @Inject
    protected SwiftStdlibToolLocator getSwiftStdlibToolLocator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileSystem getFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected FileSystemOperations getFileSystemOperations() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    protected void install() throws IOException {
        File bundleFile = ((RegularFile)this.bundleBinaryFile.get()).getAsFile();
        File bundleDir = ((Directory)this.installDirectory.get()).file(bundleFile.getName() + ".xctest").getAsFile();
        this.installToDir(bundleDir, bundleFile);
        File runScript = ((RegularFile)this.getRunScriptFile().get()).getAsFile();
        String runScriptText = "#!/bin/sh\nAPP_BASE_NAME=`dirname \"$0\"`\nXCTEST_LOCATION=`xcrun --find xctest`\nexec \"$XCTEST_LOCATION\" \"$@\" \"$APP_BASE_NAME/" + bundleDir.getName() + "\"\n";
        GFileUtils.writeFile((String)runScriptText, (File)runScript);
        this.getFileSystem().chmod(runScript, 493);
    }

    private void installToDir(File bundleDir, File bundleFile) throws IOException {
        this.getFileSystemOperations().sync(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)topSpec -> {
            topSpec.from((Object)bundleFile, SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)spec -> spec.into((Object)"Contents/MacOS")));
            topSpec.into((Object)bundleDir);
        }));
        File outputFile = new File(bundleDir, "Contents/Info.plist");
        Files.asCharSink((File)outputFile, (Charset)Charset.forName("UTF-8"), (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict/>\n</plist>");
        this.getExecOperations().exec(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)execSpec -> {
            execSpec.setWorkingDir(bundleDir);
            execSpec.executable((Object)this.getSwiftStdlibToolLocator().find());
            execSpec.args(new Object[]{"--copy", "--scan-executable", bundleFile.getAbsolutePath(), "--destination", new File(bundleDir, "Contents/Frameworks").getAbsolutePath(), "--platform", "macosx", "--resource-destination", new File(bundleDir, "Contents/Resources").getAbsolutePath(), "--scan-folder", new File(bundleDir, "Contents/Frameworks").getAbsolutePath()});
        })).assertNormalExitValue();
    }

    @Internal
    public Provider<RegularFile> getRunScriptFile() {
        return this.installDirectory.file(this.bundleBinaryFile.getLocationOnly().map(SerializableLambdas.transformer((SerializableLambdas.SerializableTransformer & Serializable)file -> FilenameUtils.removeExtension((String)file.getAsFile().getName()))));
    }

    @Internal(value="covered by getBundleBinary()")
    public RegularFileProperty getBundleBinaryFile() {
        return this.bundleBinaryFile;
    }

    @SkipWhenEmpty
    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputFile
    protected File getBundleBinary() {
        RegularFile bundle = (RegularFile)this.getBundleBinaryFile().get();
        File bundleFile = bundle.getAsFile();
        if (!bundleFile.exists()) {
            return null;
        }
        return bundleFile;
    }

    @OutputDirectory
    public DirectoryProperty getInstallDirectory() {
        return this.installDirectory;
    }

    @Inject
    protected abstract ExecOperations getExecOperations();
}

