/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.describer;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.internal.component.resolution.failure.describer.AbstractResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.exception.ArtifactSelectionException;
import org.gradle.internal.component.resolution.failure.transform.SourceVariantData;
import org.gradle.internal.component.resolution.failure.transform.TransformationChainData;
import org.gradle.internal.component.resolution.failure.type.AmbiguousArtifactTransformsFailure;
import org.gradle.internal.logging.text.TreeFormatter;

public abstract class AmbiguousArtifactTransformsFailureDescriber
extends AbstractResolutionFailureDescriber<AmbiguousArtifactTransformsFailure> {
    private static final String ARTIFACT_TRANSFORMS_REPORT_SUGGESTION = "Run the :artifactTransforms report to see the available artifact transforms.";
    private static final String AMBIGUOUS_TRANSFORMATION_PREFIX = "Transformation failures are explained in more detail at ";
    private static final String AMBIGUOUS_TRANSFORMATION_SECTION = "sub:transform-ambiguity";

    public ArtifactSelectionException describeFailure(AmbiguousArtifactTransformsFailure failure) {
        String message = this.buildFailureMsg(failure);
        List<String> resolutions = this.buildResolutions(ARTIFACT_TRANSFORMS_REPORT_SUGGESTION, this.suggestSpecificDocumentation(AMBIGUOUS_TRANSFORMATION_PREFIX, AMBIGUOUS_TRANSFORMATION_SECTION), this.suggestReviewAlgorithm());
        return new ArtifactSelectionException(message, failure, resolutions);
    }

    private String buildFailureMsg(AmbiguousArtifactTransformsFailure failure) {
        TreeFormatter formatter = new TreeFormatter(true);
        formatter.node("Found multiple transformation chains that produce a variant of '" + failure.describeRequestTarget() + "' with requested attributes");
        this.formatSortedAttributes(formatter, (AttributeContainer)failure.getRequestedAttributes());
        formatter.node("Found the following transformation chains");
        Comparator<TransformationChainData> variantDataComparator = Comparator.comparing(TransformationChainData::summarizeTransformations).thenComparing(x -> x.getFinalAttributes().toString());
        Map transformationPaths = failure.getPotentialVariants().stream().collect(Collectors.groupingBy(TransformationChainData::getInitialVariant, () -> new TreeMap(Comparator.comparing(SourceVariantData::getVariantName)), Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(variantDataComparator).collect(Collectors.toList()))));
        formatter.startChildren();
        transformationPaths.forEach((root, transformations) -> {
            this.formatSourceVariant((SourceVariantData)root, formatter);
            formatter.node("Candidate transformation chains");
            formatter.startChildren();
            transformations.forEach(transformationChainData -> {
                formatter.node("Transformation chain: " + transformationChainData.summarizeTransformations());
                formatter.startChildren();
                transformationChainData.getSteps().forEach(step -> {
                    formatter.node("'" + step.getTransformName() + "'");
                    formatter.startChildren();
                    formatter.node("Converts from attributes");
                    this.formatSortedAttributes(formatter, (AttributeContainer)step.getFromAttributes());
                    formatter.node("To attributes");
                    this.formatSortedAttributes(formatter, (AttributeContainer)step.getToAttributes());
                    formatter.endChildren();
                });
                formatter.endChildren();
            });
            formatter.endChildren();
            formatter.endChildren();
        });
        formatter.endChildren();
        return formatter.toString();
    }

    private void formatSourceVariant(SourceVariantData sourceVariantData, TreeFormatter formatter) {
        formatter.node("From " + sourceVariantData.getFormattedVariantName());
        formatter.startChildren();
        formatter.node("With source attributes");
        this.formatSortedAttributes(formatter, (AttributeContainer)sourceVariantData.getAttributes());
    }

    private void formatSortedAttributes(TreeFormatter formatter, AttributeContainer attributes) {
        formatter.startChildren();
        for (Attribute attribute : Ordering.usingToString().sortedCopy((Iterable)attributes.keySet())) {
            formatter.node(attribute.getName() + " '" + attributes.getAttribute(attribute) + "'");
        }
        formatter.endChildren();
    }
}

